<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://api-b2b.pwrs.ru/WCF/ClientService.svc?singleWsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://api-b2b.pwrs.ru/WCF/ClientService.svc?singleWsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetFindTyre operation/method
 */
if ($get->GetFindTyre(new \StructType\GetFindTyre()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFindDisk operation/method
 */
if ($get->GetFindDisk(new \StructType\GetFindDisk()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetGoodsPriceRestByCode operation/method
 */
if ($get->GetGoodsPriceRestByCode(new \StructType\GetGoodsPriceRestByCode()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetGoodsInfo operation/method
 */
if ($get->GetGoodsInfo(new \StructType\GetGoodsInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetGoodsByCar operation/method
 */
if ($get->GetGoodsByCar(new \StructType\GetGoodsByCar()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMarkaAvto operation/method
 */
if ($get->GetMarkaAvto(new \StructType\GetMarkaAvto()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetModelAvto operation/method
 */
if ($get->GetModelAvto(new \StructType\GetModelAvto()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetYearAvto operation/method
 */
if ($get->GetYearAvto(new \StructType\GetYearAvto()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetModificationAvto operation/method
 */
if ($get->GetModificationAvto(new \StructType\GetModificationAvto()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetChangeOrder operation/method
 */
if ($get->GetChangeOrder(new \StructType\GetChangeOrder()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrderStatus operation/method
 */
if ($get->GetOrderStatus(new \StructType\GetOrderStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrderInfo operation/method
 */
if ($get->GetOrderInfo(new \StructType\GetOrderInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStatusList operation/method
 */
if ($get->GetStatusList(new \StructType\GetStatusList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrderComment operation/method
 */
if ($get->GetOrderComment(new \StructType\GetOrderComment()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserList operation/method
 */
if ($get->GetUserList(new \StructType\GetUserList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetWarehouses operation/method
 */
if ($get->GetWarehouses(new \StructType\GetWarehouses()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPressureSensor operation/method
 */
if ($get->GetPressureSensor(new \StructType\GetPressureSensor()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMovementList operation/method
 */
if ($get->GetMovementList(new \StructType\GetMovementList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMovementInfo operation/method
 */
if ($get->GetMovementInfo(new \StructType\GetMovementInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFastener operation/method
 */
if ($get->GetFastener(new \StructType\GetFastener()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAddressList operation/method
 */
if ($get->GetAddressList(new \StructType\GetAddressList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDeliveryPeriod operation/method
 */
if ($get->GetDeliveryPeriod(new \StructType\GetDeliveryPeriod()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSaleInfo operation/method
 */
if ($get->GetSaleInfo(new \StructType\GetSaleInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSaleList operation/method
 */
if ($get->GetSaleList(new \StructType\GetSaleList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetConsumable operation/method
 */
if ($get->GetConsumable(new \StructType\GetConsumable()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetConsigneeList operation/method
 */
if ($get->GetConsigneeList(new \StructType\GetConsigneeList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for SetRest operation/method
 */
if ($set->SetRest(new \StructType\SetRest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetPrice operation/method
 */
if ($set->SetPrice(new \StructType\SetPrice()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetOrderStatus operation/method
 */
if ($set->SetOrderStatus(new \StructType\SetOrderStatus()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetOrderStatusSatellite operation/method
 */
if ($set->SetOrderStatusSatellite(new \StructType\SetOrderStatusSatellite()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetMergeOrders operation/method
 */
if ($set->SetMergeOrders(new \StructType\SetMergeOrders()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetOrderComment operation/method
 */
if ($set->SetOrderComment(new \StructType\SetOrderComment()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCancelDelivery operation/method
 */
if ($set->SetCancelDelivery(new \StructType\SetCancelDelivery()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetDeliveryInfo operation/method
 */
if ($set->SetDeliveryInfo(new \StructType\SetDeliveryInfo()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetToMove operation/method
 */
if ($set->SetToMove(new \StructType\SetToMove()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetMovementStatus operation/method
 */
if ($set->SetMovementStatus(new \StructType\SetMovementStatus()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetDeliveryAddress operation/method
 */
if ($set->SetDeliveryAddress(new \StructType\SetDeliveryAddress()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetOrderDelivery operation/method
 */
if ($set->SetOrderDelivery(new \StructType\SetOrderDelivery()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetRemoveFromOH operation/method
 */
if ($set->SetRemoveFromOH(new \StructType\SetRemoveFromOH()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetMarkCodeList operation/method
 */
if ($set->SetMarkCodeList(new \StructType\SetMarkCodeList()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for CreateOrder operation/method
 */
if ($create->CreateOrder(new \StructType\CreateOrder()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateMovement operation/method
 */
if ($create->CreateMovement(new \StructType\CreateMovement()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateConsignee operation/method
 */
if ($create->CreateConsignee(new \StructType\CreateConsignee()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Ping ServiceType
 */
$ping = new \ServiceType\Ping($options);
/**
 * Sample call for Ping operation/method
 */
if ($ping->Ping(new \StructType\Ping()) !== false) {
    print_r($ping->getResult());
} else {
    print_r($ping->getLastError());
}
/**
 * Samples for Tire ServiceType
 */
$tire = new \ServiceType\Tire($options);
/**
 * Sample call for TireCalc operation/method
 */
if ($tire->TireCalc(new \StructType\TireCalc()) !== false) {
    print_r($tire->getResult());
} else {
    print_r($tire->getLastError());
}
/**
 * Samples for Order ServiceType
 */
$order = new \ServiceType\Order($options);
/**
 * Sample call for OrderReadyToWait operation/method
 */
if ($order->OrderReadyToWait(new \StructType\OrderReadyToWait()) !== false) {
    print_r($order->getResult());
} else {
    print_r($order->getLastError());
}
/**
 * Samples for Propose ServiceType
 */
$propose = new \ServiceType\Propose($options);
/**
 * Sample call for ProposeGoods operation/method
 */
if ($propose->ProposeGoods(new \StructType\ProposeGoods()) !== false) {
    print_r($propose->getResult());
} else {
    print_r($propose->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for DeleteConsignee operation/method
 */
if ($delete->DeleteConsignee(new \StructType\DeleteConsignee()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
