<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TireCalcParameters StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TireCalcParameters
 * @subpackage Structs
 */
class TireCalcParameters extends AbstractStructBase
{
    /**
     * The new_size
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TireCalcSize
     */
    public $new_size;
    /**
     * The old_size
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TireCalcSize
     */
    public $old_size;
    /**
     * The old_speed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $old_speed;
    /**
     * Constructor method for TireCalcParameters
     * @uses TireCalcParameters::setNew_size()
     * @uses TireCalcParameters::setOld_size()
     * @uses TireCalcParameters::setOld_speed()
     * @param \StructType\TireCalcSize $new_size
     * @param \StructType\TireCalcSize $old_size
     * @param float $old_speed
     */
    public function __construct(\StructType\TireCalcSize $new_size = null, \StructType\TireCalcSize $old_size = null, $old_speed = null)
    {
        $this
            ->setNew_size($new_size)
            ->setOld_size($old_size)
            ->setOld_speed($old_speed);
    }
    /**
     * Get new_size value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TireCalcSize|null
     */
    public function getNew_size()
    {
        return isset($this->new_size) ? $this->new_size : null;
    }
    /**
     * Set new_size value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TireCalcSize $new_size
     * @return \StructType\TireCalcParameters
     */
    public function setNew_size(\StructType\TireCalcSize $new_size = null)
    {
        if (is_null($new_size) || (is_array($new_size) && empty($new_size))) {
            unset($this->new_size);
        } else {
            $this->new_size = $new_size;
        }
        return $this;
    }
    /**
     * Get old_size value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TireCalcSize|null
     */
    public function getOld_size()
    {
        return isset($this->old_size) ? $this->old_size : null;
    }
    /**
     * Set old_size value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TireCalcSize $old_size
     * @return \StructType\TireCalcParameters
     */
    public function setOld_size(\StructType\TireCalcSize $old_size = null)
    {
        if (is_null($old_size) || (is_array($old_size) && empty($old_size))) {
            unset($this->old_size);
        } else {
            $this->old_size = $old_size;
        }
        return $this;
    }
    /**
     * Get old_speed value
     * @return float|null
     */
    public function getOld_speed()
    {
        return $this->old_speed;
    }
    /**
     * Set old_speed value
     * @param float $old_speed
     * @return \StructType\TireCalcParameters
     */
    public function setOld_speed($old_speed = null)
    {
        // validation for constraint: float
        if (!is_null($old_speed) && !(is_float($old_speed) || is_numeric($old_speed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($old_speed, true), gettype($old_speed)), __LINE__);
        }
        $this->old_speed = $old_speed;
        return $this;
    }
}
