<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarkCodeContainer StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MarkCodeContainer
 * @subpackage Structs
 */
class MarkCodeContainer extends AbstractStructBase
{
    /**
     * The MarkCodeImg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MarkCodeImg;
    /**
     * The MarkCodeString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MarkCodeString;
    /**
     * The artikul
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $artikul;
    /**
     * The MarkCodeLabelUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MarkCodeLabelUrl;
    /**
     * The MarkCodeUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MarkCodeUrl;
    /**
     * The ProductCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductCode;
    /**
     * Constructor method for MarkCodeContainer
     * @uses MarkCodeContainer::setMarkCodeImg()
     * @uses MarkCodeContainer::setMarkCodeString()
     * @uses MarkCodeContainer::setArtikul()
     * @uses MarkCodeContainer::setMarkCodeLabelUrl()
     * @uses MarkCodeContainer::setMarkCodeUrl()
     * @uses MarkCodeContainer::setProductCode()
     * @param string $markCodeImg
     * @param string $markCodeString
     * @param string $artikul
     * @param string $markCodeLabelUrl
     * @param string $markCodeUrl
     * @param string $productCode
     */
    public function __construct($markCodeImg = null, $markCodeString = null, $artikul = null, $markCodeLabelUrl = null, $markCodeUrl = null, $productCode = null)
    {
        $this
            ->setMarkCodeImg($markCodeImg)
            ->setMarkCodeString($markCodeString)
            ->setArtikul($artikul)
            ->setMarkCodeLabelUrl($markCodeLabelUrl)
            ->setMarkCodeUrl($markCodeUrl)
            ->setProductCode($productCode);
    }
    /**
     * Get MarkCodeImg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarkCodeImg()
    {
        return isset($this->MarkCodeImg) ? $this->MarkCodeImg : null;
    }
    /**
     * Set MarkCodeImg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $markCodeImg
     * @return \StructType\MarkCodeContainer
     */
    public function setMarkCodeImg($markCodeImg = null)
    {
        // validation for constraint: string
        if (!is_null($markCodeImg) && !is_string($markCodeImg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($markCodeImg, true), gettype($markCodeImg)), __LINE__);
        }
        if (is_null($markCodeImg) || (is_array($markCodeImg) && empty($markCodeImg))) {
            unset($this->MarkCodeImg);
        } else {
            $this->MarkCodeImg = $markCodeImg;
        }
        return $this;
    }
    /**
     * Get MarkCodeString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarkCodeString()
    {
        return isset($this->MarkCodeString) ? $this->MarkCodeString : null;
    }
    /**
     * Set MarkCodeString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $markCodeString
     * @return \StructType\MarkCodeContainer
     */
    public function setMarkCodeString($markCodeString = null)
    {
        // validation for constraint: string
        if (!is_null($markCodeString) && !is_string($markCodeString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($markCodeString, true), gettype($markCodeString)), __LINE__);
        }
        if (is_null($markCodeString) || (is_array($markCodeString) && empty($markCodeString))) {
            unset($this->MarkCodeString);
        } else {
            $this->MarkCodeString = $markCodeString;
        }
        return $this;
    }
    /**
     * Get artikul value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikul()
    {
        return isset($this->artikul) ? $this->artikul : null;
    }
    /**
     * Set artikul value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikul
     * @return \StructType\MarkCodeContainer
     */
    public function setArtikul($artikul = null)
    {
        // validation for constraint: string
        if (!is_null($artikul) && !is_string($artikul)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikul, true), gettype($artikul)), __LINE__);
        }
        if (is_null($artikul) || (is_array($artikul) && empty($artikul))) {
            unset($this->artikul);
        } else {
            $this->artikul = $artikul;
        }
        return $this;
    }
    /**
     * Get MarkCodeLabelUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarkCodeLabelUrl()
    {
        return isset($this->MarkCodeLabelUrl) ? $this->MarkCodeLabelUrl : null;
    }
    /**
     * Set MarkCodeLabelUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $markCodeLabelUrl
     * @return \StructType\MarkCodeContainer
     */
    public function setMarkCodeLabelUrl($markCodeLabelUrl = null)
    {
        // validation for constraint: string
        if (!is_null($markCodeLabelUrl) && !is_string($markCodeLabelUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($markCodeLabelUrl, true), gettype($markCodeLabelUrl)), __LINE__);
        }
        if (is_null($markCodeLabelUrl) || (is_array($markCodeLabelUrl) && empty($markCodeLabelUrl))) {
            unset($this->MarkCodeLabelUrl);
        } else {
            $this->MarkCodeLabelUrl = $markCodeLabelUrl;
        }
        return $this;
    }
    /**
     * Get MarkCodeUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarkCodeUrl()
    {
        return isset($this->MarkCodeUrl) ? $this->MarkCodeUrl : null;
    }
    /**
     * Set MarkCodeUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $markCodeUrl
     * @return \StructType\MarkCodeContainer
     */
    public function setMarkCodeUrl($markCodeUrl = null)
    {
        // validation for constraint: string
        if (!is_null($markCodeUrl) && !is_string($markCodeUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($markCodeUrl, true), gettype($markCodeUrl)), __LINE__);
        }
        if (is_null($markCodeUrl) || (is_array($markCodeUrl) && empty($markCodeUrl))) {
            unset($this->MarkCodeUrl);
        } else {
            $this->MarkCodeUrl = $markCodeUrl;
        }
        return $this;
    }
    /**
     * Get ProductCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductCode()
    {
        return isset($this->ProductCode) ? $this->ProductCode : null;
    }
    /**
     * Set ProductCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productCode
     * @return \StructType\MarkCodeContainer
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        if (is_null($productCode) || (is_array($productCode) && empty($productCode))) {
            unset($this->ProductCode);
        } else {
            $this->ProductCode = $productCode;
        }
        return $this;
    }
}
