<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfgood ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfgood
 * @subpackage Arrays
 */
class ArrayOfgood extends AbstractStructArrayBase
{
    /**
     * The good
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Good[]
     */
    public $good;
    /**
     * Constructor method for ArrayOfgood
     * @uses ArrayOfgood::setGood()
     * @param \StructType\Good[] $good
     */
    public function __construct(array $good = array())
    {
        $this
            ->setGood($good);
    }
    /**
     * Get good value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Good[]|null
     */
    public function getGood()
    {
        return isset($this->good) ? $this->good : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGood method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGood method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoodForArrayConstraintsFromSetGood(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfgoodGoodItem) {
            // validation for constraint: itemType
            if (!$arrayOfgoodGoodItem instanceof \StructType\Good) {
                $invalidValues[] = is_object($arrayOfgoodGoodItem) ? get_class($arrayOfgoodGoodItem) : sprintf('%s(%s)', gettype($arrayOfgoodGoodItem), var_export($arrayOfgoodGoodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The good property can only contain items of type \StructType\Good, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set good value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Good[] $good
     * @return \ArrayType\ArrayOfgood
     */
    public function setGood(array $good = array())
    {
        // validation for constraint: array
        if ('' !== ($goodArrayErrorMessage = self::validateGoodForArrayConstraintsFromSetGood($good))) {
            throw new \InvalidArgumentException($goodArrayErrorMessage, __LINE__);
        }
        if (is_null($good) || (is_array($good) && empty($good))) {
            unset($this->good);
        } else {
            $this->good = $good;
        }
        return $this;
    }
    /**
     * Add item to good value
     * @throws \InvalidArgumentException
     * @param \StructType\Good $item
     * @return \ArrayType\ArrayOfgood
     */
    public function addToGood(\StructType\Good $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Good) {
            throw new \InvalidArgumentException(sprintf('The good property can only contain items of type \StructType\Good, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->good[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Good|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Good|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Good|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Good|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Good|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string good
     */
    public function getAttributeName()
    {
        return 'good';
    }
}
