<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WarehouseLogistic StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WarehouseLogistic
 * @subpackage Structs
 */
class WarehouseLogistic extends AbstractStructBase
{
    /**
     * The logistDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $logistDays;
    /**
     * The whId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $whId;
    /**
     * Constructor method for WarehouseLogistic
     * @uses WarehouseLogistic::setLogistDays()
     * @uses WarehouseLogistic::setWhId()
     * @param int $logistDays
     * @param int $whId
     */
    public function __construct($logistDays = null, $whId = null)
    {
        $this
            ->setLogistDays($logistDays)
            ->setWhId($whId);
    }
    /**
     * Get logistDays value
     * @return int|null
     */
    public function getLogistDays()
    {
        return $this->logistDays;
    }
    /**
     * Set logistDays value
     * @param int $logistDays
     * @return \StructType\WarehouseLogistic
     */
    public function setLogistDays($logistDays = null)
    {
        // validation for constraint: int
        if (!is_null($logistDays) && !(is_int($logistDays) || ctype_digit($logistDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logistDays, true), gettype($logistDays)), __LINE__);
        }
        $this->logistDays = $logistDays;
        return $this;
    }
    /**
     * Get whId value
     * @return int|null
     */
    public function getWhId()
    {
        return $this->whId;
    }
    /**
     * Set whId value
     * @param int $whId
     * @return \StructType\WarehouseLogistic
     */
    public function setWhId($whId = null)
    {
        // validation for constraint: int
        if (!is_null($whId) && !(is_int($whId) || ctype_digit($whId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($whId, true), gettype($whId)), __LINE__);
        }
        $this->whId = $whId;
        return $this;
    }
}
