<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetOrderDeliveryPeriodContainer StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SetOrderDeliveryPeriodContainer
 * @subpackage Structs
 */
class SetOrderDeliveryPeriodContainer extends AbstractStructBase
{
    /**
     * The AddressId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AddressId;
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryDate;
    /**
     * The DeliveryIntervalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DeliveryIntervalId;
    /**
     * The OrderNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderNumber;
    /**
     * Constructor method for SetOrderDeliveryPeriodContainer
     * @uses SetOrderDeliveryPeriodContainer::setAddressId()
     * @uses SetOrderDeliveryPeriodContainer::setDeliveryDate()
     * @uses SetOrderDeliveryPeriodContainer::setDeliveryIntervalId()
     * @uses SetOrderDeliveryPeriodContainer::setOrderNumber()
     * @param int $addressId
     * @param string $deliveryDate
     * @param int $deliveryIntervalId
     * @param string $orderNumber
     */
    public function __construct($addressId = null, $deliveryDate = null, $deliveryIntervalId = null, $orderNumber = null)
    {
        $this
            ->setAddressId($addressId)
            ->setDeliveryDate($deliveryDate)
            ->setDeliveryIntervalId($deliveryIntervalId)
            ->setOrderNumber($orderNumber);
    }
    /**
     * Get AddressId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAddressId()
    {
        return isset($this->AddressId) ? $this->AddressId : null;
    }
    /**
     * Set AddressId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $addressId
     * @return \StructType\SetOrderDeliveryPeriodContainer
     */
    public function setAddressId($addressId = null)
    {
        // validation for constraint: int
        if (!is_null($addressId) && !(is_int($addressId) || ctype_digit($addressId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($addressId, true), gettype($addressId)), __LINE__);
        }
        if (is_null($addressId) || (is_array($addressId) && empty($addressId))) {
            unset($this->AddressId);
        } else {
            $this->AddressId = $addressId;
        }
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \StructType\SetOrderDeliveryPeriodContainer
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get DeliveryIntervalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDeliveryIntervalId()
    {
        return isset($this->DeliveryIntervalId) ? $this->DeliveryIntervalId : null;
    }
    /**
     * Set DeliveryIntervalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $deliveryIntervalId
     * @return \StructType\SetOrderDeliveryPeriodContainer
     */
    public function setDeliveryIntervalId($deliveryIntervalId = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryIntervalId) && !(is_int($deliveryIntervalId) || ctype_digit($deliveryIntervalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryIntervalId, true), gettype($deliveryIntervalId)), __LINE__);
        }
        if (is_null($deliveryIntervalId) || (is_array($deliveryIntervalId) && empty($deliveryIntervalId))) {
            unset($this->DeliveryIntervalId);
        } else {
            $this->DeliveryIntervalId = $deliveryIntervalId;
        }
        return $this;
    }
    /**
     * Get OrderNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderNumber()
    {
        return isset($this->OrderNumber) ? $this->OrderNumber : null;
    }
    /**
     * Set OrderNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderNumber
     * @return \StructType\SetOrderDeliveryPeriodContainer
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        if (is_null($orderNumber) || (is_array($orderNumber) && empty($orderNumber))) {
            unset($this->OrderNumber);
        } else {
            $this->OrderNumber = $orderNumber;
        }
        return $this;
    }
}
