<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GtinItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GtinItem
 * @subpackage Structs
 */
class GtinItem extends AbstractStructBase
{
    /**
     * The Gtin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Gtin;
    /**
     * The ProductCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductCode;
    /**
     * Constructor method for GtinItem
     * @uses GtinItem::setGtin()
     * @uses GtinItem::setProductCode()
     * @param string $gtin
     * @param string $productCode
     */
    public function __construct($gtin = null, $productCode = null)
    {
        $this
            ->setGtin($gtin)
            ->setProductCode($productCode);
    }
    /**
     * Get Gtin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGtin()
    {
        return isset($this->Gtin) ? $this->Gtin : null;
    }
    /**
     * Set Gtin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gtin
     * @return \StructType\GtinItem
     */
    public function setGtin($gtin = null)
    {
        // validation for constraint: string
        if (!is_null($gtin) && !is_string($gtin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gtin, true), gettype($gtin)), __LINE__);
        }
        if (is_null($gtin) || (is_array($gtin) && empty($gtin))) {
            unset($this->Gtin);
        } else {
            $this->Gtin = $gtin;
        }
        return $this;
    }
    /**
     * Get ProductCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductCode()
    {
        return isset($this->ProductCode) ? $this->ProductCode : null;
    }
    /**
     * Set ProductCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productCode
     * @return \StructType\GtinItem
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCode) && !is_string($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCode, true), gettype($productCode)), __LINE__);
        }
        if (is_null($productCode) || (is_array($productCode) && empty($productCode))) {
            unset($this->ProductCode);
        } else {
            $this->ProductCode = $productCode;
        }
        return $this;
    }
}
