<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for gtdContainer StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:gtdContainer
 * @subpackage Structs
 */
class GtdContainer extends AbstractStructBase
{
    /**
     * The artikul
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $artikul;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $country;
    /**
     * The gtd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $gtd;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $quantity;
    /**
     * Constructor method for gtdContainer
     * @uses GtdContainer::setArtikul()
     * @uses GtdContainer::setCountry()
     * @uses GtdContainer::setGtd()
     * @uses GtdContainer::setQuantity()
     * @param string $artikul
     * @param string $country
     * @param string $gtd
     * @param int $quantity
     */
    public function __construct($artikul = null, $country = null, $gtd = null, $quantity = null)
    {
        $this
            ->setArtikul($artikul)
            ->setCountry($country)
            ->setGtd($gtd)
            ->setQuantity($quantity);
    }
    /**
     * Get artikul value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikul()
    {
        return isset($this->artikul) ? $this->artikul : null;
    }
    /**
     * Set artikul value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikul
     * @return \StructType\GtdContainer
     */
    public function setArtikul($artikul = null)
    {
        // validation for constraint: string
        if (!is_null($artikul) && !is_string($artikul)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikul, true), gettype($artikul)), __LINE__);
        }
        if (is_null($artikul) || (is_array($artikul) && empty($artikul))) {
            unset($this->artikul);
        } else {
            $this->artikul = $artikul;
        }
        return $this;
    }
    /**
     * Get country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry()
    {
        return isset($this->country) ? $this->country : null;
    }
    /**
     * Set country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country
     * @return \StructType\GtdContainer
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->country);
        } else {
            $this->country = $country;
        }
        return $this;
    }
    /**
     * Get gtd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGtd()
    {
        return isset($this->gtd) ? $this->gtd : null;
    }
    /**
     * Set gtd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gtd
     * @return \StructType\GtdContainer
     */
    public function setGtd($gtd = null)
    {
        // validation for constraint: string
        if (!is_null($gtd) && !is_string($gtd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gtd, true), gettype($gtd)), __LINE__);
        }
        if (is_null($gtd) || (is_array($gtd) && empty($gtd))) {
            unset($this->gtd);
        } else {
            $this->gtd = $gtd;
        }
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\GtdContainer
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
}
