<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getAddressListItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:getAddressListItem
 * @subpackage Structs
 */
class GetAddressListItem extends AbstractStructBase
{
    /**
     * The addressId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $addressId;
    /**
     * The addressName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $addressName;
    /**
     * The building
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $building;
    /**
     * The cityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $cityName;
    /**
     * The contactName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $contactName;
    /**
     * The coordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Coordinates
     */
    public $coordinates;
    /**
     * The driverNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $driverNote;
    /**
     * The houseNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $houseNumber;
    /**
     * The housing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $housing;
    /**
     * The isDefaultAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isDefaultAddress;
    /**
     * The office
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $office;
    /**
     * The paymentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $paymentType;
    /**
     * The phoneNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $phoneNumber;
    /**
     * The streetName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $streetName;
    /**
     * Constructor method for getAddressListItem
     * @uses GetAddressListItem::setAddressId()
     * @uses GetAddressListItem::setAddressName()
     * @uses GetAddressListItem::setBuilding()
     * @uses GetAddressListItem::setCityName()
     * @uses GetAddressListItem::setContactName()
     * @uses GetAddressListItem::setCoordinates()
     * @uses GetAddressListItem::setDriverNote()
     * @uses GetAddressListItem::setHouseNumber()
     * @uses GetAddressListItem::setHousing()
     * @uses GetAddressListItem::setIsDefaultAddress()
     * @uses GetAddressListItem::setOffice()
     * @uses GetAddressListItem::setPaymentType()
     * @uses GetAddressListItem::setPhoneNumber()
     * @uses GetAddressListItem::setStreetName()
     * @param int $addressId
     * @param string $addressName
     * @param string $building
     * @param string $cityName
     * @param string $contactName
     * @param \StructType\Coordinates $coordinates
     * @param string $driverNote
     * @param string $houseNumber
     * @param string $housing
     * @param bool $isDefaultAddress
     * @param string $office
     * @param string $paymentType
     * @param string $phoneNumber
     * @param string $streetName
     */
    public function __construct($addressId = null, $addressName = null, $building = null, $cityName = null, $contactName = null, \StructType\Coordinates $coordinates = null, $driverNote = null, $houseNumber = null, $housing = null, $isDefaultAddress = null, $office = null, $paymentType = null, $phoneNumber = null, $streetName = null)
    {
        $this
            ->setAddressId($addressId)
            ->setAddressName($addressName)
            ->setBuilding($building)
            ->setCityName($cityName)
            ->setContactName($contactName)
            ->setCoordinates($coordinates)
            ->setDriverNote($driverNote)
            ->setHouseNumber($houseNumber)
            ->setHousing($housing)
            ->setIsDefaultAddress($isDefaultAddress)
            ->setOffice($office)
            ->setPaymentType($paymentType)
            ->setPhoneNumber($phoneNumber)
            ->setStreetName($streetName);
    }
    /**
     * Get addressId value
     * @return int|null
     */
    public function getAddressId()
    {
        return $this->addressId;
    }
    /**
     * Set addressId value
     * @param int $addressId
     * @return \StructType\GetAddressListItem
     */
    public function setAddressId($addressId = null)
    {
        // validation for constraint: int
        if (!is_null($addressId) && !(is_int($addressId) || ctype_digit($addressId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($addressId, true), gettype($addressId)), __LINE__);
        }
        $this->addressId = $addressId;
        return $this;
    }
    /**
     * Get addressName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressName()
    {
        return isset($this->addressName) ? $this->addressName : null;
    }
    /**
     * Set addressName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressName
     * @return \StructType\GetAddressListItem
     */
    public function setAddressName($addressName = null)
    {
        // validation for constraint: string
        if (!is_null($addressName) && !is_string($addressName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressName, true), gettype($addressName)), __LINE__);
        }
        if (is_null($addressName) || (is_array($addressName) && empty($addressName))) {
            unset($this->addressName);
        } else {
            $this->addressName = $addressName;
        }
        return $this;
    }
    /**
     * Get building value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBuilding()
    {
        return isset($this->building) ? $this->building : null;
    }
    /**
     * Set building value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $building
     * @return \StructType\GetAddressListItem
     */
    public function setBuilding($building = null)
    {
        // validation for constraint: string
        if (!is_null($building) && !is_string($building)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($building, true), gettype($building)), __LINE__);
        }
        if (is_null($building) || (is_array($building) && empty($building))) {
            unset($this->building);
        } else {
            $this->building = $building;
        }
        return $this;
    }
    /**
     * Get cityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCityName()
    {
        return isset($this->cityName) ? $this->cityName : null;
    }
    /**
     * Set cityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cityName
     * @return \StructType\GetAddressListItem
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        if (is_null($cityName) || (is_array($cityName) && empty($cityName))) {
            unset($this->cityName);
        } else {
            $this->cityName = $cityName;
        }
        return $this;
    }
    /**
     * Get contactName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactName()
    {
        return isset($this->contactName) ? $this->contactName : null;
    }
    /**
     * Set contactName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactName
     * @return \StructType\GetAddressListItem
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        if (is_null($contactName) || (is_array($contactName) && empty($contactName))) {
            unset($this->contactName);
        } else {
            $this->contactName = $contactName;
        }
        return $this;
    }
    /**
     * Get coordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Coordinates|null
     */
    public function getCoordinates()
    {
        return isset($this->coordinates) ? $this->coordinates : null;
    }
    /**
     * Set coordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Coordinates $coordinates
     * @return \StructType\GetAddressListItem
     */
    public function setCoordinates(\StructType\Coordinates $coordinates = null)
    {
        if (is_null($coordinates) || (is_array($coordinates) && empty($coordinates))) {
            unset($this->coordinates);
        } else {
            $this->coordinates = $coordinates;
        }
        return $this;
    }
    /**
     * Get driverNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDriverNote()
    {
        return isset($this->driverNote) ? $this->driverNote : null;
    }
    /**
     * Set driverNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $driverNote
     * @return \StructType\GetAddressListItem
     */
    public function setDriverNote($driverNote = null)
    {
        // validation for constraint: string
        if (!is_null($driverNote) && !is_string($driverNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverNote, true), gettype($driverNote)), __LINE__);
        }
        if (is_null($driverNote) || (is_array($driverNote) && empty($driverNote))) {
            unset($this->driverNote);
        } else {
            $this->driverNote = $driverNote;
        }
        return $this;
    }
    /**
     * Get houseNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHouseNumber()
    {
        return isset($this->houseNumber) ? $this->houseNumber : null;
    }
    /**
     * Set houseNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $houseNumber
     * @return \StructType\GetAddressListItem
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseNumber, true), gettype($houseNumber)), __LINE__);
        }
        if (is_null($houseNumber) || (is_array($houseNumber) && empty($houseNumber))) {
            unset($this->houseNumber);
        } else {
            $this->houseNumber = $houseNumber;
        }
        return $this;
    }
    /**
     * Get housing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHousing()
    {
        return isset($this->housing) ? $this->housing : null;
    }
    /**
     * Set housing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $housing
     * @return \StructType\GetAddressListItem
     */
    public function setHousing($housing = null)
    {
        // validation for constraint: string
        if (!is_null($housing) && !is_string($housing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($housing, true), gettype($housing)), __LINE__);
        }
        if (is_null($housing) || (is_array($housing) && empty($housing))) {
            unset($this->housing);
        } else {
            $this->housing = $housing;
        }
        return $this;
    }
    /**
     * Get isDefaultAddress value
     * @return bool|null
     */
    public function getIsDefaultAddress()
    {
        return $this->isDefaultAddress;
    }
    /**
     * Set isDefaultAddress value
     * @param bool $isDefaultAddress
     * @return \StructType\GetAddressListItem
     */
    public function setIsDefaultAddress($isDefaultAddress = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefaultAddress) && !is_bool($isDefaultAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefaultAddress, true), gettype($isDefaultAddress)), __LINE__);
        }
        $this->isDefaultAddress = $isDefaultAddress;
        return $this;
    }
    /**
     * Get office value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOffice()
    {
        return isset($this->office) ? $this->office : null;
    }
    /**
     * Set office value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $office
     * @return \StructType\GetAddressListItem
     */
    public function setOffice($office = null)
    {
        // validation for constraint: string
        if (!is_null($office) && !is_string($office)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($office, true), gettype($office)), __LINE__);
        }
        if (is_null($office) || (is_array($office) && empty($office))) {
            unset($this->office);
        } else {
            $this->office = $office;
        }
        return $this;
    }
    /**
     * Get paymentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentType()
    {
        return isset($this->paymentType) ? $this->paymentType : null;
    }
    /**
     * Set paymentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentType
     * @return \StructType\GetAddressListItem
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        if (is_null($paymentType) || (is_array($paymentType) && empty($paymentType))) {
            unset($this->paymentType);
        } else {
            $this->paymentType = $paymentType;
        }
        return $this;
    }
    /**
     * Get phoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return isset($this->phoneNumber) ? $this->phoneNumber : null;
    }
    /**
     * Set phoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phoneNumber
     * @return \StructType\GetAddressListItem
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        if (is_null($phoneNumber) || (is_array($phoneNumber) && empty($phoneNumber))) {
            unset($this->phoneNumber);
        } else {
            $this->phoneNumber = $phoneNumber;
        }
        return $this;
    }
    /**
     * Get streetName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetName()
    {
        return isset($this->streetName) ? $this->streetName : null;
    }
    /**
     * Set streetName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetName
     * @return \StructType\GetAddressListItem
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetName, true), gettype($streetName)), __LINE__);
        }
        if (is_null($streetName) || (is_array($streetName) && empty($streetName))) {
            unset($this->streetName);
        } else {
            $this->streetName = $streetName;
        }
        return $this;
    }
}
