<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoordinatesAsDouble StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CoordinatesAsDouble
 * @subpackage Structs
 */
class CoordinatesAsDouble extends AbstractStructBase
{
    /**
     * The latitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $latitude;
    /**
     * The longtitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $longtitude;
    /**
     * Constructor method for CoordinatesAsDouble
     * @uses CoordinatesAsDouble::setLatitude()
     * @uses CoordinatesAsDouble::setLongtitude()
     * @param float $latitude
     * @param float $longtitude
     */
    public function __construct($latitude = null, $longtitude = null)
    {
        $this
            ->setLatitude($latitude)
            ->setLongtitude($longtitude);
    }
    /**
     * Get latitude value
     * @return float|null
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param float $latitude
     * @return \StructType\CoordinatesAsDouble
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get longtitude value
     * @return float|null
     */
    public function getLongtitude()
    {
        return $this->longtitude;
    }
    /**
     * Set longtitude value
     * @param float $longtitude
     * @return \StructType\CoordinatesAsDouble
     */
    public function setLongtitude($longtitude = null)
    {
        // validation for constraint: float
        if (!is_null($longtitude) && !(is_float($longtitude) || is_numeric($longtitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longtitude, true), gettype($longtitude)), __LINE__);
        }
        $this->longtitude = $longtitude;
        return $this;
    }
}
