<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Coordinates StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Coordinates
 * @subpackage Structs
 */
class Coordinates extends AbstractStructBase
{
    /**
     * The latitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $latitude;
    /**
     * The longtitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $longtitude;
    /**
     * Constructor method for Coordinates
     * @uses Coordinates::setLatitude()
     * @uses Coordinates::setLongtitude()
     * @param string $latitude
     * @param string $longtitude
     */
    public function __construct($latitude = null, $longtitude = null)
    {
        $this
            ->setLatitude($latitude)
            ->setLongtitude($longtitude);
    }
    /**
     * Get latitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLatitude()
    {
        return isset($this->latitude) ? $this->latitude : null;
    }
    /**
     * Set latitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $latitude
     * @return \StructType\Coordinates
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: string
        if (!is_null($latitude) && !is_string($latitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        if (is_null($latitude) || (is_array($latitude) && empty($latitude))) {
            unset($this->latitude);
        } else {
            $this->latitude = $latitude;
        }
        return $this;
    }
    /**
     * Get longtitude value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLongtitude()
    {
        return isset($this->longtitude) ? $this->longtitude : null;
    }
    /**
     * Set longtitude value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $longtitude
     * @return \StructType\Coordinates
     */
    public function setLongtitude($longtitude = null)
    {
        // validation for constraint: string
        if (!is_null($longtitude) && !is_string($longtitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longtitude, true), gettype($longtitude)), __LINE__);
        }
        if (is_null($longtitude) || (is_array($longtitude) && empty($longtitude))) {
            unset($this->longtitude);
        } else {
            $this->longtitude = $longtitude;
        }
        return $this;
    }
}
