<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetRest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetRest $parameters
     * @return \StructType\SetRestResponse|bool
     */
    public function SetRest(\StructType\SetRest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetRest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetPrice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetPrice $parameters
     * @return \StructType\SetPriceResponse|bool
     */
    public function SetPrice(\StructType\SetPrice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetPrice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetOrderStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetOrderStatus $parameters
     * @return \StructType\SetOrderStatusResponse|bool
     */
    public function SetOrderStatus(\StructType\SetOrderStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetOrderStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetOrderStatusSatellite
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetOrderStatusSatellite $parameters
     * @return \StructType\SetOrderStatusSatelliteResponse|bool
     */
    public function SetOrderStatusSatellite(\StructType\SetOrderStatusSatellite $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetOrderStatusSatellite($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetMergeOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetMergeOrders $parameters
     * @return \StructType\SetMergeOrdersResponse|bool
     */
    public function SetMergeOrders(\StructType\SetMergeOrders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetMergeOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetOrderComment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetOrderComment $parameters
     * @return \StructType\SetOrderCommentResponse|bool
     */
    public function SetOrderComment(\StructType\SetOrderComment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetOrderComment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCancelDelivery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCancelDelivery $parameters
     * @return \StructType\SetCancelDeliveryResponse|bool
     */
    public function SetCancelDelivery(\StructType\SetCancelDelivery $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetCancelDelivery($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetDeliveryInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetDeliveryInfo $parameters
     * @return \StructType\SetDeliveryInfoResponse|bool
     */
    public function SetDeliveryInfo(\StructType\SetDeliveryInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetDeliveryInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetToMove
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetToMove $parameters
     * @return \StructType\SetToMoveResponse|bool
     */
    public function SetToMove(\StructType\SetToMove $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetToMove($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetMovementStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetMovementStatus $parameters
     * @return \StructType\SetMovementStatusResponse|bool
     */
    public function SetMovementStatus(\StructType\SetMovementStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetMovementStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetDeliveryAddress
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetDeliveryAddress $parameters
     * @return \StructType\SetDeliveryAddressResponse|bool
     */
    public function SetDeliveryAddress(\StructType\SetDeliveryAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetDeliveryAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetOrderDelivery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetOrderDelivery $parameters
     * @return \StructType\SetOrderDeliveryResponse|bool
     */
    public function SetOrderDelivery(\StructType\SetOrderDelivery $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetOrderDelivery($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetRemoveFromOH
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetRemoveFromOH $parameters
     * @return \StructType\SetRemoveFromOHResponse|bool
     */
    public function SetRemoveFromOH(\StructType\SetRemoveFromOH $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetRemoveFromOH($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetMarkCodeList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetMarkCodeList $parameters
     * @return \StructType\SetMarkCodeListResponse|bool
     */
    public function SetMarkCodeList(\StructType\SetMarkCodeList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetMarkCodeList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SetCancelDeliveryResponse|\StructType\SetDeliveryAddressResponse|\StructType\SetDeliveryInfoResponse|\StructType\SetMarkCodeListResponse|\StructType\SetMergeOrdersResponse|\StructType\SetMovementStatusResponse|\StructType\SetOrderCommentResponse|\StructType\SetOrderDeliveryResponse|\StructType\SetOrderStatusResponse|\StructType\SetOrderStatusSatelliteResponse|\StructType\SetPriceResponse|\StructType\SetRemoveFromOHResponse|\StructType\SetRestResponse|\StructType\SetToMoveResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
