<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPriceList ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPriceList
 * @subpackage Arrays
 */
class ArrayOfPriceList extends AbstractStructArrayBase
{
    /**
     * The PriceList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PriceList[]
     */
    public $PriceList;
    /**
     * Constructor method for ArrayOfPriceList
     * @uses ArrayOfPriceList::setPriceList()
     * @param \StructType\PriceList[] $priceList
     */
    public function __construct(array $priceList = array())
    {
        $this
            ->setPriceList($priceList);
    }
    /**
     * Get PriceList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PriceList[]|null
     */
    public function getPriceList()
    {
        return isset($this->PriceList) ? $this->PriceList : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPriceList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPriceList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceListForArrayConstraintsFromSetPriceList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPriceListPriceListItem) {
            // validation for constraint: itemType
            if (!$arrayOfPriceListPriceListItem instanceof \StructType\PriceList) {
                $invalidValues[] = is_object($arrayOfPriceListPriceListItem) ? get_class($arrayOfPriceListPriceListItem) : sprintf('%s(%s)', gettype($arrayOfPriceListPriceListItem), var_export($arrayOfPriceListPriceListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PriceList property can only contain items of type \StructType\PriceList, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PriceList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PriceList[] $priceList
     * @return \ArrayType\ArrayOfPriceList
     */
    public function setPriceList(array $priceList = array())
    {
        // validation for constraint: array
        if ('' !== ($priceListArrayErrorMessage = self::validatePriceListForArrayConstraintsFromSetPriceList($priceList))) {
            throw new \InvalidArgumentException($priceListArrayErrorMessage, __LINE__);
        }
        if (is_null($priceList) || (is_array($priceList) && empty($priceList))) {
            unset($this->PriceList);
        } else {
            $this->PriceList = $priceList;
        }
        return $this;
    }
    /**
     * Add item to PriceList value
     * @throws \InvalidArgumentException
     * @param \StructType\PriceList $item
     * @return \ArrayType\ArrayOfPriceList
     */
    public function addToPriceList(\StructType\PriceList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PriceList) {
            throw new \InvalidArgumentException(sprintf('The PriceList property can only contain items of type \StructType\PriceList, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PriceList[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PriceList|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PriceList|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PriceList|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PriceList|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PriceList|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PriceList
     */
    public function getAttributeName()
    {
        return 'PriceList';
    }
}
