<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named setApplicationsLCS
     * Meta information extracted from the WSDL
     * - documentation: Speichert eine Bewerbung im LANDWEHR-XML-Format.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $mandnr
     * @param string $xml
     * @return \StructType\FSoapResponse|bool
     */
    public function setApplicationsLCS($mandnr, $xml)
    {
        try {
            $this->setResult($this->getSoapClient()->setApplicationsLCS($mandnr, $xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named setApplications
     * Meta information extracted from the WSDL
     * - documentation: Speichert eine Bewerbung.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $mandnr
     * @param string $xml
     * @return \StructType\FSoapResponse|bool
     */
    public function setApplications($mandnr, $xml)
    {
        try {
            $this->setResult($this->getSoapClient()->setApplications($mandnr, $xml));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FSoapResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
