<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobSoapResponse StructType
 * @subpackage Structs
 */
class JobSoapResponse extends AbstractStructBase
{
    /**
     * The Code
     * @var int
     */
    public $Code;
    /**
     * The Message
     * @var string
     */
    public $Message;
    /**
     * The Data
     * @var Array
     */
    public $Data;
    /**
     * Constructor method for JobSoapResponse
     * @uses JobSoapResponse::setCode()
     * @uses JobSoapResponse::setMessage()
     * @uses JobSoapResponse::setData()
     * @param int $code
     * @param string $message
     * @param Array $data
     */
    public function __construct($code = null, $message = null, Array $data = null)
    {
        $this
            ->setCode($code)
            ->setMessage($message)
            ->setData($data);
    }
    /**
     * Get Code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\JobSoapResponse
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\JobSoapResponse
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get Data value
     * @return Array|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param Array $data
     * @return \StructType\JobSoapResponse
     */
    public function setData(Array $data = null)
    {
        $this->Data = $data;
        return $this;
    }
}
