<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getJobOverviewRaw
     * Meta information extracted from the WSDL
     * - documentation: Stellt eine Jobuebersicht im Rohformat bereit.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $mandnr
     * @param string $status
     * @param string $limit
     * @param string $offset
     * @param string $sections
     * @return \StructType\JobSoapResponse|bool
     */
    public function getJobOverviewRaw($mandnr, $status, $limit, $offset, $sections)
    {
        try {
            $this->setResult($this->getSoapClient()->getJobOverviewRaw($mandnr, $status, $limit, $offset, $sections));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getJobOverview
     * Meta information extracted from the WSDL
     * - documentation: Stellt eine Jobuebersicht bereit.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $mandnr
     * @param string $status
     * @param string $raw
     * @param string $limit
     * @param string $offset
     * @param string $sections
     * @return \StructType\JobSoapResponse|bool
     */
    public function getJobOverview($mandnr, $status, $raw, $limit, $offset, $sections)
    {
        try {
            $this->setResult($this->getSoapClient()->getJobOverview($mandnr, $status, $raw, $limit, $offset, $sections));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getJobDetailsXML
     * Meta information extracted from the WSDL
     * - documentation: Stellt Jobdetails als XML bereit.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $uuid
     * @param string $sections
     * @return \StructType\FSoapResponse|bool
     */
    public function getJobDetailsXML($uuid, $sections)
    {
        try {
            $this->setResult($this->getSoapClient()->getJobDetailsXML($uuid, $sections));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getJobDetails
     * Meta information extracted from the WSDL
     * - documentation: Stellt Jobdetails bereit.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $uuid
     * @param string $sections
     * @return \StructType\FSoapResponse|bool
     */
    public function getJobDetails($uuid, $sections)
    {
        try {
            $this->setResult($this->getSoapClient()->getJobDetails($uuid, $sections));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCandidateOverview
     * Meta information extracted from the WSDL
     * - documentation: Gibt eine Liste von Personalien mit dem Status 'Bewerber' zurueck.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\FSoapResponse|bool
     */
    public function getCandidateOverview()
    {
        try {
            $this->setResult($this->getSoapClient()->getCandidateOverview());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCandidate
     * Meta information extracted from the WSDL
     * - documentation: Gibt einen Bewerber zurueck.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $mandnr
     * @param string $personalnr
     * @return \StructType\FSoapResponse|bool
     */
    public function getCandidate($mandnr, $personalnr)
    {
        try {
            $this->setResult($this->getSoapClient()->getCandidate($mandnr, $personalnr));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCandidateFile
     * Meta information extracted from the WSDL
     * - documentation: Gibt eine Datei eines Bewerbers zurueck.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $mandnr
     * @param string $dateiid
     * @return \StructType\FSoapResponse|bool
     */
    public function getCandidateFile($mandnr, $dateiid)
    {
        try {
            $this->setResult($this->getSoapClient()->getCandidateFile($mandnr, $dateiid));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getJobs
     * Meta information extracted from the WSDL
     * - documentation: Stellt eine Berufsliste bereit.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $mandnr
     * @return \StructType\JobSoapResponse|bool
     */
    public function getJobs($mandnr)
    {
        try {
            $this->setResult($this->getSoapClient()->getJobs($mandnr));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSkills
     * Meta information extracted from the WSDL
     * - documentation: Stellt eine Kenntnisliste bereit.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $mandnr
     * @return \StructType\JobSoapResponse|bool
     */
    public function getSkills($mandnr)
    {
        try {
            $this->setResult($this->getSoapClient()->getSkills($mandnr));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getStaaten
     * Meta information extracted from the WSDL
     * - documentation: Stellt eine Staatenliste bereit.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $mandnr
     * @return \StructType\JobSoapResponse|bool
     */
    public function getStaaten($mandnr)
    {
        try {
            $this->setResult($this->getSoapClient()->getStaaten($mandnr));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBezugsquellen
     * Meta information extracted from the WSDL
     * - documentation: Stellt eine Bezugsquellen bereit.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $mandnr
     * @return \StructType\JobSoapResponse|bool
     */
    public function getBezugsquellen($mandnr)
    {
        try {
            $this->setResult($this->getSoapClient()->getBezugsquellen($mandnr));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMobilitaeten
     * Meta information extracted from the WSDL
     * - documentation: Stellt eine Mobilitaeten bereit.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $mandnr
     * @return \StructType\JobSoapResponse|bool
     */
    public function getMobilitaeten($mandnr)
    {
        try {
            $this->setResult($this->getSoapClient()->getMobilitaeten($mandnr));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getZusatzfelder
     * Meta information extracted from the WSDL
     * - documentation: Stellt eine Zusatzfelder bereit.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $mandnr
     * @return \StructType\JobSoapResponse|bool
     */
    public function getZusatzfelder($mandnr)
    {
        try {
            $this->setResult($this->getSoapClient()->getZusatzfelder($mandnr));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getJobsBA
     * Meta information extracted from the WSDL
     * - documentation: Stellt eine Berufsliste von der Bundesagentur der Arbeit bereit.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\JobSoapResponse|bool
     */
    public function getJobsBA()
    {
        try {
            $this->setResult($this->getSoapClient()->getJobsBA());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSkillsBA
     * Meta information extracted from the WSDL
     * - documentation: Stellt eine Kenntnisliste von der Bundesagentur der Arbeit bereit.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\JobSoapResponse|bool
     */
    public function getSkillsBA()
    {
        try {
            $this->setResult($this->getSoapClient()->getSkillsBA());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSkillGroupsBA
     * Meta information extracted from the WSDL
     * - documentation: Stellt eine Gruppenliste fuer Kenntnisse von der Bundesagentur der Arbeit bereit.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\JobSoapResponse|bool
     */
    public function getSkillGroupsBA()
    {
        try {
            $this->setResult($this->getSoapClient()->getSkillGroupsBA());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSkillRatingBA
     * Meta information extracted from the WSDL
     * - documentation: Stellt eine Bewertungsliste fuer Kenntnisse von der Bundesagentur der Arbeit bereit.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\JobSoapResponse|bool
     */
    public function getSkillRatingBA()
    {
        try {
            $this->setResult($this->getSoapClient()->getSkillRatingBA());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDrivingLicencesBA
     * Meta information extracted from the WSDL
     * - documentation: Stellt eine Fuehrerscheineliste von der Bundesagentur der Arbeit bereit.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\JobSoapResponse|bool
     */
    public function getDrivingLicencesBA()
    {
        try {
            $this->setResult($this->getSoapClient()->getDrivingLicencesBA());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCountrysBA
     * Meta information extracted from the WSDL
     * - documentation: Stellt eine Laenderliste von der Bundesagentur der Arbeit bereit.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\JobSoapResponse|bool
     */
    public function getCountrysBA()
    {
        try {
            $this->setResult($this->getSoapClient()->getCountrysBA());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCountryRegionsBA
     * Meta information extracted from the WSDL
     * - documentation: Stellt eine Regionenliste von der Bundesagentur der Arbeit bereit.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\JobSoapResponse|bool
     */
    public function getCountryRegionsBA()
    {
        try {
            $this->setResult($this->getSoapClient()->getCountryRegionsBA());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FSoapResponse|\StructType\JobSoapResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
