<?php

namespace HealthBridge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for importReport StructType
 * Meta information extracted from the WSDL
 * - type: tns:importReport
 * @subpackage Structs
 */
class ImportReport extends AbstractStructBase
{
    /**
     * The report
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $report;
    /**
     * The transmissionID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $transmissionID;
    /**
     * Constructor method for importReport
     * @uses ImportReport::setReport()
     * @uses ImportReport::setTransmissionID()
     * @param string $report
     * @param string $transmissionID
     */
    public function __construct($report = null, $transmissionID = null)
    {
        $this
            ->setReport($report)
            ->setTransmissionID($transmissionID);
    }
    /**
     * Get report value
     * @return string|null
     */
    public function getReport()
    {
        return $this->report;
    }
    /**
     * Set report value
     * @param string $report
     * @return \HealthBridge\StructType\ImportReport
     */
    public function setReport($report = null)
    {
        // validation for constraint: string
        if (!is_null($report) && !is_string($report)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($report, true), gettype($report)), __LINE__);
        }
        $this->report = $report;
        return $this;
    }
    /**
     * Get transmissionID value
     * @return string|null
     */
    public function getTransmissionID()
    {
        return $this->transmissionID;
    }
    /**
     * Set transmissionID value
     * @param string $transmissionID
     * @return \HealthBridge\StructType\ImportReport
     */
    public function setTransmissionID($transmissionID = null)
    {
        // validation for constraint: string
        if (!is_null($transmissionID) && !is_string($transmissionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transmissionID, true), gettype($transmissionID)), __LINE__);
        }
        $this->transmissionID = $transmissionID;
        return $this;
    }
}
