<?php

namespace HealthBridge\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Import ServiceType
 * @subpackage Services
 */
class Import extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named importReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \HealthBridge\StructType\ImportReport $importReport
     * @return \HealthBridge\StructType\ImportReportResponse|bool
     */
    public function importReport(\HealthBridge\StructType\ImportReport $importReport)
    {
        try {
            $this->setResult($this->getSoapClient()->importReport($importReport));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \HealthBridge\StructType\ImportReportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
