<?php

namespace SelectSiparis;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebKargoPaket StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebKargoPaket
 * @subpackage Structs
 */
class WebKargoPaket extends AbstractStructBase
{
    /**
     * The BarkodBigisi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarkodBigisi;
    /**
     * The EklenmeTarihi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EklenmeTarihi;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The KargoEntegrasyonID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KargoEntegrasyonID;
    /**
     * The KargoEntegrasyonTanim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KargoEntegrasyonTanim;
    /**
     * The KargoTakipLink
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KargoTakipLink;
    /**
     * The KargoTakipLinkGoster
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $KargoTakipLinkGoster;
    /**
     * The KargoTakipNumarasi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KargoTakipNumarasi;
    /**
     * The SiparisDurum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisDurum;
    /**
     * The SiparisID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisID;
    /**
     * The SiparisUrunDurumID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisUrunDurumID;
    /**
     * The SiparisUrunDurumTanim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiparisUrunDurumTanim;
    /**
     * The Urun_Liste
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \SelectSiparis\ArrayOfSiparisKargoPaketUrun
     */
    public $Urun_Liste;
    /**
     * The Urunler
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \SelectSiparis\ArrayOfint
     */
    public $Urunler;
    /**
     * Constructor method for WebKargoPaket
     * @uses WebKargoPaket::setBarkodBigisi()
     * @uses WebKargoPaket::setEklenmeTarihi()
     * @uses WebKargoPaket::setID()
     * @uses WebKargoPaket::setKargoEntegrasyonID()
     * @uses WebKargoPaket::setKargoEntegrasyonTanim()
     * @uses WebKargoPaket::setKargoTakipLink()
     * @uses WebKargoPaket::setKargoTakipLinkGoster()
     * @uses WebKargoPaket::setKargoTakipNumarasi()
     * @uses WebKargoPaket::setSiparisDurum()
     * @uses WebKargoPaket::setSiparisID()
     * @uses WebKargoPaket::setSiparisUrunDurumID()
     * @uses WebKargoPaket::setSiparisUrunDurumTanim()
     * @uses WebKargoPaket::setUrun_Liste()
     * @uses WebKargoPaket::setUrunler()
     * @param string $barkodBigisi
     * @param string $eklenmeTarihi
     * @param int $iD
     * @param int $kargoEntegrasyonID
     * @param string $kargoEntegrasyonTanim
     * @param string $kargoTakipLink
     * @param bool $kargoTakipLinkGoster
     * @param string $kargoTakipNumarasi
     * @param int $siparisDurum
     * @param int $siparisID
     * @param int $siparisUrunDurumID
     * @param string $siparisUrunDurumTanim
     * @param \SelectSiparis\ArrayOfSiparisKargoPaketUrun $urun_Liste
     * @param \SelectSiparis\ArrayOfint $urunler
     */
    public function __construct($barkodBigisi = null, $eklenmeTarihi = null, $iD = null, $kargoEntegrasyonID = null, $kargoEntegrasyonTanim = null, $kargoTakipLink = null, $kargoTakipLinkGoster = null, $kargoTakipNumarasi = null, $siparisDurum = null, $siparisID = null, $siparisUrunDurumID = null, $siparisUrunDurumTanim = null, \SelectSiparis\ArrayOfSiparisKargoPaketUrun $urun_Liste = null, \SelectSiparis\ArrayOfint $urunler = null)
    {
        $this
            ->setBarkodBigisi($barkodBigisi)
            ->setEklenmeTarihi($eklenmeTarihi)
            ->setID($iD)
            ->setKargoEntegrasyonID($kargoEntegrasyonID)
            ->setKargoEntegrasyonTanim($kargoEntegrasyonTanim)
            ->setKargoTakipLink($kargoTakipLink)
            ->setKargoTakipLinkGoster($kargoTakipLinkGoster)
            ->setKargoTakipNumarasi($kargoTakipNumarasi)
            ->setSiparisDurum($siparisDurum)
            ->setSiparisID($siparisID)
            ->setSiparisUrunDurumID($siparisUrunDurumID)
            ->setSiparisUrunDurumTanim($siparisUrunDurumTanim)
            ->setUrun_Liste($urun_Liste)
            ->setUrunler($urunler);
    }
    /**
     * Get BarkodBigisi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarkodBigisi()
    {
        return isset($this->BarkodBigisi) ? $this->BarkodBigisi : null;
    }
    /**
     * Set BarkodBigisi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barkodBigisi
     * @return \SelectSiparis\WebKargoPaket
     */
    public function setBarkodBigisi($barkodBigisi = null)
    {
        // validation for constraint: string
        if (!is_null($barkodBigisi) && !is_string($barkodBigisi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barkodBigisi, true), gettype($barkodBigisi)), __LINE__);
        }
        if (is_null($barkodBigisi) || (is_array($barkodBigisi) && empty($barkodBigisi))) {
            unset($this->BarkodBigisi);
        } else {
            $this->BarkodBigisi = $barkodBigisi;
        }
        return $this;
    }
    /**
     * Get EklenmeTarihi value
     * @return string|null
     */
    public function getEklenmeTarihi()
    {
        return $this->EklenmeTarihi;
    }
    /**
     * Set EklenmeTarihi value
     * @param string $eklenmeTarihi
     * @return \SelectSiparis\WebKargoPaket
     */
    public function setEklenmeTarihi($eklenmeTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($eklenmeTarihi) && !is_string($eklenmeTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eklenmeTarihi, true), gettype($eklenmeTarihi)), __LINE__);
        }
        $this->EklenmeTarihi = $eklenmeTarihi;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \SelectSiparis\WebKargoPaket
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get KargoEntegrasyonID value
     * @return int|null
     */
    public function getKargoEntegrasyonID()
    {
        return $this->KargoEntegrasyonID;
    }
    /**
     * Set KargoEntegrasyonID value
     * @param int $kargoEntegrasyonID
     * @return \SelectSiparis\WebKargoPaket
     */
    public function setKargoEntegrasyonID($kargoEntegrasyonID = null)
    {
        // validation for constraint: int
        if (!is_null($kargoEntegrasyonID) && !(is_int($kargoEntegrasyonID) || ctype_digit($kargoEntegrasyonID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kargoEntegrasyonID, true), gettype($kargoEntegrasyonID)), __LINE__);
        }
        $this->KargoEntegrasyonID = $kargoEntegrasyonID;
        return $this;
    }
    /**
     * Get KargoEntegrasyonTanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKargoEntegrasyonTanim()
    {
        return isset($this->KargoEntegrasyonTanim) ? $this->KargoEntegrasyonTanim : null;
    }
    /**
     * Set KargoEntegrasyonTanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kargoEntegrasyonTanim
     * @return \SelectSiparis\WebKargoPaket
     */
    public function setKargoEntegrasyonTanim($kargoEntegrasyonTanim = null)
    {
        // validation for constraint: string
        if (!is_null($kargoEntegrasyonTanim) && !is_string($kargoEntegrasyonTanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kargoEntegrasyonTanim, true), gettype($kargoEntegrasyonTanim)), __LINE__);
        }
        if (is_null($kargoEntegrasyonTanim) || (is_array($kargoEntegrasyonTanim) && empty($kargoEntegrasyonTanim))) {
            unset($this->KargoEntegrasyonTanim);
        } else {
            $this->KargoEntegrasyonTanim = $kargoEntegrasyonTanim;
        }
        return $this;
    }
    /**
     * Get KargoTakipLink value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKargoTakipLink()
    {
        return isset($this->KargoTakipLink) ? $this->KargoTakipLink : null;
    }
    /**
     * Set KargoTakipLink value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kargoTakipLink
     * @return \SelectSiparis\WebKargoPaket
     */
    public function setKargoTakipLink($kargoTakipLink = null)
    {
        // validation for constraint: string
        if (!is_null($kargoTakipLink) && !is_string($kargoTakipLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kargoTakipLink, true), gettype($kargoTakipLink)), __LINE__);
        }
        if (is_null($kargoTakipLink) || (is_array($kargoTakipLink) && empty($kargoTakipLink))) {
            unset($this->KargoTakipLink);
        } else {
            $this->KargoTakipLink = $kargoTakipLink;
        }
        return $this;
    }
    /**
     * Get KargoTakipLinkGoster value
     * @return bool|null
     */
    public function getKargoTakipLinkGoster()
    {
        return $this->KargoTakipLinkGoster;
    }
    /**
     * Set KargoTakipLinkGoster value
     * @param bool $kargoTakipLinkGoster
     * @return \SelectSiparis\WebKargoPaket
     */
    public function setKargoTakipLinkGoster($kargoTakipLinkGoster = null)
    {
        // validation for constraint: boolean
        if (!is_null($kargoTakipLinkGoster) && !is_bool($kargoTakipLinkGoster)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kargoTakipLinkGoster, true), gettype($kargoTakipLinkGoster)), __LINE__);
        }
        $this->KargoTakipLinkGoster = $kargoTakipLinkGoster;
        return $this;
    }
    /**
     * Get KargoTakipNumarasi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKargoTakipNumarasi()
    {
        return isset($this->KargoTakipNumarasi) ? $this->KargoTakipNumarasi : null;
    }
    /**
     * Set KargoTakipNumarasi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kargoTakipNumarasi
     * @return \SelectSiparis\WebKargoPaket
     */
    public function setKargoTakipNumarasi($kargoTakipNumarasi = null)
    {
        // validation for constraint: string
        if (!is_null($kargoTakipNumarasi) && !is_string($kargoTakipNumarasi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kargoTakipNumarasi, true), gettype($kargoTakipNumarasi)), __LINE__);
        }
        if (is_null($kargoTakipNumarasi) || (is_array($kargoTakipNumarasi) && empty($kargoTakipNumarasi))) {
            unset($this->KargoTakipNumarasi);
        } else {
            $this->KargoTakipNumarasi = $kargoTakipNumarasi;
        }
        return $this;
    }
    /**
     * Get SiparisDurum value
     * @return int|null
     */
    public function getSiparisDurum()
    {
        return $this->SiparisDurum;
    }
    /**
     * Set SiparisDurum value
     * @param int $siparisDurum
     * @return \SelectSiparis\WebKargoPaket
     */
    public function setSiparisDurum($siparisDurum = null)
    {
        // validation for constraint: int
        if (!is_null($siparisDurum) && !(is_int($siparisDurum) || ctype_digit($siparisDurum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisDurum, true), gettype($siparisDurum)), __LINE__);
        }
        $this->SiparisDurum = $siparisDurum;
        return $this;
    }
    /**
     * Get SiparisID value
     * @return int|null
     */
    public function getSiparisID()
    {
        return $this->SiparisID;
    }
    /**
     * Set SiparisID value
     * @param int $siparisID
     * @return \SelectSiparis\WebKargoPaket
     */
    public function setSiparisID($siparisID = null)
    {
        // validation for constraint: int
        if (!is_null($siparisID) && !(is_int($siparisID) || ctype_digit($siparisID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisID, true), gettype($siparisID)), __LINE__);
        }
        $this->SiparisID = $siparisID;
        return $this;
    }
    /**
     * Get SiparisUrunDurumID value
     * @return int|null
     */
    public function getSiparisUrunDurumID()
    {
        return $this->SiparisUrunDurumID;
    }
    /**
     * Set SiparisUrunDurumID value
     * @param int $siparisUrunDurumID
     * @return \SelectSiparis\WebKargoPaket
     */
    public function setSiparisUrunDurumID($siparisUrunDurumID = null)
    {
        // validation for constraint: int
        if (!is_null($siparisUrunDurumID) && !(is_int($siparisUrunDurumID) || ctype_digit($siparisUrunDurumID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisUrunDurumID, true), gettype($siparisUrunDurumID)), __LINE__);
        }
        $this->SiparisUrunDurumID = $siparisUrunDurumID;
        return $this;
    }
    /**
     * Get SiparisUrunDurumTanim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiparisUrunDurumTanim()
    {
        return isset($this->SiparisUrunDurumTanim) ? $this->SiparisUrunDurumTanim : null;
    }
    /**
     * Set SiparisUrunDurumTanim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siparisUrunDurumTanim
     * @return \SelectSiparis\WebKargoPaket
     */
    public function setSiparisUrunDurumTanim($siparisUrunDurumTanim = null)
    {
        // validation for constraint: string
        if (!is_null($siparisUrunDurumTanim) && !is_string($siparisUrunDurumTanim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siparisUrunDurumTanim, true), gettype($siparisUrunDurumTanim)), __LINE__);
        }
        if (is_null($siparisUrunDurumTanim) || (is_array($siparisUrunDurumTanim) && empty($siparisUrunDurumTanim))) {
            unset($this->SiparisUrunDurumTanim);
        } else {
            $this->SiparisUrunDurumTanim = $siparisUrunDurumTanim;
        }
        return $this;
    }
    /**
     * Get Urun_Liste value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SelectSiparis\ArrayOfSiparisKargoPaketUrun|null
     */
    public function getUrun_Liste()
    {
        return isset($this->Urun_Liste) ? $this->Urun_Liste : null;
    }
    /**
     * Set Urun_Liste value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \SelectSiparis\ArrayOfSiparisKargoPaketUrun $urun_Liste
     * @return \SelectSiparis\WebKargoPaket
     */
    public function setUrun_Liste(\SelectSiparis\ArrayOfSiparisKargoPaketUrun $urun_Liste = null)
    {
        if (is_null($urun_Liste) || (is_array($urun_Liste) && empty($urun_Liste))) {
            unset($this->Urun_Liste);
        } else {
            $this->Urun_Liste = $urun_Liste;
        }
        return $this;
    }
    /**
     * Get Urunler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SelectSiparis\ArrayOfint|null
     */
    public function getUrunler()
    {
        return isset($this->Urunler) ? $this->Urunler : null;
    }
    /**
     * Set Urunler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \SelectSiparis\ArrayOfint $urunler
     * @return \SelectSiparis\WebKargoPaket
     */
    public function setUrunler(\SelectSiparis\ArrayOfint $urunler = null)
    {
        if (is_null($urunler) || (is_array($urunler) && empty($urunler))) {
            unset($this->Urunler);
        } else {
            $this->Urunler = $urunler;
        }
        return $this;
    }
}
