<?php

namespace SelectSiparis;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateEfaturaRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateEfaturaRequest
 * @subpackage Structs
 */
class UpdateEfaturaRequest extends AbstractStructBase
{
    /**
     * The FaturaNumarasi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FaturaNumarasi;
    /**
     * The FaturaTipi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FaturaTipi;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The OlusturmaTarihi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OlusturmaTarihi;
    /**
     * The SiparisId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisId;
    /**
     * Constructor method for UpdateEfaturaRequest
     * @uses UpdateEfaturaRequest::setFaturaNumarasi()
     * @uses UpdateEfaturaRequest::setFaturaTipi()
     * @uses UpdateEfaturaRequest::setID()
     * @uses UpdateEfaturaRequest::setOlusturmaTarihi()
     * @uses UpdateEfaturaRequest::setSiparisId()
     * @param string $faturaNumarasi
     * @param int $faturaTipi
     * @param int $iD
     * @param string $olusturmaTarihi
     * @param int $siparisId
     */
    public function __construct($faturaNumarasi = null, $faturaTipi = null, $iD = null, $olusturmaTarihi = null, $siparisId = null)
    {
        $this
            ->setFaturaNumarasi($faturaNumarasi)
            ->setFaturaTipi($faturaTipi)
            ->setID($iD)
            ->setOlusturmaTarihi($olusturmaTarihi)
            ->setSiparisId($siparisId);
    }
    /**
     * Get FaturaNumarasi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFaturaNumarasi()
    {
        return isset($this->FaturaNumarasi) ? $this->FaturaNumarasi : null;
    }
    /**
     * Set FaturaNumarasi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $faturaNumarasi
     * @return \SelectSiparis\UpdateEfaturaRequest
     */
    public function setFaturaNumarasi($faturaNumarasi = null)
    {
        // validation for constraint: string
        if (!is_null($faturaNumarasi) && !is_string($faturaNumarasi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faturaNumarasi, true), gettype($faturaNumarasi)), __LINE__);
        }
        if (is_null($faturaNumarasi) || (is_array($faturaNumarasi) && empty($faturaNumarasi))) {
            unset($this->FaturaNumarasi);
        } else {
            $this->FaturaNumarasi = $faturaNumarasi;
        }
        return $this;
    }
    /**
     * Get FaturaTipi value
     * @return int|null
     */
    public function getFaturaTipi()
    {
        return $this->FaturaTipi;
    }
    /**
     * Set FaturaTipi value
     * @param int $faturaTipi
     * @return \SelectSiparis\UpdateEfaturaRequest
     */
    public function setFaturaTipi($faturaTipi = null)
    {
        // validation for constraint: int
        if (!is_null($faturaTipi) && !(is_int($faturaTipi) || ctype_digit($faturaTipi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($faturaTipi, true), gettype($faturaTipi)), __LINE__);
        }
        $this->FaturaTipi = $faturaTipi;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \SelectSiparis\UpdateEfaturaRequest
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get OlusturmaTarihi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOlusturmaTarihi()
    {
        return isset($this->OlusturmaTarihi) ? $this->OlusturmaTarihi : null;
    }
    /**
     * Set OlusturmaTarihi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $olusturmaTarihi
     * @return \SelectSiparis\UpdateEfaturaRequest
     */
    public function setOlusturmaTarihi($olusturmaTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($olusturmaTarihi) && !is_string($olusturmaTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($olusturmaTarihi, true), gettype($olusturmaTarihi)), __LINE__);
        }
        if (is_null($olusturmaTarihi) || (is_array($olusturmaTarihi) && empty($olusturmaTarihi))) {
            unset($this->OlusturmaTarihi);
        } else {
            $this->OlusturmaTarihi = $olusturmaTarihi;
        }
        return $this;
    }
    /**
     * Get SiparisId value
     * @return int|null
     */
    public function getSiparisId()
    {
        return $this->SiparisId;
    }
    /**
     * Set SiparisId value
     * @param int $siparisId
     * @return \SelectSiparis\UpdateEfaturaRequest
     */
    public function setSiparisId($siparisId = null)
    {
        // validation for constraint: int
        if (!is_null($siparisId) && !(is_int($siparisId) || ctype_digit($siparisId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisId, true), gettype($siparisId)), __LINE__);
        }
        $this->SiparisId = $siparisId;
        return $this;
    }
}
