<?php

namespace SelectSiparis;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectSiparisDurumRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SelectSiparisDurumRequest
 * @subpackage Structs
 */
class SelectSiparisDurumRequest extends AbstractStructBase
{
    /**
     * The SiparisID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisID;
    /**
     * The SiparisNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiparisNo;
    /**
     * Constructor method for SelectSiparisDurumRequest
     * @uses SelectSiparisDurumRequest::setSiparisID()
     * @uses SelectSiparisDurumRequest::setSiparisNo()
     * @param int $siparisID
     * @param string $siparisNo
     */
    public function __construct($siparisID = null, $siparisNo = null)
    {
        $this
            ->setSiparisID($siparisID)
            ->setSiparisNo($siparisNo);
    }
    /**
     * Get SiparisID value
     * @return int|null
     */
    public function getSiparisID()
    {
        return $this->SiparisID;
    }
    /**
     * Set SiparisID value
     * @param int $siparisID
     * @return \SelectSiparis\SelectSiparisDurumRequest
     */
    public function setSiparisID($siparisID = null)
    {
        // validation for constraint: int
        if (!is_null($siparisID) && !(is_int($siparisID) || ctype_digit($siparisID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisID, true), gettype($siparisID)), __LINE__);
        }
        $this->SiparisID = $siparisID;
        return $this;
    }
    /**
     * Get SiparisNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiparisNo()
    {
        return isset($this->SiparisNo) ? $this->SiparisNo : null;
    }
    /**
     * Set SiparisNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siparisNo
     * @return \SelectSiparis\SelectSiparisDurumRequest
     */
    public function setSiparisNo($siparisNo = null)
    {
        // validation for constraint: string
        if (!is_null($siparisNo) && !is_string($siparisNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siparisNo, true), gettype($siparisNo)), __LINE__);
        }
        if (is_null($siparisNo) || (is_array($siparisNo) && empty($siparisNo))) {
            unset($this->SiparisNo);
        } else {
            $this->SiparisNo = $siparisNo;
        }
        return $this;
    }
}
