<?php

namespace SelectSiparis;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SiparisiKargoyaGonderRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SiparisiKargoyaGonderRequest
 * @subpackage Structs
 */
class SiparisiKargoyaGonderRequest extends AbstractStructBase
{
    /**
     * The KargoEntegrasyonId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KargoEntegrasyonId;
    /**
     * The MngMasrafkodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MngMasrafkodu;
    /**
     * The PaketId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaketId;
    /**
     * The SiparisId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisId;
    /**
     * The SiparisUrunDurumuId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisUrunDurumuId;
    /**
     * The SmsGonder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SmsGonder;
    /**
     * The UpsGonderiOncesiBildir
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UpsGonderiOncesiBildir;
    /**
     * The UpsPaketAdedi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UpsPaketAdedi;
    /**
     * The UpsPaketTipi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UpsPaketTipi;
    /**
     * Constructor method for SiparisiKargoyaGonderRequest
     * @uses SiparisiKargoyaGonderRequest::setKargoEntegrasyonId()
     * @uses SiparisiKargoyaGonderRequest::setMngMasrafkodu()
     * @uses SiparisiKargoyaGonderRequest::setPaketId()
     * @uses SiparisiKargoyaGonderRequest::setSiparisId()
     * @uses SiparisiKargoyaGonderRequest::setSiparisUrunDurumuId()
     * @uses SiparisiKargoyaGonderRequest::setSmsGonder()
     * @uses SiparisiKargoyaGonderRequest::setUpsGonderiOncesiBildir()
     * @uses SiparisiKargoyaGonderRequest::setUpsPaketAdedi()
     * @uses SiparisiKargoyaGonderRequest::setUpsPaketTipi()
     * @param int $kargoEntegrasyonId
     * @param string $mngMasrafkodu
     * @param int $paketId
     * @param int $siparisId
     * @param int $siparisUrunDurumuId
     * @param bool $smsGonder
     * @param bool $upsGonderiOncesiBildir
     * @param int $upsPaketAdedi
     * @param string $upsPaketTipi
     */
    public function __construct($kargoEntegrasyonId = null, $mngMasrafkodu = null, $paketId = null, $siparisId = null, $siparisUrunDurumuId = null, $smsGonder = null, $upsGonderiOncesiBildir = null, $upsPaketAdedi = null, $upsPaketTipi = null)
    {
        $this
            ->setKargoEntegrasyonId($kargoEntegrasyonId)
            ->setMngMasrafkodu($mngMasrafkodu)
            ->setPaketId($paketId)
            ->setSiparisId($siparisId)
            ->setSiparisUrunDurumuId($siparisUrunDurumuId)
            ->setSmsGonder($smsGonder)
            ->setUpsGonderiOncesiBildir($upsGonderiOncesiBildir)
            ->setUpsPaketAdedi($upsPaketAdedi)
            ->setUpsPaketTipi($upsPaketTipi);
    }
    /**
     * Get KargoEntegrasyonId value
     * @return int|null
     */
    public function getKargoEntegrasyonId()
    {
        return $this->KargoEntegrasyonId;
    }
    /**
     * Set KargoEntegrasyonId value
     * @param int $kargoEntegrasyonId
     * @return \SelectSiparis\SiparisiKargoyaGonderRequest
     */
    public function setKargoEntegrasyonId($kargoEntegrasyonId = null)
    {
        // validation for constraint: int
        if (!is_null($kargoEntegrasyonId) && !(is_int($kargoEntegrasyonId) || ctype_digit($kargoEntegrasyonId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kargoEntegrasyonId, true), gettype($kargoEntegrasyonId)), __LINE__);
        }
        $this->KargoEntegrasyonId = $kargoEntegrasyonId;
        return $this;
    }
    /**
     * Get MngMasrafkodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMngMasrafkodu()
    {
        return isset($this->MngMasrafkodu) ? $this->MngMasrafkodu : null;
    }
    /**
     * Set MngMasrafkodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mngMasrafkodu
     * @return \SelectSiparis\SiparisiKargoyaGonderRequest
     */
    public function setMngMasrafkodu($mngMasrafkodu = null)
    {
        // validation for constraint: string
        if (!is_null($mngMasrafkodu) && !is_string($mngMasrafkodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mngMasrafkodu, true), gettype($mngMasrafkodu)), __LINE__);
        }
        if (is_null($mngMasrafkodu) || (is_array($mngMasrafkodu) && empty($mngMasrafkodu))) {
            unset($this->MngMasrafkodu);
        } else {
            $this->MngMasrafkodu = $mngMasrafkodu;
        }
        return $this;
    }
    /**
     * Get PaketId value
     * @return int|null
     */
    public function getPaketId()
    {
        return $this->PaketId;
    }
    /**
     * Set PaketId value
     * @param int $paketId
     * @return \SelectSiparis\SiparisiKargoyaGonderRequest
     */
    public function setPaketId($paketId = null)
    {
        // validation for constraint: int
        if (!is_null($paketId) && !(is_int($paketId) || ctype_digit($paketId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paketId, true), gettype($paketId)), __LINE__);
        }
        $this->PaketId = $paketId;
        return $this;
    }
    /**
     * Get SiparisId value
     * @return int|null
     */
    public function getSiparisId()
    {
        return $this->SiparisId;
    }
    /**
     * Set SiparisId value
     * @param int $siparisId
     * @return \SelectSiparis\SiparisiKargoyaGonderRequest
     */
    public function setSiparisId($siparisId = null)
    {
        // validation for constraint: int
        if (!is_null($siparisId) && !(is_int($siparisId) || ctype_digit($siparisId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisId, true), gettype($siparisId)), __LINE__);
        }
        $this->SiparisId = $siparisId;
        return $this;
    }
    /**
     * Get SiparisUrunDurumuId value
     * @return int|null
     */
    public function getSiparisUrunDurumuId()
    {
        return $this->SiparisUrunDurumuId;
    }
    /**
     * Set SiparisUrunDurumuId value
     * @param int $siparisUrunDurumuId
     * @return \SelectSiparis\SiparisiKargoyaGonderRequest
     */
    public function setSiparisUrunDurumuId($siparisUrunDurumuId = null)
    {
        // validation for constraint: int
        if (!is_null($siparisUrunDurumuId) && !(is_int($siparisUrunDurumuId) || ctype_digit($siparisUrunDurumuId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisUrunDurumuId, true), gettype($siparisUrunDurumuId)), __LINE__);
        }
        $this->SiparisUrunDurumuId = $siparisUrunDurumuId;
        return $this;
    }
    /**
     * Get SmsGonder value
     * @return bool|null
     */
    public function getSmsGonder()
    {
        return $this->SmsGonder;
    }
    /**
     * Set SmsGonder value
     * @param bool $smsGonder
     * @return \SelectSiparis\SiparisiKargoyaGonderRequest
     */
    public function setSmsGonder($smsGonder = null)
    {
        // validation for constraint: boolean
        if (!is_null($smsGonder) && !is_bool($smsGonder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($smsGonder, true), gettype($smsGonder)), __LINE__);
        }
        $this->SmsGonder = $smsGonder;
        return $this;
    }
    /**
     * Get UpsGonderiOncesiBildir value
     * @return bool|null
     */
    public function getUpsGonderiOncesiBildir()
    {
        return $this->UpsGonderiOncesiBildir;
    }
    /**
     * Set UpsGonderiOncesiBildir value
     * @param bool $upsGonderiOncesiBildir
     * @return \SelectSiparis\SiparisiKargoyaGonderRequest
     */
    public function setUpsGonderiOncesiBildir($upsGonderiOncesiBildir = null)
    {
        // validation for constraint: boolean
        if (!is_null($upsGonderiOncesiBildir) && !is_bool($upsGonderiOncesiBildir)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($upsGonderiOncesiBildir, true), gettype($upsGonderiOncesiBildir)), __LINE__);
        }
        $this->UpsGonderiOncesiBildir = $upsGonderiOncesiBildir;
        return $this;
    }
    /**
     * Get UpsPaketAdedi value
     * @return int|null
     */
    public function getUpsPaketAdedi()
    {
        return $this->UpsPaketAdedi;
    }
    /**
     * Set UpsPaketAdedi value
     * @param int $upsPaketAdedi
     * @return \SelectSiparis\SiparisiKargoyaGonderRequest
     */
    public function setUpsPaketAdedi($upsPaketAdedi = null)
    {
        // validation for constraint: int
        if (!is_null($upsPaketAdedi) && !(is_int($upsPaketAdedi) || ctype_digit($upsPaketAdedi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($upsPaketAdedi, true), gettype($upsPaketAdedi)), __LINE__);
        }
        $this->UpsPaketAdedi = $upsPaketAdedi;
        return $this;
    }
    /**
     * Get UpsPaketTipi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpsPaketTipi()
    {
        return isset($this->UpsPaketTipi) ? $this->UpsPaketTipi : null;
    }
    /**
     * Set UpsPaketTipi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $upsPaketTipi
     * @return \SelectSiparis\SiparisiKargoyaGonderRequest
     */
    public function setUpsPaketTipi($upsPaketTipi = null)
    {
        // validation for constraint: string
        if (!is_null($upsPaketTipi) && !is_string($upsPaketTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upsPaketTipi, true), gettype($upsPaketTipi)), __LINE__);
        }
        if (is_null($upsPaketTipi) || (is_array($upsPaketTipi) && empty($upsPaketTipi))) {
            unset($this->UpsPaketTipi);
        } else {
            $this->UpsPaketTipi = $upsPaketTipi;
        }
        return $this;
    }
}
