<?php

namespace SelectSiparis;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for all operations
 * @subpackage Services
 */
class Service extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SelectSiparis
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SelectSiparis $parameters
     * @return \SelectSiparis\SelectSiparisResponse|bool
     */
    public function SelectSiparis(\SelectSiparis\SelectSiparis $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectSiparis($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectSiparisOdeme
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SelectSiparisOdeme $parameters
     * @return \SelectSiparis\SelectSiparisOdemeResponse|bool
     */
    public function SelectSiparisOdeme(\SelectSiparis\SelectSiparisOdeme $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectSiparisOdeme($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectCariOdeme
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SelectCariOdeme $parameters
     * @return \SelectSiparis\SelectCariOdemeResponse|bool
     */
    public function SelectCariOdeme(\SelectSiparis\SelectCariOdeme $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectCariOdeme($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectSiparisUrun
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SelectSiparisUrun $parameters
     * @return \SelectSiparis\SelectSiparisUrunResponse|bool
     */
    public function SelectSiparisUrun(\SelectSiparis\SelectSiparisUrun $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectSiparisUrun($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectSiparisKampanya
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SelectSiparisKampanya $parameters
     * @return \SelectSiparis\SelectSiparisKampanyaResponse|bool
     */
    public function SelectSiparisKampanya(\SelectSiparis\SelectSiparisKampanya $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectSiparisKampanya($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveSiparis
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SaveSiparis $parameters
     * @return \SelectSiparis\SaveSiparisResponse|bool
     */
    public function SaveSiparis(\SelectSiparis\SaveSiparis $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveSiparis($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSiparisAktarildi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SetSiparisAktarildi $parameters
     * @return \SelectSiparis\SetSiparisAktarildiResponse|bool
     */
    public function SetSiparisAktarildi(\SelectSiparis\SetSiparisAktarildi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetSiparisAktarildi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSiparisAktarildiV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SetSiparisAktarildiV2 $parameters
     * @return \SelectSiparis\SetSiparisAktarildiV2Response|bool
     */
    public function SetSiparisAktarildiV2(\SelectSiparis\SetSiparisAktarildiV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetSiparisAktarildiV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSiparisAktarildiIptal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SetSiparisAktarildiIptal $parameters
     * @return \SelectSiparis\SetSiparisAktarildiIptalResponse|bool
     */
    public function SetSiparisAktarildiIptal(\SelectSiparis\SetSiparisAktarildiIptal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetSiparisAktarildiIptal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSiparisKargoyaVerildi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SetSiparisKargoyaVerildi $parameters
     * @return \SelectSiparis\SetSiparisKargoyaVerildiResponse|bool
     */
    public function SetSiparisKargoyaVerildi(\SelectSiparis\SetSiparisKargoyaVerildi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetSiparisKargoyaVerildi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSiparisTeslimEdildi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SetSiparisTeslimEdildi $parameters
     * @return \SelectSiparis\SetSiparisTeslimEdildiResponse|bool
     */
    public function SetSiparisTeslimEdildi(\SelectSiparis\SetSiparisTeslimEdildi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetSiparisTeslimEdildi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetFaturaNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SetFaturaNo $parameters
     * @return \SelectSiparis\SetFaturaNoResponse|bool
     */
    public function SetFaturaNo(\SelectSiparis\SetFaturaNo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetFaturaNo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveKargoTakipNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SaveKargoTakipNo $parameters
     * @return \SelectSiparis\SaveKargoTakipNoResponse|bool
     */
    public function SaveKargoTakipNo(\SelectSiparis\SaveKargoTakipNo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveKargoTakipNo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectSepet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SelectSepet $parameters
     * @return \SelectSiparis\SelectSepetResponse|bool
     */
    public function SelectSepet(\SelectSiparis\SelectSepet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectSepet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named HediyeCekiUygula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\HediyeCekiUygula $parameters
     * @return \SelectSiparis\HediyeCekiUygulaResponse|bool
     */
    public function HediyeCekiUygula(\SelectSiparis\HediyeCekiUygula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HediyeCekiUygula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSiparisDurum
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SetSiparisDurum $parameters
     * @return \SelectSiparis\SetSiparisDurumResponse|bool
     */
    public function SetSiparisDurum(\SelectSiparis\SetSiparisDurum $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetSiparisDurum($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSiparisUrunDurum
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SetSiparisUrunDurum $parameters
     * @return \SelectSiparis\SetSiparisUrunDurumResponse|bool
     */
    public function SetSiparisUrunDurum(\SelectSiparis\SetSiparisUrunDurum $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetSiparisUrunDurum($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveSiparisKargoPaket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SaveSiparisKargoPaket $parameters
     * @return \SelectSiparis\SaveSiparisKargoPaketResponse|bool
     */
    public function SaveSiparisKargoPaket(\SelectSiparis\SaveSiparisKargoPaket $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveSiparisKargoPaket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SiparisPaketleKargoyaGonder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SiparisPaketleKargoyaGonder $parameters
     * @return \SelectSiparis\SiparisPaketleKargoyaGonderResponse|bool
     */
    public function SiparisPaketleKargoyaGonder(\SelectSiparis\SiparisPaketleKargoyaGonder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SiparisPaketleKargoyaGonder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectSiparisUrunDurumlari
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SelectSiparisUrunDurumlari $parameters
     * @return \SelectSiparis\SelectSiparisUrunDurumlariResponse|bool
     */
    public function SelectSiparisUrunDurumlari(\SelectSiparis\SelectSiparisUrunDurumlari $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectSiparisUrunDurumlari($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectUrunIadeNedenleri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SelectUrunIadeNedenleri $parameters
     * @return \SelectSiparis\SelectUrunIadeNedenleriResponse|bool
     */
    public function SelectUrunIadeNedenleri(\SelectSiparis\SelectUrunIadeNedenleri $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectUrunIadeNedenleri($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectSiparisKargoPaket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SelectSiparisKargoPaket $parameters
     * @return \SelectSiparis\SelectSiparisKargoPaketResponse|bool
     */
    public function SelectSiparisKargoPaket(\SelectSiparis\SelectSiparisKargoPaket $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectSiparisKargoPaket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveSiparisKargoPaketKargoTakipNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SaveSiparisKargoPaketKargoTakipNo $parameters
     * @return \SelectSiparis\SaveSiparisKargoPaketKargoTakipNoResponse|bool
     */
    public function SaveSiparisKargoPaketKargoTakipNo(\SelectSiparis\SaveSiparisKargoPaketKargoTakipNo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveSiparisKargoPaketKargoTakipNo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetKargoSecenek
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\GetKargoSecenek $parameters
     * @return \SelectSiparis\GetKargoSecenekResponse|bool
     */
    public function GetKargoSecenek(\SelectSiparis\GetKargoSecenek $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetKargoSecenek($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectWebSepet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SelectWebSepet $parameters
     * @return \SelectSiparis\SelectWebSepetResponse|bool
     */
    public function SelectWebSepet(\SelectSiparis\SelectWebSepet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectWebSepet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateSepet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\CreateSepet $parameters
     * @return \SelectSiparis\CreateSepetResponse|bool
     */
    public function CreateSepet(\SelectSiparis\CreateSepet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateSepet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateSepet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\UpdateSepet $parameters
     * @return \SelectSiparis\UpdateSepetResponse|bool
     */
    public function UpdateSepet(\SelectSiparis\UpdateSepet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateSepet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSepet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\GetSepet $parameters
     * @return \SelectSiparis\GetSepetResponse|bool
     */
    public function GetSepet(\SelectSiparis\GetSepet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSepet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOdemeTipleri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\GetOdemeTipleri $parameters
     * @return \SelectSiparis\GetOdemeTipleriResponse|bool
     */
    public function GetOdemeTipleri(\SelectSiparis\GetOdemeTipleri $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOdemeTipleri($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSepetKampanya
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SetSepetKampanya $parameters
     * @return \SelectSiparis\SetSepetKampanyaResponse|bool
     */
    public function SetSepetKampanya(\SelectSiparis\SetSepetKampanya $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetSepetKampanya($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPaketlemeDurumlari
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\GetPaketlemeDurumlari $parameters
     * @return \SelectSiparis\GetPaketlemeDurumlariResponse|bool
     */
    public function GetPaketlemeDurumlari(\SelectSiparis\GetPaketlemeDurumlari $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPaketlemeDurumlari($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMagazalar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\GetMagazalar $parameters
     * @return \SelectSiparis\GetMagazalarResponse|bool
     */
    public function GetMagazalar(\SelectSiparis\GetMagazalar $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMagazalar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveMagaza
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SaveMagaza $parameters
     * @return \SelectSiparis\SaveMagazaResponse|bool
     */
    public function SaveMagaza(\SelectSiparis\SaveMagaza $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveMagaza($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSiparisPaketlemeDurum
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SetSiparisPaketlemeDurum $parameters
     * @return \SelectSiparis\SetSiparisPaketlemeDurumResponse|bool
     */
    public function SetSiparisPaketlemeDurum(\SelectSiparis\SetSiparisPaketlemeDurum $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetSiparisPaketlemeDurum($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSiparisKargoFirmaId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SetSiparisKargoFirmaId $parameters
     * @return \SelectSiparis\SetSiparisKargoFirmaIdResponse|bool
     */
    public function SetSiparisKargoFirmaId(\SelectSiparis\SetSiparisKargoFirmaId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetSiparisKargoFirmaId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSiparisOdemeDurum
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SetSiparisOdemeDurum $parameters
     * @return \SelectSiparis\SetSiparisOdemeDurumResponse|bool
     */
    public function SetSiparisOdemeDurum(\SelectSiparis\SetSiparisOdemeDurum $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetSiparisOdemeDurum($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectEFatura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SelectEFatura $parameters
     * @return \SelectSiparis\SelectEFaturaResponse|bool
     */
    public function SelectEFatura(\SelectSiparis\SelectEFatura $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectEFatura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveEFatura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SaveEFatura $parameters
     * @return \SelectSiparis\SaveEFaturaResponse|bool
     */
    public function SaveEFatura(\SelectSiparis\SaveEFatura $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveEFatura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetEFaturaIptal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SetEFaturaIptal $parameters
     * @return \SelectSiparis\SetEFaturaIptalResponse|bool
     */
    public function SetEFaturaIptal(\SelectSiparis\SetEFaturaIptal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetEFaturaIptal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectIadeOdeme
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SelectIadeOdeme $parameters
     * @return \SelectSiparis\SelectIadeOdemeResponse|bool
     */
    public function SelectIadeOdeme(\SelectSiparis\SelectIadeOdeme $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectIadeOdeme($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveBekleyenArama
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SaveBekleyenArama $parameters
     * @return \SelectSiparis\SaveBekleyenAramaResponse|bool
     */
    public function SaveBekleyenArama(\SelectSiparis\SaveBekleyenArama $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveBekleyenArama($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectSiparisDurumlari
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SelectSiparisDurumlari $parameters
     * @return \SelectSiparis\SelectSiparisDurumlariResponse|bool
     */
    public function SelectSiparisDurumlari(\SelectSiparis\SelectSiparisDurumlari $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectSiparisDurumlari($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectOdemeTipleri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SelectOdemeTipleri $parameters
     * @return \SelectSiparis\SelectOdemeTipleriResponse|bool
     */
    public function SelectOdemeTipleri(\SelectSiparis\SelectOdemeTipleri $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectOdemeTipleri($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetReferansNo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SetReferansNo $parameters
     * @return \SelectSiparis\SetReferansNoResponse|bool
     */
    public function SetReferansNo(\SelectSiparis\SetReferansNo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetReferansNo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSiparisDurumListe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SetSiparisDurumListe $parameters
     * @return \SelectSiparis\SetSiparisDurumListeResponse|bool
     */
    public function SetSiparisDurumListe(\SelectSiparis\SetSiparisDurumListe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetSiparisDurumListe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectSiparisDurum
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SelectSiparisDurum $parameters
     * @return \SelectSiparis\SelectSiparisDurumResponse|bool
     */
    public function SelectSiparisDurum(\SelectSiparis\SelectSiparisDurum $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectSiparisDurum($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectSiparisDurumLog
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SelectSiparisDurumLog $parameters
     * @return \SelectSiparis\SelectSiparisDurumLogResponse|bool
     */
    public function SelectSiparisDurumLog(\SelectSiparis\SelectSiparisDurumLog $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectSiparisDurumLog($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateEFatura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\UpdateEFatura $parameters
     * @return \SelectSiparis\UpdateEFaturaResponse_1|bool
     */
    public function UpdateEFatura(\SelectSiparis\UpdateEFatura $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateEFatura($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveIadeOdeme
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SaveIadeOdeme $parameters
     * @return \SelectSiparis\SaveIadeOdemeResponse|bool
     */
    public function SaveIadeOdeme(\SelectSiparis\SaveIadeOdeme $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveIadeOdeme($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SiparisAnonimlestir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \SelectSiparis\SiparisAnonimlestir $parameters
     * @return \SelectSiparis\SiparisAnonimlestirResponse|bool
     */
    public function SiparisAnonimlestir(\SelectSiparis\SiparisAnonimlestir $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SiparisAnonimlestir($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \SelectSiparis\CreateSepetResponse|\SelectSiparis\GetKargoSecenekResponse|\SelectSiparis\GetMagazalarResponse|\SelectSiparis\GetOdemeTipleriResponse|\SelectSiparis\GetPaketlemeDurumlariResponse|\SelectSiparis\GetSepetResponse|\SelectSiparis\HediyeCekiUygulaResponse|\SelectSiparis\SaveBekleyenAramaResponse|\SelectSiparis\SaveEFaturaResponse|\SelectSiparis\SaveIadeOdemeResponse|\SelectSiparis\SaveKargoTakipNoResponse|\SelectSiparis\SaveMagazaResponse|\SelectSiparis\SaveSiparisKargoPaketKargoTakipNoResponse|\SelectSiparis\SaveSiparisKargoPaketResponse|\SelectSiparis\SaveSiparisResponse|\SelectSiparis\SelectCariOdemeResponse|\SelectSiparis\SelectEFaturaResponse|\SelectSiparis\SelectIadeOdemeResponse|\SelectSiparis\SelectOdemeTipleriResponse|\SelectSiparis\SelectSepetResponse|\SelectSiparis\SelectSiparisDurumlariResponse|\SelectSiparis\SelectSiparisDurumLogResponse|\SelectSiparis\SelectSiparisDurumResponse|\SelectSiparis\SelectSiparisKampanyaResponse|\SelectSiparis\SelectSiparisKargoPaketResponse|\SelectSiparis\SelectSiparisOdemeResponse|\SelectSiparis\SelectSiparisResponse|\SelectSiparis\SelectSiparisUrunDurumlariResponse|\SelectSiparis\SelectSiparisUrunResponse|\SelectSiparis\SelectUrunIadeNedenleriResponse|\SelectSiparis\SelectWebSepetResponse|\SelectSiparis\SetEFaturaIptalResponse|\SelectSiparis\SetFaturaNoResponse|\SelectSiparis\SetReferansNoResponse|\SelectSiparis\SetSepetKampanyaResponse|\SelectSiparis\SetSiparisAktarildiIptalResponse|\SelectSiparis\SetSiparisAktarildiResponse|\SelectSiparis\SetSiparisAktarildiV2Response|\SelectSiparis\SetSiparisDurumListeResponse|\SelectSiparis\SetSiparisDurumResponse|\SelectSiparis\SetSiparisKargoFirmaIdResponse|\SelectSiparis\SetSiparisKargoyaVerildiResponse|\SelectSiparis\SetSiparisOdemeDurumResponse|\SelectSiparis\SetSiparisPaketlemeDurumResponse|\SelectSiparis\SetSiparisTeslimEdildiResponse|\SelectSiparis\SetSiparisUrunDurumResponse|\SelectSiparis\SiparisAnonimlestirResponse|\SelectSiparis\SiparisPaketleKargoyaGonderResponse|\SelectSiparis\UpdateEFaturaResponse_1|\SelectSiparis\UpdateSepetResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
