<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PessoaDTO StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PessoaDTO
 * @subpackage Structs
 */
class PessoaDTO extends AbstractStructBase
{
    /**
     * The CNPJ
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CNPJ;
    /**
     * The CPF
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CPF;
    /**
     * The DDD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DDD;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Endereco
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EnderecoDTO
     */
    public $Endereco;
    /**
     * The InscricaoMunicipal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InscricaoMunicipal;
    /**
     * The Nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nome;
    /**
     * The Telefone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Telefone;
    /**
     * Constructor method for PessoaDTO
     * @uses PessoaDTO::setCNPJ()
     * @uses PessoaDTO::setCPF()
     * @uses PessoaDTO::setDDD()
     * @uses PessoaDTO::setEmail()
     * @uses PessoaDTO::setEndereco()
     * @uses PessoaDTO::setInscricaoMunicipal()
     * @uses PessoaDTO::setNome()
     * @uses PessoaDTO::setTelefone()
     * @param string $cNPJ
     * @param string $cPF
     * @param string $dDD
     * @param string $email
     * @param \StructType\EnderecoDTO $endereco
     * @param string $inscricaoMunicipal
     * @param string $nome
     * @param string $telefone
     */
    public function __construct($cNPJ = null, $cPF = null, $dDD = null, $email = null, \StructType\EnderecoDTO $endereco = null, $inscricaoMunicipal = null, $nome = null, $telefone = null)
    {
        $this
            ->setCNPJ($cNPJ)
            ->setCPF($cPF)
            ->setDDD($dDD)
            ->setEmail($email)
            ->setEndereco($endereco)
            ->setInscricaoMunicipal($inscricaoMunicipal)
            ->setNome($nome)
            ->setTelefone($telefone);
    }
    /**
     * Get CNPJ value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCNPJ()
    {
        return isset($this->CNPJ) ? $this->CNPJ : null;
    }
    /**
     * Set CNPJ value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cNPJ
     * @return \StructType\PessoaDTO
     */
    public function setCNPJ($cNPJ = null)
    {
        // validation for constraint: string
        if (!is_null($cNPJ) && !is_string($cNPJ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cNPJ, true), gettype($cNPJ)), __LINE__);
        }
        if (is_null($cNPJ) || (is_array($cNPJ) && empty($cNPJ))) {
            unset($this->CNPJ);
        } else {
            $this->CNPJ = $cNPJ;
        }
        return $this;
    }
    /**
     * Get CPF value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCPF()
    {
        return isset($this->CPF) ? $this->CPF : null;
    }
    /**
     * Set CPF value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cPF
     * @return \StructType\PessoaDTO
     */
    public function setCPF($cPF = null)
    {
        // validation for constraint: string
        if (!is_null($cPF) && !is_string($cPF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cPF, true), gettype($cPF)), __LINE__);
        }
        if (is_null($cPF) || (is_array($cPF) && empty($cPF))) {
            unset($this->CPF);
        } else {
            $this->CPF = $cPF;
        }
        return $this;
    }
    /**
     * Get DDD value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDDD()
    {
        return isset($this->DDD) ? $this->DDD : null;
    }
    /**
     * Set DDD value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dDD
     * @return \StructType\PessoaDTO
     */
    public function setDDD($dDD = null)
    {
        // validation for constraint: string
        if (!is_null($dDD) && !is_string($dDD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dDD, true), gettype($dDD)), __LINE__);
        }
        if (is_null($dDD) || (is_array($dDD) && empty($dDD))) {
            unset($this->DDD);
        } else {
            $this->DDD = $dDD;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\PessoaDTO
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Endereco value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EnderecoDTO|null
     */
    public function getEndereco()
    {
        return isset($this->Endereco) ? $this->Endereco : null;
    }
    /**
     * Set Endereco value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\EnderecoDTO $endereco
     * @return \StructType\PessoaDTO
     */
    public function setEndereco(\StructType\EnderecoDTO $endereco = null)
    {
        if (is_null($endereco) || (is_array($endereco) && empty($endereco))) {
            unset($this->Endereco);
        } else {
            $this->Endereco = $endereco;
        }
        return $this;
    }
    /**
     * Get InscricaoMunicipal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInscricaoMunicipal()
    {
        return isset($this->InscricaoMunicipal) ? $this->InscricaoMunicipal : null;
    }
    /**
     * Set InscricaoMunicipal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inscricaoMunicipal
     * @return \StructType\PessoaDTO
     */
    public function setInscricaoMunicipal($inscricaoMunicipal = null)
    {
        // validation for constraint: string
        if (!is_null($inscricaoMunicipal) && !is_string($inscricaoMunicipal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inscricaoMunicipal, true), gettype($inscricaoMunicipal)), __LINE__);
        }
        if (is_null($inscricaoMunicipal) || (is_array($inscricaoMunicipal) && empty($inscricaoMunicipal))) {
            unset($this->InscricaoMunicipal);
        } else {
            $this->InscricaoMunicipal = $inscricaoMunicipal;
        }
        return $this;
    }
    /**
     * Get Nome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNome()
    {
        return isset($this->Nome) ? $this->Nome : null;
    }
    /**
     * Set Nome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nome
     * @return \StructType\PessoaDTO
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        if (is_null($nome) || (is_array($nome) && empty($nome))) {
            unset($this->Nome);
        } else {
            $this->Nome = $nome;
        }
        return $this;
    }
    /**
     * Get Telefone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefone()
    {
        return isset($this->Telefone) ? $this->Telefone : null;
    }
    /**
     * Set Telefone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefone
     * @return \StructType\PessoaDTO
     */
    public function setTelefone($telefone = null)
    {
        // validation for constraint: string
        if (!is_null($telefone) && !is_string($telefone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefone, true), gettype($telefone)), __LINE__);
        }
        if (is_null($telefone) || (is_array($telefone) && empty($telefone))) {
            unset($this->Telefone);
        } else {
            $this->Telefone = $telefone;
        }
        return $this;
    }
}
