<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotaFiscalRepasseDTO StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NotaFiscalRepasseDTO
 * @subpackage Structs
 */
class NotaFiscalRepasseDTO extends AbstractStructBase
{
    /**
     * The ChaveAutenticacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChaveAutenticacao;
    /**
     * The ConteudoEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConteudoEmail;
    /**
     * The Discriminacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Discriminacao;
    /**
     * The EmailDestinatario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailDestinatario;
    /**
     * The EnviarPorEmail
     * @var bool
     */
    public $EnviarPorEmail;
    /**
     * The ExercicioReferencia
     * @var int
     */
    public $ExercicioReferencia;
    /**
     * The MesReferencia
     * @var int
     */
    public $MesReferencia;
    /**
     * The Receptor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PessoaDTO
     */
    public $Receptor;
    /**
     * The ValorCSLL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorCSLL;
    /**
     * The ValorCofins
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorCofins;
    /**
     * The ValorINSS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorINSS;
    /**
     * The ValorIRRF
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorIRRF;
    /**
     * The ValorNota
     * @var float
     */
    public $ValorNota;
    /**
     * The ValorPisPasep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorPisPasep;
    /**
     * The ValorRepasse
     * @var float
     */
    public $ValorRepasse;
    /**
     * Constructor method for NotaFiscalRepasseDTO
     * @uses NotaFiscalRepasseDTO::setChaveAutenticacao()
     * @uses NotaFiscalRepasseDTO::setConteudoEmail()
     * @uses NotaFiscalRepasseDTO::setDiscriminacao()
     * @uses NotaFiscalRepasseDTO::setEmailDestinatario()
     * @uses NotaFiscalRepasseDTO::setEnviarPorEmail()
     * @uses NotaFiscalRepasseDTO::setExercicioReferencia()
     * @uses NotaFiscalRepasseDTO::setMesReferencia()
     * @uses NotaFiscalRepasseDTO::setReceptor()
     * @uses NotaFiscalRepasseDTO::setValorCSLL()
     * @uses NotaFiscalRepasseDTO::setValorCofins()
     * @uses NotaFiscalRepasseDTO::setValorINSS()
     * @uses NotaFiscalRepasseDTO::setValorIRRF()
     * @uses NotaFiscalRepasseDTO::setValorNota()
     * @uses NotaFiscalRepasseDTO::setValorPisPasep()
     * @uses NotaFiscalRepasseDTO::setValorRepasse()
     * @param string $chaveAutenticacao
     * @param string $conteudoEmail
     * @param string $discriminacao
     * @param string $emailDestinatario
     * @param bool $enviarPorEmail
     * @param int $exercicioReferencia
     * @param int $mesReferencia
     * @param \StructType\PessoaDTO $receptor
     * @param float $valorCSLL
     * @param float $valorCofins
     * @param float $valorINSS
     * @param float $valorIRRF
     * @param float $valorNota
     * @param float $valorPisPasep
     * @param float $valorRepasse
     */
    public function __construct($chaveAutenticacao = null, $conteudoEmail = null, $discriminacao = null, $emailDestinatario = null, $enviarPorEmail = null, $exercicioReferencia = null, $mesReferencia = null, \StructType\PessoaDTO $receptor = null, $valorCSLL = null, $valorCofins = null, $valorINSS = null, $valorIRRF = null, $valorNota = null, $valorPisPasep = null, $valorRepasse = null)
    {
        $this
            ->setChaveAutenticacao($chaveAutenticacao)
            ->setConteudoEmail($conteudoEmail)
            ->setDiscriminacao($discriminacao)
            ->setEmailDestinatario($emailDestinatario)
            ->setEnviarPorEmail($enviarPorEmail)
            ->setExercicioReferencia($exercicioReferencia)
            ->setMesReferencia($mesReferencia)
            ->setReceptor($receptor)
            ->setValorCSLL($valorCSLL)
            ->setValorCofins($valorCofins)
            ->setValorINSS($valorINSS)
            ->setValorIRRF($valorIRRF)
            ->setValorNota($valorNota)
            ->setValorPisPasep($valorPisPasep)
            ->setValorRepasse($valorRepasse);
    }
    /**
     * Get ChaveAutenticacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChaveAutenticacao()
    {
        return isset($this->ChaveAutenticacao) ? $this->ChaveAutenticacao : null;
    }
    /**
     * Set ChaveAutenticacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chaveAutenticacao
     * @return \StructType\NotaFiscalRepasseDTO
     */
    public function setChaveAutenticacao($chaveAutenticacao = null)
    {
        // validation for constraint: string
        if (!is_null($chaveAutenticacao) && !is_string($chaveAutenticacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chaveAutenticacao, true), gettype($chaveAutenticacao)), __LINE__);
        }
        if (is_null($chaveAutenticacao) || (is_array($chaveAutenticacao) && empty($chaveAutenticacao))) {
            unset($this->ChaveAutenticacao);
        } else {
            $this->ChaveAutenticacao = $chaveAutenticacao;
        }
        return $this;
    }
    /**
     * Get ConteudoEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConteudoEmail()
    {
        return isset($this->ConteudoEmail) ? $this->ConteudoEmail : null;
    }
    /**
     * Set ConteudoEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $conteudoEmail
     * @return \StructType\NotaFiscalRepasseDTO
     */
    public function setConteudoEmail($conteudoEmail = null)
    {
        // validation for constraint: string
        if (!is_null($conteudoEmail) && !is_string($conteudoEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conteudoEmail, true), gettype($conteudoEmail)), __LINE__);
        }
        if (is_null($conteudoEmail) || (is_array($conteudoEmail) && empty($conteudoEmail))) {
            unset($this->ConteudoEmail);
        } else {
            $this->ConteudoEmail = $conteudoEmail;
        }
        return $this;
    }
    /**
     * Get Discriminacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDiscriminacao()
    {
        return isset($this->Discriminacao) ? $this->Discriminacao : null;
    }
    /**
     * Set Discriminacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $discriminacao
     * @return \StructType\NotaFiscalRepasseDTO
     */
    public function setDiscriminacao($discriminacao = null)
    {
        // validation for constraint: string
        if (!is_null($discriminacao) && !is_string($discriminacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discriminacao, true), gettype($discriminacao)), __LINE__);
        }
        if (is_null($discriminacao) || (is_array($discriminacao) && empty($discriminacao))) {
            unset($this->Discriminacao);
        } else {
            $this->Discriminacao = $discriminacao;
        }
        return $this;
    }
    /**
     * Get EmailDestinatario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailDestinatario()
    {
        return isset($this->EmailDestinatario) ? $this->EmailDestinatario : null;
    }
    /**
     * Set EmailDestinatario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailDestinatario
     * @return \StructType\NotaFiscalRepasseDTO
     */
    public function setEmailDestinatario($emailDestinatario = null)
    {
        // validation for constraint: string
        if (!is_null($emailDestinatario) && !is_string($emailDestinatario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailDestinatario, true), gettype($emailDestinatario)), __LINE__);
        }
        if (is_null($emailDestinatario) || (is_array($emailDestinatario) && empty($emailDestinatario))) {
            unset($this->EmailDestinatario);
        } else {
            $this->EmailDestinatario = $emailDestinatario;
        }
        return $this;
    }
    /**
     * Get EnviarPorEmail value
     * @return bool|null
     */
    public function getEnviarPorEmail()
    {
        return $this->EnviarPorEmail;
    }
    /**
     * Set EnviarPorEmail value
     * @param bool $enviarPorEmail
     * @return \StructType\NotaFiscalRepasseDTO
     */
    public function setEnviarPorEmail($enviarPorEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($enviarPorEmail) && !is_bool($enviarPorEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enviarPorEmail, true), gettype($enviarPorEmail)), __LINE__);
        }
        $this->EnviarPorEmail = $enviarPorEmail;
        return $this;
    }
    /**
     * Get ExercicioReferencia value
     * @return int|null
     */
    public function getExercicioReferencia()
    {
        return $this->ExercicioReferencia;
    }
    /**
     * Set ExercicioReferencia value
     * @param int $exercicioReferencia
     * @return \StructType\NotaFiscalRepasseDTO
     */
    public function setExercicioReferencia($exercicioReferencia = null)
    {
        // validation for constraint: int
        if (!is_null($exercicioReferencia) && !(is_int($exercicioReferencia) || ctype_digit($exercicioReferencia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exercicioReferencia, true), gettype($exercicioReferencia)), __LINE__);
        }
        $this->ExercicioReferencia = $exercicioReferencia;
        return $this;
    }
    /**
     * Get MesReferencia value
     * @return int|null
     */
    public function getMesReferencia()
    {
        return $this->MesReferencia;
    }
    /**
     * Set MesReferencia value
     * @param int $mesReferencia
     * @return \StructType\NotaFiscalRepasseDTO
     */
    public function setMesReferencia($mesReferencia = null)
    {
        // validation for constraint: int
        if (!is_null($mesReferencia) && !(is_int($mesReferencia) || ctype_digit($mesReferencia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mesReferencia, true), gettype($mesReferencia)), __LINE__);
        }
        $this->MesReferencia = $mesReferencia;
        return $this;
    }
    /**
     * Get Receptor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PessoaDTO|null
     */
    public function getReceptor()
    {
        return isset($this->Receptor) ? $this->Receptor : null;
    }
    /**
     * Set Receptor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PessoaDTO $receptor
     * @return \StructType\NotaFiscalRepasseDTO
     */
    public function setReceptor(\StructType\PessoaDTO $receptor = null)
    {
        if (is_null($receptor) || (is_array($receptor) && empty($receptor))) {
            unset($this->Receptor);
        } else {
            $this->Receptor = $receptor;
        }
        return $this;
    }
    /**
     * Get ValorCSLL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorCSLL()
    {
        return isset($this->ValorCSLL) ? $this->ValorCSLL : null;
    }
    /**
     * Set ValorCSLL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorCSLL
     * @return \StructType\NotaFiscalRepasseDTO
     */
    public function setValorCSLL($valorCSLL = null)
    {
        // validation for constraint: float
        if (!is_null($valorCSLL) && !(is_float($valorCSLL) || is_numeric($valorCSLL))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorCSLL, true), gettype($valorCSLL)), __LINE__);
        }
        if (is_null($valorCSLL) || (is_array($valorCSLL) && empty($valorCSLL))) {
            unset($this->ValorCSLL);
        } else {
            $this->ValorCSLL = $valorCSLL;
        }
        return $this;
    }
    /**
     * Get ValorCofins value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorCofins()
    {
        return isset($this->ValorCofins) ? $this->ValorCofins : null;
    }
    /**
     * Set ValorCofins value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorCofins
     * @return \StructType\NotaFiscalRepasseDTO
     */
    public function setValorCofins($valorCofins = null)
    {
        // validation for constraint: float
        if (!is_null($valorCofins) && !(is_float($valorCofins) || is_numeric($valorCofins))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorCofins, true), gettype($valorCofins)), __LINE__);
        }
        if (is_null($valorCofins) || (is_array($valorCofins) && empty($valorCofins))) {
            unset($this->ValorCofins);
        } else {
            $this->ValorCofins = $valorCofins;
        }
        return $this;
    }
    /**
     * Get ValorINSS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorINSS()
    {
        return isset($this->ValorINSS) ? $this->ValorINSS : null;
    }
    /**
     * Set ValorINSS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorINSS
     * @return \StructType\NotaFiscalRepasseDTO
     */
    public function setValorINSS($valorINSS = null)
    {
        // validation for constraint: float
        if (!is_null($valorINSS) && !(is_float($valorINSS) || is_numeric($valorINSS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorINSS, true), gettype($valorINSS)), __LINE__);
        }
        if (is_null($valorINSS) || (is_array($valorINSS) && empty($valorINSS))) {
            unset($this->ValorINSS);
        } else {
            $this->ValorINSS = $valorINSS;
        }
        return $this;
    }
    /**
     * Get ValorIRRF value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorIRRF()
    {
        return isset($this->ValorIRRF) ? $this->ValorIRRF : null;
    }
    /**
     * Set ValorIRRF value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorIRRF
     * @return \StructType\NotaFiscalRepasseDTO
     */
    public function setValorIRRF($valorIRRF = null)
    {
        // validation for constraint: float
        if (!is_null($valorIRRF) && !(is_float($valorIRRF) || is_numeric($valorIRRF))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorIRRF, true), gettype($valorIRRF)), __LINE__);
        }
        if (is_null($valorIRRF) || (is_array($valorIRRF) && empty($valorIRRF))) {
            unset($this->ValorIRRF);
        } else {
            $this->ValorIRRF = $valorIRRF;
        }
        return $this;
    }
    /**
     * Get ValorNota value
     * @return float|null
     */
    public function getValorNota()
    {
        return $this->ValorNota;
    }
    /**
     * Set ValorNota value
     * @param float $valorNota
     * @return \StructType\NotaFiscalRepasseDTO
     */
    public function setValorNota($valorNota = null)
    {
        // validation for constraint: float
        if (!is_null($valorNota) && !(is_float($valorNota) || is_numeric($valorNota))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorNota, true), gettype($valorNota)), __LINE__);
        }
        $this->ValorNota = $valorNota;
        return $this;
    }
    /**
     * Get ValorPisPasep value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorPisPasep()
    {
        return isset($this->ValorPisPasep) ? $this->ValorPisPasep : null;
    }
    /**
     * Set ValorPisPasep value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorPisPasep
     * @return \StructType\NotaFiscalRepasseDTO
     */
    public function setValorPisPasep($valorPisPasep = null)
    {
        // validation for constraint: float
        if (!is_null($valorPisPasep) && !(is_float($valorPisPasep) || is_numeric($valorPisPasep))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorPisPasep, true), gettype($valorPisPasep)), __LINE__);
        }
        if (is_null($valorPisPasep) || (is_array($valorPisPasep) && empty($valorPisPasep))) {
            unset($this->ValorPisPasep);
        } else {
            $this->ValorPisPasep = $valorPisPasep;
        }
        return $this;
    }
    /**
     * Get ValorRepasse value
     * @return float|null
     */
    public function getValorRepasse()
    {
        return $this->ValorRepasse;
    }
    /**
     * Set ValorRepasse value
     * @param float $valorRepasse
     * @return \StructType\NotaFiscalRepasseDTO
     */
    public function setValorRepasse($valorRepasse = null)
    {
        // validation for constraint: float
        if (!is_null($valorRepasse) && !(is_float($valorRepasse) || is_numeric($valorRepasse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorRepasse, true), gettype($valorRepasse)), __LINE__);
        }
        $this->ValorRepasse = $valorRepasse;
        return $this;
    }
}
