<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotaFiscalDTO StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NotaFiscalDTO
 * @subpackage Structs
 */
class NotaFiscalDTO extends AbstractStructBase
{
    /**
     * The Aliquota
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $Aliquota;
    /**
     * The Atividade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Atividade;
    /**
     * The CEPPrestacaoServico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CEPPrestacaoServico;
    /**
     * The ChaveAutenticacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChaveAutenticacao;
    /**
     * The CidadePrestacaoServico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CidadePrestacaoServico;
    /**
     * The CodObra
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodObra;
    /**
     * The DataRecibo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataRecibo;
    /**
     * The EnderecoPrestacaoServico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnderecoPrestacaoServico;
    /**
     * The EqptoRecibo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EqptoRecibo;
    /**
     * The EstadoPrestacaoServico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EstadoPrestacaoServico;
    /**
     * The Homologacao
     * @var bool
     */
    public $Homologacao;
    /**
     * The InformacoesAdicionais
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InformacoesAdicionais;
    /**
     * The NotaSubstituida
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $NotaSubstituida;
    /**
     * The NotificarTomadorPorEmail
     * @var bool
     */
    public $NotificarTomadorPorEmail;
    /**
     * The NumeroCDC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumeroCDC;
    /**
     * The NumeroCei
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumeroCei;
    /**
     * The NumeroRecibo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $NumeroRecibo;
    /**
     * The SemIncidenciaISS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SemIncidenciaISS;
    /**
     * The SimplesNacional
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SimplesNacional;
    /**
     * The SubstituicaoTributaria
     * @var bool
     */
    public $SubstituicaoTributaria;
    /**
     * The Tomador
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PessoaDTO
     */
    public $Tomador;
    /**
     * The TomadorEstrangeiro
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TomadorEstrangeiro;
    /**
     * The Valor
     * @var float
     */
    public $Valor;
    /**
     * The ValorCSLL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorCSLL;
    /**
     * The ValorCofins
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorCofins;
    /**
     * The ValorDeducao
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $ValorDeducao;
    /**
     * The ValorINSS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorINSS;
    /**
     * The ValorIR
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorIR;
    /**
     * The ValorOutrosImpostos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorOutrosImpostos;
    /**
     * The ValorPisPasep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorPisPasep;
    /**
     * The ValorRepasse
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorRepasse;
    /**
     * The ipUsuarioEmissor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ipUsuarioEmissor;
    /**
     * The nrExercicioReferencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $nrExercicioReferencia;
    /**
     * The nrMesReferencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $nrMesReferencia;
    /**
     * Constructor method for NotaFiscalDTO
     * @uses NotaFiscalDTO::setAliquota()
     * @uses NotaFiscalDTO::setAtividade()
     * @uses NotaFiscalDTO::setCEPPrestacaoServico()
     * @uses NotaFiscalDTO::setChaveAutenticacao()
     * @uses NotaFiscalDTO::setCidadePrestacaoServico()
     * @uses NotaFiscalDTO::setCodObra()
     * @uses NotaFiscalDTO::setDataRecibo()
     * @uses NotaFiscalDTO::setEnderecoPrestacaoServico()
     * @uses NotaFiscalDTO::setEqptoRecibo()
     * @uses NotaFiscalDTO::setEstadoPrestacaoServico()
     * @uses NotaFiscalDTO::setHomologacao()
     * @uses NotaFiscalDTO::setInformacoesAdicionais()
     * @uses NotaFiscalDTO::setNotaSubstituida()
     * @uses NotaFiscalDTO::setNotificarTomadorPorEmail()
     * @uses NotaFiscalDTO::setNumeroCDC()
     * @uses NotaFiscalDTO::setNumeroCei()
     * @uses NotaFiscalDTO::setNumeroRecibo()
     * @uses NotaFiscalDTO::setSemIncidenciaISS()
     * @uses NotaFiscalDTO::setSimplesNacional()
     * @uses NotaFiscalDTO::setSubstituicaoTributaria()
     * @uses NotaFiscalDTO::setTomador()
     * @uses NotaFiscalDTO::setTomadorEstrangeiro()
     * @uses NotaFiscalDTO::setValor()
     * @uses NotaFiscalDTO::setValorCSLL()
     * @uses NotaFiscalDTO::setValorCofins()
     * @uses NotaFiscalDTO::setValorDeducao()
     * @uses NotaFiscalDTO::setValorINSS()
     * @uses NotaFiscalDTO::setValorIR()
     * @uses NotaFiscalDTO::setValorOutrosImpostos()
     * @uses NotaFiscalDTO::setValorPisPasep()
     * @uses NotaFiscalDTO::setValorRepasse()
     * @uses NotaFiscalDTO::setIpUsuarioEmissor()
     * @uses NotaFiscalDTO::setNrExercicioReferencia()
     * @uses NotaFiscalDTO::setNrMesReferencia()
     * @param float $aliquota
     * @param string $atividade
     * @param string $cEPPrestacaoServico
     * @param string $chaveAutenticacao
     * @param string $cidadePrestacaoServico
     * @param string $codObra
     * @param string $dataRecibo
     * @param string $enderecoPrestacaoServico
     * @param string $eqptoRecibo
     * @param string $estadoPrestacaoServico
     * @param bool $homologacao
     * @param string $informacoesAdicionais
     * @param float $notaSubstituida
     * @param bool $notificarTomadorPorEmail
     * @param string $numeroCDC
     * @param string $numeroCei
     * @param float $numeroRecibo
     * @param bool $semIncidenciaISS
     * @param bool $simplesNacional
     * @param bool $substituicaoTributaria
     * @param \StructType\PessoaDTO $tomador
     * @param bool $tomadorEstrangeiro
     * @param float $valor
     * @param float $valorCSLL
     * @param float $valorCofins
     * @param float $valorDeducao
     * @param float $valorINSS
     * @param float $valorIR
     * @param float $valorOutrosImpostos
     * @param float $valorPisPasep
     * @param float $valorRepasse
     * @param string $ipUsuarioEmissor
     * @param int $nrExercicioReferencia
     * @param int $nrMesReferencia
     */
    public function __construct($aliquota = null, $atividade = null, $cEPPrestacaoServico = null, $chaveAutenticacao = null, $cidadePrestacaoServico = null, $codObra = null, $dataRecibo = null, $enderecoPrestacaoServico = null, $eqptoRecibo = null, $estadoPrestacaoServico = null, $homologacao = null, $informacoesAdicionais = null, $notaSubstituida = null, $notificarTomadorPorEmail = null, $numeroCDC = null, $numeroCei = null, $numeroRecibo = null, $semIncidenciaISS = null, $simplesNacional = null, $substituicaoTributaria = null, \StructType\PessoaDTO $tomador = null, $tomadorEstrangeiro = null, $valor = null, $valorCSLL = null, $valorCofins = null, $valorDeducao = null, $valorINSS = null, $valorIR = null, $valorOutrosImpostos = null, $valorPisPasep = null, $valorRepasse = null, $ipUsuarioEmissor = null, $nrExercicioReferencia = null, $nrMesReferencia = null)
    {
        $this
            ->setAliquota($aliquota)
            ->setAtividade($atividade)
            ->setCEPPrestacaoServico($cEPPrestacaoServico)
            ->setChaveAutenticacao($chaveAutenticacao)
            ->setCidadePrestacaoServico($cidadePrestacaoServico)
            ->setCodObra($codObra)
            ->setDataRecibo($dataRecibo)
            ->setEnderecoPrestacaoServico($enderecoPrestacaoServico)
            ->setEqptoRecibo($eqptoRecibo)
            ->setEstadoPrestacaoServico($estadoPrestacaoServico)
            ->setHomologacao($homologacao)
            ->setInformacoesAdicionais($informacoesAdicionais)
            ->setNotaSubstituida($notaSubstituida)
            ->setNotificarTomadorPorEmail($notificarTomadorPorEmail)
            ->setNumeroCDC($numeroCDC)
            ->setNumeroCei($numeroCei)
            ->setNumeroRecibo($numeroRecibo)
            ->setSemIncidenciaISS($semIncidenciaISS)
            ->setSimplesNacional($simplesNacional)
            ->setSubstituicaoTributaria($substituicaoTributaria)
            ->setTomador($tomador)
            ->setTomadorEstrangeiro($tomadorEstrangeiro)
            ->setValor($valor)
            ->setValorCSLL($valorCSLL)
            ->setValorCofins($valorCofins)
            ->setValorDeducao($valorDeducao)
            ->setValorINSS($valorINSS)
            ->setValorIR($valorIR)
            ->setValorOutrosImpostos($valorOutrosImpostos)
            ->setValorPisPasep($valorPisPasep)
            ->setValorRepasse($valorRepasse)
            ->setIpUsuarioEmissor($ipUsuarioEmissor)
            ->setNrExercicioReferencia($nrExercicioReferencia)
            ->setNrMesReferencia($nrMesReferencia);
    }
    /**
     * Get Aliquota value
     * @return float|null
     */
    public function getAliquota()
    {
        return $this->Aliquota;
    }
    /**
     * Set Aliquota value
     * @param float $aliquota
     * @return \StructType\NotaFiscalDTO
     */
    public function setAliquota($aliquota = null)
    {
        // validation for constraint: float
        if (!is_null($aliquota) && !(is_float($aliquota) || is_numeric($aliquota))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aliquota, true), gettype($aliquota)), __LINE__);
        }
        $this->Aliquota = $aliquota;
        return $this;
    }
    /**
     * Get Atividade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAtividade()
    {
        return isset($this->Atividade) ? $this->Atividade : null;
    }
    /**
     * Set Atividade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $atividade
     * @return \StructType\NotaFiscalDTO
     */
    public function setAtividade($atividade = null)
    {
        // validation for constraint: string
        if (!is_null($atividade) && !is_string($atividade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atividade, true), gettype($atividade)), __LINE__);
        }
        if (is_null($atividade) || (is_array($atividade) && empty($atividade))) {
            unset($this->Atividade);
        } else {
            $this->Atividade = $atividade;
        }
        return $this;
    }
    /**
     * Get CEPPrestacaoServico value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCEPPrestacaoServico()
    {
        return isset($this->CEPPrestacaoServico) ? $this->CEPPrestacaoServico : null;
    }
    /**
     * Set CEPPrestacaoServico value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cEPPrestacaoServico
     * @return \StructType\NotaFiscalDTO
     */
    public function setCEPPrestacaoServico($cEPPrestacaoServico = null)
    {
        // validation for constraint: string
        if (!is_null($cEPPrestacaoServico) && !is_string($cEPPrestacaoServico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cEPPrestacaoServico, true), gettype($cEPPrestacaoServico)), __LINE__);
        }
        if (is_null($cEPPrestacaoServico) || (is_array($cEPPrestacaoServico) && empty($cEPPrestacaoServico))) {
            unset($this->CEPPrestacaoServico);
        } else {
            $this->CEPPrestacaoServico = $cEPPrestacaoServico;
        }
        return $this;
    }
    /**
     * Get ChaveAutenticacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChaveAutenticacao()
    {
        return isset($this->ChaveAutenticacao) ? $this->ChaveAutenticacao : null;
    }
    /**
     * Set ChaveAutenticacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chaveAutenticacao
     * @return \StructType\NotaFiscalDTO
     */
    public function setChaveAutenticacao($chaveAutenticacao = null)
    {
        // validation for constraint: string
        if (!is_null($chaveAutenticacao) && !is_string($chaveAutenticacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chaveAutenticacao, true), gettype($chaveAutenticacao)), __LINE__);
        }
        if (is_null($chaveAutenticacao) || (is_array($chaveAutenticacao) && empty($chaveAutenticacao))) {
            unset($this->ChaveAutenticacao);
        } else {
            $this->ChaveAutenticacao = $chaveAutenticacao;
        }
        return $this;
    }
    /**
     * Get CidadePrestacaoServico value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCidadePrestacaoServico()
    {
        return isset($this->CidadePrestacaoServico) ? $this->CidadePrestacaoServico : null;
    }
    /**
     * Set CidadePrestacaoServico value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cidadePrestacaoServico
     * @return \StructType\NotaFiscalDTO
     */
    public function setCidadePrestacaoServico($cidadePrestacaoServico = null)
    {
        // validation for constraint: string
        if (!is_null($cidadePrestacaoServico) && !is_string($cidadePrestacaoServico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cidadePrestacaoServico, true), gettype($cidadePrestacaoServico)), __LINE__);
        }
        if (is_null($cidadePrestacaoServico) || (is_array($cidadePrestacaoServico) && empty($cidadePrestacaoServico))) {
            unset($this->CidadePrestacaoServico);
        } else {
            $this->CidadePrestacaoServico = $cidadePrestacaoServico;
        }
        return $this;
    }
    /**
     * Get CodObra value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodObra()
    {
        return isset($this->CodObra) ? $this->CodObra : null;
    }
    /**
     * Set CodObra value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codObra
     * @return \StructType\NotaFiscalDTO
     */
    public function setCodObra($codObra = null)
    {
        // validation for constraint: string
        if (!is_null($codObra) && !is_string($codObra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codObra, true), gettype($codObra)), __LINE__);
        }
        if (is_null($codObra) || (is_array($codObra) && empty($codObra))) {
            unset($this->CodObra);
        } else {
            $this->CodObra = $codObra;
        }
        return $this;
    }
    /**
     * Get DataRecibo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataRecibo()
    {
        return isset($this->DataRecibo) ? $this->DataRecibo : null;
    }
    /**
     * Set DataRecibo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataRecibo
     * @return \StructType\NotaFiscalDTO
     */
    public function setDataRecibo($dataRecibo = null)
    {
        // validation for constraint: string
        if (!is_null($dataRecibo) && !is_string($dataRecibo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataRecibo, true), gettype($dataRecibo)), __LINE__);
        }
        if (is_null($dataRecibo) || (is_array($dataRecibo) && empty($dataRecibo))) {
            unset($this->DataRecibo);
        } else {
            $this->DataRecibo = $dataRecibo;
        }
        return $this;
    }
    /**
     * Get EnderecoPrestacaoServico value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnderecoPrestacaoServico()
    {
        return isset($this->EnderecoPrestacaoServico) ? $this->EnderecoPrestacaoServico : null;
    }
    /**
     * Set EnderecoPrestacaoServico value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enderecoPrestacaoServico
     * @return \StructType\NotaFiscalDTO
     */
    public function setEnderecoPrestacaoServico($enderecoPrestacaoServico = null)
    {
        // validation for constraint: string
        if (!is_null($enderecoPrestacaoServico) && !is_string($enderecoPrestacaoServico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enderecoPrestacaoServico, true), gettype($enderecoPrestacaoServico)), __LINE__);
        }
        if (is_null($enderecoPrestacaoServico) || (is_array($enderecoPrestacaoServico) && empty($enderecoPrestacaoServico))) {
            unset($this->EnderecoPrestacaoServico);
        } else {
            $this->EnderecoPrestacaoServico = $enderecoPrestacaoServico;
        }
        return $this;
    }
    /**
     * Get EqptoRecibo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEqptoRecibo()
    {
        return isset($this->EqptoRecibo) ? $this->EqptoRecibo : null;
    }
    /**
     * Set EqptoRecibo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eqptoRecibo
     * @return \StructType\NotaFiscalDTO
     */
    public function setEqptoRecibo($eqptoRecibo = null)
    {
        // validation for constraint: string
        if (!is_null($eqptoRecibo) && !is_string($eqptoRecibo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eqptoRecibo, true), gettype($eqptoRecibo)), __LINE__);
        }
        if (is_null($eqptoRecibo) || (is_array($eqptoRecibo) && empty($eqptoRecibo))) {
            unset($this->EqptoRecibo);
        } else {
            $this->EqptoRecibo = $eqptoRecibo;
        }
        return $this;
    }
    /**
     * Get EstadoPrestacaoServico value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstadoPrestacaoServico()
    {
        return isset($this->EstadoPrestacaoServico) ? $this->EstadoPrestacaoServico : null;
    }
    /**
     * Set EstadoPrestacaoServico value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estadoPrestacaoServico
     * @return \StructType\NotaFiscalDTO
     */
    public function setEstadoPrestacaoServico($estadoPrestacaoServico = null)
    {
        // validation for constraint: string
        if (!is_null($estadoPrestacaoServico) && !is_string($estadoPrestacaoServico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoPrestacaoServico, true), gettype($estadoPrestacaoServico)), __LINE__);
        }
        if (is_null($estadoPrestacaoServico) || (is_array($estadoPrestacaoServico) && empty($estadoPrestacaoServico))) {
            unset($this->EstadoPrestacaoServico);
        } else {
            $this->EstadoPrestacaoServico = $estadoPrestacaoServico;
        }
        return $this;
    }
    /**
     * Get Homologacao value
     * @return bool|null
     */
    public function getHomologacao()
    {
        return $this->Homologacao;
    }
    /**
     * Set Homologacao value
     * @param bool $homologacao
     * @return \StructType\NotaFiscalDTO
     */
    public function setHomologacao($homologacao = null)
    {
        // validation for constraint: boolean
        if (!is_null($homologacao) && !is_bool($homologacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($homologacao, true), gettype($homologacao)), __LINE__);
        }
        $this->Homologacao = $homologacao;
        return $this;
    }
    /**
     * Get InformacoesAdicionais value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInformacoesAdicionais()
    {
        return isset($this->InformacoesAdicionais) ? $this->InformacoesAdicionais : null;
    }
    /**
     * Set InformacoesAdicionais value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $informacoesAdicionais
     * @return \StructType\NotaFiscalDTO
     */
    public function setInformacoesAdicionais($informacoesAdicionais = null)
    {
        // validation for constraint: string
        if (!is_null($informacoesAdicionais) && !is_string($informacoesAdicionais)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($informacoesAdicionais, true), gettype($informacoesAdicionais)), __LINE__);
        }
        if (is_null($informacoesAdicionais) || (is_array($informacoesAdicionais) && empty($informacoesAdicionais))) {
            unset($this->InformacoesAdicionais);
        } else {
            $this->InformacoesAdicionais = $informacoesAdicionais;
        }
        return $this;
    }
    /**
     * Get NotaSubstituida value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getNotaSubstituida()
    {
        return isset($this->NotaSubstituida) ? $this->NotaSubstituida : null;
    }
    /**
     * Set NotaSubstituida value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $notaSubstituida
     * @return \StructType\NotaFiscalDTO
     */
    public function setNotaSubstituida($notaSubstituida = null)
    {
        // validation for constraint: float
        if (!is_null($notaSubstituida) && !(is_float($notaSubstituida) || is_numeric($notaSubstituida))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($notaSubstituida, true), gettype($notaSubstituida)), __LINE__);
        }
        if (is_null($notaSubstituida) || (is_array($notaSubstituida) && empty($notaSubstituida))) {
            unset($this->NotaSubstituida);
        } else {
            $this->NotaSubstituida = $notaSubstituida;
        }
        return $this;
    }
    /**
     * Get NotificarTomadorPorEmail value
     * @return bool|null
     */
    public function getNotificarTomadorPorEmail()
    {
        return $this->NotificarTomadorPorEmail;
    }
    /**
     * Set NotificarTomadorPorEmail value
     * @param bool $notificarTomadorPorEmail
     * @return \StructType\NotaFiscalDTO
     */
    public function setNotificarTomadorPorEmail($notificarTomadorPorEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($notificarTomadorPorEmail) && !is_bool($notificarTomadorPorEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notificarTomadorPorEmail, true), gettype($notificarTomadorPorEmail)), __LINE__);
        }
        $this->NotificarTomadorPorEmail = $notificarTomadorPorEmail;
        return $this;
    }
    /**
     * Get NumeroCDC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroCDC()
    {
        return isset($this->NumeroCDC) ? $this->NumeroCDC : null;
    }
    /**
     * Set NumeroCDC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroCDC
     * @return \StructType\NotaFiscalDTO
     */
    public function setNumeroCDC($numeroCDC = null)
    {
        // validation for constraint: string
        if (!is_null($numeroCDC) && !is_string($numeroCDC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroCDC, true), gettype($numeroCDC)), __LINE__);
        }
        if (is_null($numeroCDC) || (is_array($numeroCDC) && empty($numeroCDC))) {
            unset($this->NumeroCDC);
        } else {
            $this->NumeroCDC = $numeroCDC;
        }
        return $this;
    }
    /**
     * Get NumeroCei value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroCei()
    {
        return isset($this->NumeroCei) ? $this->NumeroCei : null;
    }
    /**
     * Set NumeroCei value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroCei
     * @return \StructType\NotaFiscalDTO
     */
    public function setNumeroCei($numeroCei = null)
    {
        // validation for constraint: string
        if (!is_null($numeroCei) && !is_string($numeroCei)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroCei, true), gettype($numeroCei)), __LINE__);
        }
        if (is_null($numeroCei) || (is_array($numeroCei) && empty($numeroCei))) {
            unset($this->NumeroCei);
        } else {
            $this->NumeroCei = $numeroCei;
        }
        return $this;
    }
    /**
     * Get NumeroRecibo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getNumeroRecibo()
    {
        return isset($this->NumeroRecibo) ? $this->NumeroRecibo : null;
    }
    /**
     * Set NumeroRecibo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $numeroRecibo
     * @return \StructType\NotaFiscalDTO
     */
    public function setNumeroRecibo($numeroRecibo = null)
    {
        // validation for constraint: float
        if (!is_null($numeroRecibo) && !(is_float($numeroRecibo) || is_numeric($numeroRecibo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($numeroRecibo, true), gettype($numeroRecibo)), __LINE__);
        }
        if (is_null($numeroRecibo) || (is_array($numeroRecibo) && empty($numeroRecibo))) {
            unset($this->NumeroRecibo);
        } else {
            $this->NumeroRecibo = $numeroRecibo;
        }
        return $this;
    }
    /**
     * Get SemIncidenciaISS value
     * @return bool|null
     */
    public function getSemIncidenciaISS()
    {
        return $this->SemIncidenciaISS;
    }
    /**
     * Set SemIncidenciaISS value
     * @param bool $semIncidenciaISS
     * @return \StructType\NotaFiscalDTO
     */
    public function setSemIncidenciaISS($semIncidenciaISS = null)
    {
        // validation for constraint: boolean
        if (!is_null($semIncidenciaISS) && !is_bool($semIncidenciaISS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($semIncidenciaISS, true), gettype($semIncidenciaISS)), __LINE__);
        }
        $this->SemIncidenciaISS = $semIncidenciaISS;
        return $this;
    }
    /**
     * Get SimplesNacional value
     * @return bool|null
     */
    public function getSimplesNacional()
    {
        return $this->SimplesNacional;
    }
    /**
     * Set SimplesNacional value
     * @param bool $simplesNacional
     * @return \StructType\NotaFiscalDTO
     */
    public function setSimplesNacional($simplesNacional = null)
    {
        // validation for constraint: boolean
        if (!is_null($simplesNacional) && !is_bool($simplesNacional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simplesNacional, true), gettype($simplesNacional)), __LINE__);
        }
        $this->SimplesNacional = $simplesNacional;
        return $this;
    }
    /**
     * Get SubstituicaoTributaria value
     * @return bool|null
     */
    public function getSubstituicaoTributaria()
    {
        return $this->SubstituicaoTributaria;
    }
    /**
     * Set SubstituicaoTributaria value
     * @param bool $substituicaoTributaria
     * @return \StructType\NotaFiscalDTO
     */
    public function setSubstituicaoTributaria($substituicaoTributaria = null)
    {
        // validation for constraint: boolean
        if (!is_null($substituicaoTributaria) && !is_bool($substituicaoTributaria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($substituicaoTributaria, true), gettype($substituicaoTributaria)), __LINE__);
        }
        $this->SubstituicaoTributaria = $substituicaoTributaria;
        return $this;
    }
    /**
     * Get Tomador value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PessoaDTO|null
     */
    public function getTomador()
    {
        return isset($this->Tomador) ? $this->Tomador : null;
    }
    /**
     * Set Tomador value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PessoaDTO $tomador
     * @return \StructType\NotaFiscalDTO
     */
    public function setTomador(\StructType\PessoaDTO $tomador = null)
    {
        if (is_null($tomador) || (is_array($tomador) && empty($tomador))) {
            unset($this->Tomador);
        } else {
            $this->Tomador = $tomador;
        }
        return $this;
    }
    /**
     * Get TomadorEstrangeiro value
     * @return bool|null
     */
    public function getTomadorEstrangeiro()
    {
        return $this->TomadorEstrangeiro;
    }
    /**
     * Set TomadorEstrangeiro value
     * @param bool $tomadorEstrangeiro
     * @return \StructType\NotaFiscalDTO
     */
    public function setTomadorEstrangeiro($tomadorEstrangeiro = null)
    {
        // validation for constraint: boolean
        if (!is_null($tomadorEstrangeiro) && !is_bool($tomadorEstrangeiro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tomadorEstrangeiro, true), gettype($tomadorEstrangeiro)), __LINE__);
        }
        $this->TomadorEstrangeiro = $tomadorEstrangeiro;
        return $this;
    }
    /**
     * Get Valor value
     * @return float|null
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param float $valor
     * @return \StructType\NotaFiscalDTO
     */
    public function setValor($valor = null)
    {
        // validation for constraint: float
        if (!is_null($valor) && !(is_float($valor) || is_numeric($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
    /**
     * Get ValorCSLL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorCSLL()
    {
        return isset($this->ValorCSLL) ? $this->ValorCSLL : null;
    }
    /**
     * Set ValorCSLL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorCSLL
     * @return \StructType\NotaFiscalDTO
     */
    public function setValorCSLL($valorCSLL = null)
    {
        // validation for constraint: float
        if (!is_null($valorCSLL) && !(is_float($valorCSLL) || is_numeric($valorCSLL))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorCSLL, true), gettype($valorCSLL)), __LINE__);
        }
        if (is_null($valorCSLL) || (is_array($valorCSLL) && empty($valorCSLL))) {
            unset($this->ValorCSLL);
        } else {
            $this->ValorCSLL = $valorCSLL;
        }
        return $this;
    }
    /**
     * Get ValorCofins value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorCofins()
    {
        return isset($this->ValorCofins) ? $this->ValorCofins : null;
    }
    /**
     * Set ValorCofins value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorCofins
     * @return \StructType\NotaFiscalDTO
     */
    public function setValorCofins($valorCofins = null)
    {
        // validation for constraint: float
        if (!is_null($valorCofins) && !(is_float($valorCofins) || is_numeric($valorCofins))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorCofins, true), gettype($valorCofins)), __LINE__);
        }
        if (is_null($valorCofins) || (is_array($valorCofins) && empty($valorCofins))) {
            unset($this->ValorCofins);
        } else {
            $this->ValorCofins = $valorCofins;
        }
        return $this;
    }
    /**
     * Get ValorDeducao value
     * @return float|null
     */
    public function getValorDeducao()
    {
        return $this->ValorDeducao;
    }
    /**
     * Set ValorDeducao value
     * @param float $valorDeducao
     * @return \StructType\NotaFiscalDTO
     */
    public function setValorDeducao($valorDeducao = null)
    {
        // validation for constraint: float
        if (!is_null($valorDeducao) && !(is_float($valorDeducao) || is_numeric($valorDeducao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorDeducao, true), gettype($valorDeducao)), __LINE__);
        }
        $this->ValorDeducao = $valorDeducao;
        return $this;
    }
    /**
     * Get ValorINSS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorINSS()
    {
        return isset($this->ValorINSS) ? $this->ValorINSS : null;
    }
    /**
     * Set ValorINSS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorINSS
     * @return \StructType\NotaFiscalDTO
     */
    public function setValorINSS($valorINSS = null)
    {
        // validation for constraint: float
        if (!is_null($valorINSS) && !(is_float($valorINSS) || is_numeric($valorINSS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorINSS, true), gettype($valorINSS)), __LINE__);
        }
        if (is_null($valorINSS) || (is_array($valorINSS) && empty($valorINSS))) {
            unset($this->ValorINSS);
        } else {
            $this->ValorINSS = $valorINSS;
        }
        return $this;
    }
    /**
     * Get ValorIR value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorIR()
    {
        return isset($this->ValorIR) ? $this->ValorIR : null;
    }
    /**
     * Set ValorIR value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorIR
     * @return \StructType\NotaFiscalDTO
     */
    public function setValorIR($valorIR = null)
    {
        // validation for constraint: float
        if (!is_null($valorIR) && !(is_float($valorIR) || is_numeric($valorIR))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorIR, true), gettype($valorIR)), __LINE__);
        }
        if (is_null($valorIR) || (is_array($valorIR) && empty($valorIR))) {
            unset($this->ValorIR);
        } else {
            $this->ValorIR = $valorIR;
        }
        return $this;
    }
    /**
     * Get ValorOutrosImpostos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorOutrosImpostos()
    {
        return isset($this->ValorOutrosImpostos) ? $this->ValorOutrosImpostos : null;
    }
    /**
     * Set ValorOutrosImpostos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorOutrosImpostos
     * @return \StructType\NotaFiscalDTO
     */
    public function setValorOutrosImpostos($valorOutrosImpostos = null)
    {
        // validation for constraint: float
        if (!is_null($valorOutrosImpostos) && !(is_float($valorOutrosImpostos) || is_numeric($valorOutrosImpostos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorOutrosImpostos, true), gettype($valorOutrosImpostos)), __LINE__);
        }
        if (is_null($valorOutrosImpostos) || (is_array($valorOutrosImpostos) && empty($valorOutrosImpostos))) {
            unset($this->ValorOutrosImpostos);
        } else {
            $this->ValorOutrosImpostos = $valorOutrosImpostos;
        }
        return $this;
    }
    /**
     * Get ValorPisPasep value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorPisPasep()
    {
        return isset($this->ValorPisPasep) ? $this->ValorPisPasep : null;
    }
    /**
     * Set ValorPisPasep value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorPisPasep
     * @return \StructType\NotaFiscalDTO
     */
    public function setValorPisPasep($valorPisPasep = null)
    {
        // validation for constraint: float
        if (!is_null($valorPisPasep) && !(is_float($valorPisPasep) || is_numeric($valorPisPasep))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorPisPasep, true), gettype($valorPisPasep)), __LINE__);
        }
        if (is_null($valorPisPasep) || (is_array($valorPisPasep) && empty($valorPisPasep))) {
            unset($this->ValorPisPasep);
        } else {
            $this->ValorPisPasep = $valorPisPasep;
        }
        return $this;
    }
    /**
     * Get ValorRepasse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorRepasse()
    {
        return isset($this->ValorRepasse) ? $this->ValorRepasse : null;
    }
    /**
     * Set ValorRepasse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorRepasse
     * @return \StructType\NotaFiscalDTO
     */
    public function setValorRepasse($valorRepasse = null)
    {
        // validation for constraint: float
        if (!is_null($valorRepasse) && !(is_float($valorRepasse) || is_numeric($valorRepasse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorRepasse, true), gettype($valorRepasse)), __LINE__);
        }
        if (is_null($valorRepasse) || (is_array($valorRepasse) && empty($valorRepasse))) {
            unset($this->ValorRepasse);
        } else {
            $this->ValorRepasse = $valorRepasse;
        }
        return $this;
    }
    /**
     * Get ipUsuarioEmissor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIpUsuarioEmissor()
    {
        return isset($this->ipUsuarioEmissor) ? $this->ipUsuarioEmissor : null;
    }
    /**
     * Set ipUsuarioEmissor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ipUsuarioEmissor
     * @return \StructType\NotaFiscalDTO
     */
    public function setIpUsuarioEmissor($ipUsuarioEmissor = null)
    {
        // validation for constraint: string
        if (!is_null($ipUsuarioEmissor) && !is_string($ipUsuarioEmissor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipUsuarioEmissor, true), gettype($ipUsuarioEmissor)), __LINE__);
        }
        if (is_null($ipUsuarioEmissor) || (is_array($ipUsuarioEmissor) && empty($ipUsuarioEmissor))) {
            unset($this->ipUsuarioEmissor);
        } else {
            $this->ipUsuarioEmissor = $ipUsuarioEmissor;
        }
        return $this;
    }
    /**
     * Get nrExercicioReferencia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNrExercicioReferencia()
    {
        return isset($this->nrExercicioReferencia) ? $this->nrExercicioReferencia : null;
    }
    /**
     * Set nrExercicioReferencia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nrExercicioReferencia
     * @return \StructType\NotaFiscalDTO
     */
    public function setNrExercicioReferencia($nrExercicioReferencia = null)
    {
        // validation for constraint: int
        if (!is_null($nrExercicioReferencia) && !(is_int($nrExercicioReferencia) || ctype_digit($nrExercicioReferencia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nrExercicioReferencia, true), gettype($nrExercicioReferencia)), __LINE__);
        }
        if (is_null($nrExercicioReferencia) || (is_array($nrExercicioReferencia) && empty($nrExercicioReferencia))) {
            unset($this->nrExercicioReferencia);
        } else {
            $this->nrExercicioReferencia = $nrExercicioReferencia;
        }
        return $this;
    }
    /**
     * Get nrMesReferencia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNrMesReferencia()
    {
        return isset($this->nrMesReferencia) ? $this->nrMesReferencia : null;
    }
    /**
     * Set nrMesReferencia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nrMesReferencia
     * @return \StructType\NotaFiscalDTO
     */
    public function setNrMesReferencia($nrMesReferencia = null)
    {
        // validation for constraint: int
        if (!is_null($nrMesReferencia) && !(is_int($nrMesReferencia) || ctype_digit($nrMesReferencia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nrMesReferencia, true), gettype($nrMesReferencia)), __LINE__);
        }
        if (is_null($nrMesReferencia) || (is_array($nrMesReferencia) && empty($nrMesReferencia))) {
            unset($this->nrMesReferencia);
        } else {
            $this->nrMesReferencia = $nrMesReferencia;
        }
        return $this;
    }
}
