<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsultaNotaFiscalResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ConsultaNotaFiscalResponse
 * @subpackage Structs
 */
class ConsultaNotaFiscalResponse extends ResponseBase
{
    /**
     * The DataEnvio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataEnvio;
    /**
     * The DataFinalizacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataFinalizacao;
    /**
     * The NotasGeradas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNotaFiscalConsultaDTO
     */
    public $NotasGeradas;
    /**
     * The QtdeNotas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $QtdeNotas;
    /**
     * Constructor method for ConsultaNotaFiscalResponse
     * @uses ConsultaNotaFiscalResponse::setDataEnvio()
     * @uses ConsultaNotaFiscalResponse::setDataFinalizacao()
     * @uses ConsultaNotaFiscalResponse::setNotasGeradas()
     * @uses ConsultaNotaFiscalResponse::setQtdeNotas()
     * @param string $dataEnvio
     * @param string $dataFinalizacao
     * @param \ArrayType\ArrayOfNotaFiscalConsultaDTO $notasGeradas
     * @param int $qtdeNotas
     */
    public function __construct($dataEnvio = null, $dataFinalizacao = null, \ArrayType\ArrayOfNotaFiscalConsultaDTO $notasGeradas = null, $qtdeNotas = null)
    {
        $this
            ->setDataEnvio($dataEnvio)
            ->setDataFinalizacao($dataFinalizacao)
            ->setNotasGeradas($notasGeradas)
            ->setQtdeNotas($qtdeNotas);
    }
    /**
     * Get DataEnvio value
     * @return string|null
     */
    public function getDataEnvio()
    {
        return $this->DataEnvio;
    }
    /**
     * Set DataEnvio value
     * @param string $dataEnvio
     * @return \StructType\ConsultaNotaFiscalResponse
     */
    public function setDataEnvio($dataEnvio = null)
    {
        // validation for constraint: string
        if (!is_null($dataEnvio) && !is_string($dataEnvio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataEnvio, true), gettype($dataEnvio)), __LINE__);
        }
        $this->DataEnvio = $dataEnvio;
        return $this;
    }
    /**
     * Get DataFinalizacao value
     * @return string|null
     */
    public function getDataFinalizacao()
    {
        return $this->DataFinalizacao;
    }
    /**
     * Set DataFinalizacao value
     * @param string $dataFinalizacao
     * @return \StructType\ConsultaNotaFiscalResponse
     */
    public function setDataFinalizacao($dataFinalizacao = null)
    {
        // validation for constraint: string
        if (!is_null($dataFinalizacao) && !is_string($dataFinalizacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataFinalizacao, true), gettype($dataFinalizacao)), __LINE__);
        }
        $this->DataFinalizacao = $dataFinalizacao;
        return $this;
    }
    /**
     * Get NotasGeradas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNotaFiscalConsultaDTO|null
     */
    public function getNotasGeradas()
    {
        return isset($this->NotasGeradas) ? $this->NotasGeradas : null;
    }
    /**
     * Set NotasGeradas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNotaFiscalConsultaDTO $notasGeradas
     * @return \StructType\ConsultaNotaFiscalResponse
     */
    public function setNotasGeradas(\ArrayType\ArrayOfNotaFiscalConsultaDTO $notasGeradas = null)
    {
        if (is_null($notasGeradas) || (is_array($notasGeradas) && empty($notasGeradas))) {
            unset($this->NotasGeradas);
        } else {
            $this->NotasGeradas = $notasGeradas;
        }
        return $this;
    }
    /**
     * Get QtdeNotas value
     * @return int|null
     */
    public function getQtdeNotas()
    {
        return $this->QtdeNotas;
    }
    /**
     * Set QtdeNotas value
     * @param int $qtdeNotas
     * @return \StructType\ConsultaNotaFiscalResponse
     */
    public function setQtdeNotas($qtdeNotas = null)
    {
        // validation for constraint: int
        if (!is_null($qtdeNotas) && !(is_int($qtdeNotas) || ctype_digit($qtdeNotas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qtdeNotas, true), gettype($qtdeNotas)), __LINE__);
        }
        $this->QtdeNotas = $qtdeNotas;
        return $this;
    }
}
