<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Emitir ServiceType
 * @subpackage Services
 */
class Emitir extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Emitir
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Emitir $parameters
     * @return \StructType\EmitirResponse|bool
     */
    public function Emitir(\StructType\Emitir $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Emitir($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EmitirEmLote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EmitirEmLote $parameters
     * @return \StructType\EmitirEmLoteResponse|bool
     */
    public function EmitirEmLote(\StructType\EmitirEmLote $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EmitirEmLote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EmitirNotaRepasse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EmitirNotaRepasse $parameters
     * @return \StructType\EmitirNotaRepasseResponse|bool
     */
    public function EmitirNotaRepasse(\StructType\EmitirNotaRepasse $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EmitirNotaRepasse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EmitirEmLoteResponse|\StructType\EmitirNotaRepasseResponse|\StructType\EmitirResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
