<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Emitir ServiceType
 */
$emitir = new \ServiceType\Emitir($options);
/**
 * Sample call for Emitir operation/method
 */
if ($emitir->Emitir(new \StructType\Emitir()) !== false) {
    print_r($emitir->getResult());
} else {
    print_r($emitir->getLastError());
}
/**
 * Sample call for EmitirEmLote operation/method
 */
if ($emitir->EmitirEmLote(new \StructType\EmitirEmLote()) !== false) {
    print_r($emitir->getResult());
} else {
    print_r($emitir->getLastError());
}
/**
 * Sample call for EmitirNotaRepasse operation/method
 */
if ($emitir->EmitirNotaRepasse(new \StructType\EmitirNotaRepasse()) !== false) {
    print_r($emitir->getResult());
} else {
    print_r($emitir->getLastError());
}
/**
 * Samples for Cancelar ServiceType
 */
$cancelar = new \ServiceType\Cancelar($options);
/**
 * Sample call for Cancelar operation/method
 */
if ($cancelar->Cancelar(new \StructType\Cancelar()) !== false) {
    print_r($cancelar->getResult());
} else {
    print_r($cancelar->getLastError());
}
/**
 * Samples for Consultar ServiceType
 */
$consultar = new \ServiceType\Consultar($options);
/**
 * Sample call for ConsultarLote operation/method
 */
if ($consultar->ConsultarLote(new \StructType\ConsultarLote()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for Consultar operation/method
 */
if ($consultar->Consultar(new \StructType\Consultar()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
