<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResponseBase
 * @subpackage Structs
 */
class ResponseBase extends AbstractStructBase
{
    /**
     * The Erro
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Erro;
    /**
     * The MensagemErro
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MensagemErro;
    /**
     * Constructor method for ResponseBase
     * @uses ResponseBase::setErro()
     * @uses ResponseBase::setMensagemErro()
     * @param bool $erro
     * @param string $mensagemErro
     */
    public function __construct($erro = null, $mensagemErro = null)
    {
        $this
            ->setErro($erro)
            ->setMensagemErro($mensagemErro);
    }
    /**
     * Get Erro value
     * @return bool|null
     */
    public function getErro()
    {
        return $this->Erro;
    }
    /**
     * Set Erro value
     * @param bool $erro
     * @return \StructType\ResponseBase
     */
    public function setErro($erro = null)
    {
        // validation for constraint: boolean
        if (!is_null($erro) && !is_bool($erro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($erro, true), gettype($erro)), __LINE__);
        }
        $this->Erro = $erro;
        return $this;
    }
    /**
     * Get MensagemErro value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMensagemErro()
    {
        return isset($this->MensagemErro) ? $this->MensagemErro : null;
    }
    /**
     * Set MensagemErro value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mensagemErro
     * @return \StructType\ResponseBase
     */
    public function setMensagemErro($mensagemErro = null)
    {
        // validation for constraint: string
        if (!is_null($mensagemErro) && !is_string($mensagemErro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mensagemErro, true), gettype($mensagemErro)), __LINE__);
        }
        if (is_null($mensagemErro) || (is_array($mensagemErro) && empty($mensagemErro))) {
            unset($this->MensagemErro);
        } else {
            $this->MensagemErro = $mensagemErro;
        }
        return $this;
    }
}
