<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotaFiscalConsultaDTO StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NotaFiscalConsultaDTO
 * @subpackage Structs
 */
class NotaFiscalConsultaDTO extends AbstractStructBase
{
    /**
     * The Aliquota
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Aliquota;
    /**
     * The CodAtividade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodAtividade;
    /**
     * The CodObra
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CodObra;
    /**
     * The CodigoAutenticidade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodigoAutenticidade;
    /**
     * The DataCancelamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataCancelamento;
    /**
     * The DataEmissao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataEmissao;
    /**
     * The DataRecibo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataRecibo;
    /**
     * The DocTomador
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocTomador;
    /**
     * The EnderecoPrestacaoServico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnderecoPrestacaoServico;
    /**
     * The LinkNFE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LinkNFE;
    /**
     * The MotivoCancelamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MotivoCancelamento;
    /**
     * The NomeTomador
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NomeTomador;
    /**
     * The NossoNumero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NossoNumero;
    /**
     * The Numero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Numero;
    /**
     * The NumeroRecibo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $NumeroRecibo;
    /**
     * The SubstituicaoTributaria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SubstituicaoTributaria;
    /**
     * The Valor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Valor;
    /**
     * The ValorIss
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorIss;
    /**
     * The ValorNFE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorNFE;
    /**
     * Constructor method for NotaFiscalConsultaDTO
     * @uses NotaFiscalConsultaDTO::setAliquota()
     * @uses NotaFiscalConsultaDTO::setCodAtividade()
     * @uses NotaFiscalConsultaDTO::setCodObra()
     * @uses NotaFiscalConsultaDTO::setCodigoAutenticidade()
     * @uses NotaFiscalConsultaDTO::setDataCancelamento()
     * @uses NotaFiscalConsultaDTO::setDataEmissao()
     * @uses NotaFiscalConsultaDTO::setDataRecibo()
     * @uses NotaFiscalConsultaDTO::setDocTomador()
     * @uses NotaFiscalConsultaDTO::setEnderecoPrestacaoServico()
     * @uses NotaFiscalConsultaDTO::setLinkNFE()
     * @uses NotaFiscalConsultaDTO::setMotivoCancelamento()
     * @uses NotaFiscalConsultaDTO::setNomeTomador()
     * @uses NotaFiscalConsultaDTO::setNossoNumero()
     * @uses NotaFiscalConsultaDTO::setNumero()
     * @uses NotaFiscalConsultaDTO::setNumeroRecibo()
     * @uses NotaFiscalConsultaDTO::setSubstituicaoTributaria()
     * @uses NotaFiscalConsultaDTO::setValor()
     * @uses NotaFiscalConsultaDTO::setValorIss()
     * @uses NotaFiscalConsultaDTO::setValorNFE()
     * @param float $aliquota
     * @param string $codAtividade
     * @param int $codObra
     * @param string $codigoAutenticidade
     * @param string $dataCancelamento
     * @param string $dataEmissao
     * @param string $dataRecibo
     * @param string $docTomador
     * @param string $enderecoPrestacaoServico
     * @param string $linkNFE
     * @param string $motivoCancelamento
     * @param string $nomeTomador
     * @param string $nossoNumero
     * @param float $numero
     * @param float $numeroRecibo
     * @param bool $substituicaoTributaria
     * @param float $valor
     * @param float $valorIss
     * @param float $valorNFE
     */
    public function __construct($aliquota = null, $codAtividade = null, $codObra = null, $codigoAutenticidade = null, $dataCancelamento = null, $dataEmissao = null, $dataRecibo = null, $docTomador = null, $enderecoPrestacaoServico = null, $linkNFE = null, $motivoCancelamento = null, $nomeTomador = null, $nossoNumero = null, $numero = null, $numeroRecibo = null, $substituicaoTributaria = null, $valor = null, $valorIss = null, $valorNFE = null)
    {
        $this
            ->setAliquota($aliquota)
            ->setCodAtividade($codAtividade)
            ->setCodObra($codObra)
            ->setCodigoAutenticidade($codigoAutenticidade)
            ->setDataCancelamento($dataCancelamento)
            ->setDataEmissao($dataEmissao)
            ->setDataRecibo($dataRecibo)
            ->setDocTomador($docTomador)
            ->setEnderecoPrestacaoServico($enderecoPrestacaoServico)
            ->setLinkNFE($linkNFE)
            ->setMotivoCancelamento($motivoCancelamento)
            ->setNomeTomador($nomeTomador)
            ->setNossoNumero($nossoNumero)
            ->setNumero($numero)
            ->setNumeroRecibo($numeroRecibo)
            ->setSubstituicaoTributaria($substituicaoTributaria)
            ->setValor($valor)
            ->setValorIss($valorIss)
            ->setValorNFE($valorNFE);
    }
    /**
     * Get Aliquota value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAliquota()
    {
        return isset($this->Aliquota) ? $this->Aliquota : null;
    }
    /**
     * Set Aliquota value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aliquota
     * @return \StructType\NotaFiscalConsultaDTO
     */
    public function setAliquota($aliquota = null)
    {
        // validation for constraint: float
        if (!is_null($aliquota) && !(is_float($aliquota) || is_numeric($aliquota))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aliquota, true), gettype($aliquota)), __LINE__);
        }
        if (is_null($aliquota) || (is_array($aliquota) && empty($aliquota))) {
            unset($this->Aliquota);
        } else {
            $this->Aliquota = $aliquota;
        }
        return $this;
    }
    /**
     * Get CodAtividade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodAtividade()
    {
        return isset($this->CodAtividade) ? $this->CodAtividade : null;
    }
    /**
     * Set CodAtividade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codAtividade
     * @return \StructType\NotaFiscalConsultaDTO
     */
    public function setCodAtividade($codAtividade = null)
    {
        // validation for constraint: string
        if (!is_null($codAtividade) && !is_string($codAtividade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codAtividade, true), gettype($codAtividade)), __LINE__);
        }
        if (is_null($codAtividade) || (is_array($codAtividade) && empty($codAtividade))) {
            unset($this->CodAtividade);
        } else {
            $this->CodAtividade = $codAtividade;
        }
        return $this;
    }
    /**
     * Get CodObra value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCodObra()
    {
        return isset($this->CodObra) ? $this->CodObra : null;
    }
    /**
     * Set CodObra value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $codObra
     * @return \StructType\NotaFiscalConsultaDTO
     */
    public function setCodObra($codObra = null)
    {
        // validation for constraint: int
        if (!is_null($codObra) && !(is_int($codObra) || ctype_digit($codObra))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codObra, true), gettype($codObra)), __LINE__);
        }
        if (is_null($codObra) || (is_array($codObra) && empty($codObra))) {
            unset($this->CodObra);
        } else {
            $this->CodObra = $codObra;
        }
        return $this;
    }
    /**
     * Get CodigoAutenticidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodigoAutenticidade()
    {
        return isset($this->CodigoAutenticidade) ? $this->CodigoAutenticidade : null;
    }
    /**
     * Set CodigoAutenticidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codigoAutenticidade
     * @return \StructType\NotaFiscalConsultaDTO
     */
    public function setCodigoAutenticidade($codigoAutenticidade = null)
    {
        // validation for constraint: string
        if (!is_null($codigoAutenticidade) && !is_string($codigoAutenticidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoAutenticidade, true), gettype($codigoAutenticidade)), __LINE__);
        }
        if (is_null($codigoAutenticidade) || (is_array($codigoAutenticidade) && empty($codigoAutenticidade))) {
            unset($this->CodigoAutenticidade);
        } else {
            $this->CodigoAutenticidade = $codigoAutenticidade;
        }
        return $this;
    }
    /**
     * Get DataCancelamento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataCancelamento()
    {
        return isset($this->DataCancelamento) ? $this->DataCancelamento : null;
    }
    /**
     * Set DataCancelamento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataCancelamento
     * @return \StructType\NotaFiscalConsultaDTO
     */
    public function setDataCancelamento($dataCancelamento = null)
    {
        // validation for constraint: string
        if (!is_null($dataCancelamento) && !is_string($dataCancelamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataCancelamento, true), gettype($dataCancelamento)), __LINE__);
        }
        if (is_null($dataCancelamento) || (is_array($dataCancelamento) && empty($dataCancelamento))) {
            unset($this->DataCancelamento);
        } else {
            $this->DataCancelamento = $dataCancelamento;
        }
        return $this;
    }
    /**
     * Get DataEmissao value
     * @return string|null
     */
    public function getDataEmissao()
    {
        return $this->DataEmissao;
    }
    /**
     * Set DataEmissao value
     * @param string $dataEmissao
     * @return \StructType\NotaFiscalConsultaDTO
     */
    public function setDataEmissao($dataEmissao = null)
    {
        // validation for constraint: string
        if (!is_null($dataEmissao) && !is_string($dataEmissao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataEmissao, true), gettype($dataEmissao)), __LINE__);
        }
        $this->DataEmissao = $dataEmissao;
        return $this;
    }
    /**
     * Get DataRecibo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataRecibo()
    {
        return isset($this->DataRecibo) ? $this->DataRecibo : null;
    }
    /**
     * Set DataRecibo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataRecibo
     * @return \StructType\NotaFiscalConsultaDTO
     */
    public function setDataRecibo($dataRecibo = null)
    {
        // validation for constraint: string
        if (!is_null($dataRecibo) && !is_string($dataRecibo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataRecibo, true), gettype($dataRecibo)), __LINE__);
        }
        if (is_null($dataRecibo) || (is_array($dataRecibo) && empty($dataRecibo))) {
            unset($this->DataRecibo);
        } else {
            $this->DataRecibo = $dataRecibo;
        }
        return $this;
    }
    /**
     * Get DocTomador value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocTomador()
    {
        return isset($this->DocTomador) ? $this->DocTomador : null;
    }
    /**
     * Set DocTomador value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $docTomador
     * @return \StructType\NotaFiscalConsultaDTO
     */
    public function setDocTomador($docTomador = null)
    {
        // validation for constraint: string
        if (!is_null($docTomador) && !is_string($docTomador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docTomador, true), gettype($docTomador)), __LINE__);
        }
        if (is_null($docTomador) || (is_array($docTomador) && empty($docTomador))) {
            unset($this->DocTomador);
        } else {
            $this->DocTomador = $docTomador;
        }
        return $this;
    }
    /**
     * Get EnderecoPrestacaoServico value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnderecoPrestacaoServico()
    {
        return isset($this->EnderecoPrestacaoServico) ? $this->EnderecoPrestacaoServico : null;
    }
    /**
     * Set EnderecoPrestacaoServico value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enderecoPrestacaoServico
     * @return \StructType\NotaFiscalConsultaDTO
     */
    public function setEnderecoPrestacaoServico($enderecoPrestacaoServico = null)
    {
        // validation for constraint: string
        if (!is_null($enderecoPrestacaoServico) && !is_string($enderecoPrestacaoServico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enderecoPrestacaoServico, true), gettype($enderecoPrestacaoServico)), __LINE__);
        }
        if (is_null($enderecoPrestacaoServico) || (is_array($enderecoPrestacaoServico) && empty($enderecoPrestacaoServico))) {
            unset($this->EnderecoPrestacaoServico);
        } else {
            $this->EnderecoPrestacaoServico = $enderecoPrestacaoServico;
        }
        return $this;
    }
    /**
     * Get LinkNFE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinkNFE()
    {
        return isset($this->LinkNFE) ? $this->LinkNFE : null;
    }
    /**
     * Set LinkNFE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linkNFE
     * @return \StructType\NotaFiscalConsultaDTO
     */
    public function setLinkNFE($linkNFE = null)
    {
        // validation for constraint: string
        if (!is_null($linkNFE) && !is_string($linkNFE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkNFE, true), gettype($linkNFE)), __LINE__);
        }
        if (is_null($linkNFE) || (is_array($linkNFE) && empty($linkNFE))) {
            unset($this->LinkNFE);
        } else {
            $this->LinkNFE = $linkNFE;
        }
        return $this;
    }
    /**
     * Get MotivoCancelamento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMotivoCancelamento()
    {
        return isset($this->MotivoCancelamento) ? $this->MotivoCancelamento : null;
    }
    /**
     * Set MotivoCancelamento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $motivoCancelamento
     * @return \StructType\NotaFiscalConsultaDTO
     */
    public function setMotivoCancelamento($motivoCancelamento = null)
    {
        // validation for constraint: string
        if (!is_null($motivoCancelamento) && !is_string($motivoCancelamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motivoCancelamento, true), gettype($motivoCancelamento)), __LINE__);
        }
        if (is_null($motivoCancelamento) || (is_array($motivoCancelamento) && empty($motivoCancelamento))) {
            unset($this->MotivoCancelamento);
        } else {
            $this->MotivoCancelamento = $motivoCancelamento;
        }
        return $this;
    }
    /**
     * Get NomeTomador value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNomeTomador()
    {
        return isset($this->NomeTomador) ? $this->NomeTomador : null;
    }
    /**
     * Set NomeTomador value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nomeTomador
     * @return \StructType\NotaFiscalConsultaDTO
     */
    public function setNomeTomador($nomeTomador = null)
    {
        // validation for constraint: string
        if (!is_null($nomeTomador) && !is_string($nomeTomador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeTomador, true), gettype($nomeTomador)), __LINE__);
        }
        if (is_null($nomeTomador) || (is_array($nomeTomador) && empty($nomeTomador))) {
            unset($this->NomeTomador);
        } else {
            $this->NomeTomador = $nomeTomador;
        }
        return $this;
    }
    /**
     * Get NossoNumero value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNossoNumero()
    {
        return isset($this->NossoNumero) ? $this->NossoNumero : null;
    }
    /**
     * Set NossoNumero value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nossoNumero
     * @return \StructType\NotaFiscalConsultaDTO
     */
    public function setNossoNumero($nossoNumero = null)
    {
        // validation for constraint: string
        if (!is_null($nossoNumero) && !is_string($nossoNumero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nossoNumero, true), gettype($nossoNumero)), __LINE__);
        }
        if (is_null($nossoNumero) || (is_array($nossoNumero) && empty($nossoNumero))) {
            unset($this->NossoNumero);
        } else {
            $this->NossoNumero = $nossoNumero;
        }
        return $this;
    }
    /**
     * Get Numero value
     * @return float|null
     */
    public function getNumero()
    {
        return $this->Numero;
    }
    /**
     * Set Numero value
     * @param float $numero
     * @return \StructType\NotaFiscalConsultaDTO
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: float
        if (!is_null($numero) && !(is_float($numero) || is_numeric($numero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        $this->Numero = $numero;
        return $this;
    }
    /**
     * Get NumeroRecibo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getNumeroRecibo()
    {
        return isset($this->NumeroRecibo) ? $this->NumeroRecibo : null;
    }
    /**
     * Set NumeroRecibo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $numeroRecibo
     * @return \StructType\NotaFiscalConsultaDTO
     */
    public function setNumeroRecibo($numeroRecibo = null)
    {
        // validation for constraint: float
        if (!is_null($numeroRecibo) && !(is_float($numeroRecibo) || is_numeric($numeroRecibo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($numeroRecibo, true), gettype($numeroRecibo)), __LINE__);
        }
        if (is_null($numeroRecibo) || (is_array($numeroRecibo) && empty($numeroRecibo))) {
            unset($this->NumeroRecibo);
        } else {
            $this->NumeroRecibo = $numeroRecibo;
        }
        return $this;
    }
    /**
     * Get SubstituicaoTributaria value
     * @return bool|null
     */
    public function getSubstituicaoTributaria()
    {
        return $this->SubstituicaoTributaria;
    }
    /**
     * Set SubstituicaoTributaria value
     * @param bool $substituicaoTributaria
     * @return \StructType\NotaFiscalConsultaDTO
     */
    public function setSubstituicaoTributaria($substituicaoTributaria = null)
    {
        // validation for constraint: boolean
        if (!is_null($substituicaoTributaria) && !is_bool($substituicaoTributaria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($substituicaoTributaria, true), gettype($substituicaoTributaria)), __LINE__);
        }
        $this->SubstituicaoTributaria = $substituicaoTributaria;
        return $this;
    }
    /**
     * Get Valor value
     * @return float|null
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param float $valor
     * @return \StructType\NotaFiscalConsultaDTO
     */
    public function setValor($valor = null)
    {
        // validation for constraint: float
        if (!is_null($valor) && !(is_float($valor) || is_numeric($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
    /**
     * Get ValorIss value
     * @return float|null
     */
    public function getValorIss()
    {
        return $this->ValorIss;
    }
    /**
     * Set ValorIss value
     * @param float $valorIss
     * @return \StructType\NotaFiscalConsultaDTO
     */
    public function setValorIss($valorIss = null)
    {
        // validation for constraint: float
        if (!is_null($valorIss) && !(is_float($valorIss) || is_numeric($valorIss))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorIss, true), gettype($valorIss)), __LINE__);
        }
        $this->ValorIss = $valorIss;
        return $this;
    }
    /**
     * Get ValorNFE value
     * @return float|null
     */
    public function getValorNFE()
    {
        return $this->ValorNFE;
    }
    /**
     * Set ValorNFE value
     * @param float $valorNFE
     * @return \StructType\NotaFiscalConsultaDTO
     */
    public function setValorNFE($valorNFE = null)
    {
        // validation for constraint: float
        if (!is_null($valorNFE) && !(is_float($valorNFE) || is_numeric($valorNFE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorNFE, true), gettype($valorNFE)), __LINE__);
        }
        $this->ValorNFE = $valorNFE;
        return $this;
    }
}
