<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsultaNotaFiscalLoteResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ConsultaNotaFiscalLoteResponse
 * @subpackage Structs
 */
class ConsultaNotaFiscalLoteResponse extends ResponseBase
{
    /**
     * The CodigoLote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CodigoLote;
    /**
     * The ContadorNotasErro
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ContadorNotasErro;
    /**
     * The ContadorNotasGeradas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ContadorNotasGeradas;
    /**
     * The DataEnvio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataEnvio;
    /**
     * The DataFinalizacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataFinalizacao;
    /**
     * The DataInicioProcessamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataInicioProcessamento;
    /**
     * The NotasGeradas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNotaFiscalLoteGeradaDTO
     */
    public $NotasGeradas;
    /**
     * Constructor method for ConsultaNotaFiscalLoteResponse
     * @uses ConsultaNotaFiscalLoteResponse::setCodigoLote()
     * @uses ConsultaNotaFiscalLoteResponse::setContadorNotasErro()
     * @uses ConsultaNotaFiscalLoteResponse::setContadorNotasGeradas()
     * @uses ConsultaNotaFiscalLoteResponse::setDataEnvio()
     * @uses ConsultaNotaFiscalLoteResponse::setDataFinalizacao()
     * @uses ConsultaNotaFiscalLoteResponse::setDataInicioProcessamento()
     * @uses ConsultaNotaFiscalLoteResponse::setNotasGeradas()
     * @param int $codigoLote
     * @param int $contadorNotasErro
     * @param int $contadorNotasGeradas
     * @param string $dataEnvio
     * @param string $dataFinalizacao
     * @param string $dataInicioProcessamento
     * @param \ArrayType\ArrayOfNotaFiscalLoteGeradaDTO $notasGeradas
     */
    public function __construct($codigoLote = null, $contadorNotasErro = null, $contadorNotasGeradas = null, $dataEnvio = null, $dataFinalizacao = null, $dataInicioProcessamento = null, \ArrayType\ArrayOfNotaFiscalLoteGeradaDTO $notasGeradas = null)
    {
        $this
            ->setCodigoLote($codigoLote)
            ->setContadorNotasErro($contadorNotasErro)
            ->setContadorNotasGeradas($contadorNotasGeradas)
            ->setDataEnvio($dataEnvio)
            ->setDataFinalizacao($dataFinalizacao)
            ->setDataInicioProcessamento($dataInicioProcessamento)
            ->setNotasGeradas($notasGeradas);
    }
    /**
     * Get CodigoLote value
     * @return int|null
     */
    public function getCodigoLote()
    {
        return $this->CodigoLote;
    }
    /**
     * Set CodigoLote value
     * @param int $codigoLote
     * @return \StructType\ConsultaNotaFiscalLoteResponse
     */
    public function setCodigoLote($codigoLote = null)
    {
        // validation for constraint: int
        if (!is_null($codigoLote) && !(is_int($codigoLote) || ctype_digit($codigoLote))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoLote, true), gettype($codigoLote)), __LINE__);
        }
        $this->CodigoLote = $codigoLote;
        return $this;
    }
    /**
     * Get ContadorNotasErro value
     * @return int|null
     */
    public function getContadorNotasErro()
    {
        return $this->ContadorNotasErro;
    }
    /**
     * Set ContadorNotasErro value
     * @param int $contadorNotasErro
     * @return \StructType\ConsultaNotaFiscalLoteResponse
     */
    public function setContadorNotasErro($contadorNotasErro = null)
    {
        // validation for constraint: int
        if (!is_null($contadorNotasErro) && !(is_int($contadorNotasErro) || ctype_digit($contadorNotasErro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contadorNotasErro, true), gettype($contadorNotasErro)), __LINE__);
        }
        $this->ContadorNotasErro = $contadorNotasErro;
        return $this;
    }
    /**
     * Get ContadorNotasGeradas value
     * @return int|null
     */
    public function getContadorNotasGeradas()
    {
        return $this->ContadorNotasGeradas;
    }
    /**
     * Set ContadorNotasGeradas value
     * @param int $contadorNotasGeradas
     * @return \StructType\ConsultaNotaFiscalLoteResponse
     */
    public function setContadorNotasGeradas($contadorNotasGeradas = null)
    {
        // validation for constraint: int
        if (!is_null($contadorNotasGeradas) && !(is_int($contadorNotasGeradas) || ctype_digit($contadorNotasGeradas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contadorNotasGeradas, true), gettype($contadorNotasGeradas)), __LINE__);
        }
        $this->ContadorNotasGeradas = $contadorNotasGeradas;
        return $this;
    }
    /**
     * Get DataEnvio value
     * @return string|null
     */
    public function getDataEnvio()
    {
        return $this->DataEnvio;
    }
    /**
     * Set DataEnvio value
     * @param string $dataEnvio
     * @return \StructType\ConsultaNotaFiscalLoteResponse
     */
    public function setDataEnvio($dataEnvio = null)
    {
        // validation for constraint: string
        if (!is_null($dataEnvio) && !is_string($dataEnvio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataEnvio, true), gettype($dataEnvio)), __LINE__);
        }
        $this->DataEnvio = $dataEnvio;
        return $this;
    }
    /**
     * Get DataFinalizacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataFinalizacao()
    {
        return isset($this->DataFinalizacao) ? $this->DataFinalizacao : null;
    }
    /**
     * Set DataFinalizacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataFinalizacao
     * @return \StructType\ConsultaNotaFiscalLoteResponse
     */
    public function setDataFinalizacao($dataFinalizacao = null)
    {
        // validation for constraint: string
        if (!is_null($dataFinalizacao) && !is_string($dataFinalizacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataFinalizacao, true), gettype($dataFinalizacao)), __LINE__);
        }
        if (is_null($dataFinalizacao) || (is_array($dataFinalizacao) && empty($dataFinalizacao))) {
            unset($this->DataFinalizacao);
        } else {
            $this->DataFinalizacao = $dataFinalizacao;
        }
        return $this;
    }
    /**
     * Get DataInicioProcessamento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataInicioProcessamento()
    {
        return isset($this->DataInicioProcessamento) ? $this->DataInicioProcessamento : null;
    }
    /**
     * Set DataInicioProcessamento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataInicioProcessamento
     * @return \StructType\ConsultaNotaFiscalLoteResponse
     */
    public function setDataInicioProcessamento($dataInicioProcessamento = null)
    {
        // validation for constraint: string
        if (!is_null($dataInicioProcessamento) && !is_string($dataInicioProcessamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataInicioProcessamento, true), gettype($dataInicioProcessamento)), __LINE__);
        }
        if (is_null($dataInicioProcessamento) || (is_array($dataInicioProcessamento) && empty($dataInicioProcessamento))) {
            unset($this->DataInicioProcessamento);
        } else {
            $this->DataInicioProcessamento = $dataInicioProcessamento;
        }
        return $this;
    }
    /**
     * Get NotasGeradas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNotaFiscalLoteGeradaDTO|null
     */
    public function getNotasGeradas()
    {
        return isset($this->NotasGeradas) ? $this->NotasGeradas : null;
    }
    /**
     * Set NotasGeradas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNotaFiscalLoteGeradaDTO $notasGeradas
     * @return \StructType\ConsultaNotaFiscalLoteResponse
     */
    public function setNotasGeradas(\ArrayType\ArrayOfNotaFiscalLoteGeradaDTO $notasGeradas = null)
    {
        if (is_null($notasGeradas) || (is_array($notasGeradas) && empty($notasGeradas))) {
            unset($this->NotasGeradas);
        } else {
            $this->NotasGeradas = $notasGeradas;
        }
        return $this;
    }
}
