<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsultaNotaFiscalLoteRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ConsultaNotaFiscalLoteRequest
 * @subpackage Structs
 */
class ConsultaNotaFiscalLoteRequest extends RequestBase
{
    /**
     * The ChaveAutenticacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChaveAutenticacao;
    /**
     * The CodigoLote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CodigoLote;
    /**
     * The StatusNotas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusNotas;
    /**
     * Constructor method for ConsultaNotaFiscalLoteRequest
     * @uses ConsultaNotaFiscalLoteRequest::setChaveAutenticacao()
     * @uses ConsultaNotaFiscalLoteRequest::setCodigoLote()
     * @uses ConsultaNotaFiscalLoteRequest::setStatusNotas()
     * @param string $chaveAutenticacao
     * @param int $codigoLote
     * @param string $statusNotas
     */
    public function __construct($chaveAutenticacao = null, $codigoLote = null, $statusNotas = null)
    {
        $this
            ->setChaveAutenticacao($chaveAutenticacao)
            ->setCodigoLote($codigoLote)
            ->setStatusNotas($statusNotas);
    }
    /**
     * Get ChaveAutenticacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChaveAutenticacao()
    {
        return isset($this->ChaveAutenticacao) ? $this->ChaveAutenticacao : null;
    }
    /**
     * Set ChaveAutenticacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chaveAutenticacao
     * @return \StructType\ConsultaNotaFiscalLoteRequest
     */
    public function setChaveAutenticacao($chaveAutenticacao = null)
    {
        // validation for constraint: string
        if (!is_null($chaveAutenticacao) && !is_string($chaveAutenticacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chaveAutenticacao, true), gettype($chaveAutenticacao)), __LINE__);
        }
        if (is_null($chaveAutenticacao) || (is_array($chaveAutenticacao) && empty($chaveAutenticacao))) {
            unset($this->ChaveAutenticacao);
        } else {
            $this->ChaveAutenticacao = $chaveAutenticacao;
        }
        return $this;
    }
    /**
     * Get CodigoLote value
     * @return int|null
     */
    public function getCodigoLote()
    {
        return $this->CodigoLote;
    }
    /**
     * Set CodigoLote value
     * @param int $codigoLote
     * @return \StructType\ConsultaNotaFiscalLoteRequest
     */
    public function setCodigoLote($codigoLote = null)
    {
        // validation for constraint: int
        if (!is_null($codigoLote) && !(is_int($codigoLote) || ctype_digit($codigoLote))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoLote, true), gettype($codigoLote)), __LINE__);
        }
        $this->CodigoLote = $codigoLote;
        return $this;
    }
    /**
     * Get StatusNotas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusNotas()
    {
        return isset($this->StatusNotas) ? $this->StatusNotas : null;
    }
    /**
     * Set StatusNotas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusNotas
     * @return \StructType\ConsultaNotaFiscalLoteRequest
     */
    public function setStatusNotas($statusNotas = null)
    {
        // validation for constraint: string
        if (!is_null($statusNotas) && !is_string($statusNotas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusNotas, true), gettype($statusNotas)), __LINE__);
        }
        if (is_null($statusNotas) || (is_array($statusNotas) && empty($statusNotas))) {
            unset($this->StatusNotas);
        } else {
            $this->StatusNotas = $statusNotas;
        }
        return $this;
    }
}
