<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelamentoNotaFiscalRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CancelamentoNotaFiscalRequest
 * @subpackage Structs
 */
class CancelamentoNotaFiscalRequest extends RequestBase
{
    /**
     * The ChaveAutenticacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChaveAutenticacao;
    /**
     * The Homologacao
     * @var bool
     */
    public $Homologacao;
    /**
     * The NumeroNota
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumeroNota;
    /**
     * Constructor method for CancelamentoNotaFiscalRequest
     * @uses CancelamentoNotaFiscalRequest::setChaveAutenticacao()
     * @uses CancelamentoNotaFiscalRequest::setHomologacao()
     * @uses CancelamentoNotaFiscalRequest::setNumeroNota()
     * @param string $chaveAutenticacao
     * @param bool $homologacao
     * @param string $numeroNota
     */
    public function __construct($chaveAutenticacao = null, $homologacao = null, $numeroNota = null)
    {
        $this
            ->setChaveAutenticacao($chaveAutenticacao)
            ->setHomologacao($homologacao)
            ->setNumeroNota($numeroNota);
    }
    /**
     * Get ChaveAutenticacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChaveAutenticacao()
    {
        return isset($this->ChaveAutenticacao) ? $this->ChaveAutenticacao : null;
    }
    /**
     * Set ChaveAutenticacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chaveAutenticacao
     * @return \StructType\CancelamentoNotaFiscalRequest
     */
    public function setChaveAutenticacao($chaveAutenticacao = null)
    {
        // validation for constraint: string
        if (!is_null($chaveAutenticacao) && !is_string($chaveAutenticacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chaveAutenticacao, true), gettype($chaveAutenticacao)), __LINE__);
        }
        if (is_null($chaveAutenticacao) || (is_array($chaveAutenticacao) && empty($chaveAutenticacao))) {
            unset($this->ChaveAutenticacao);
        } else {
            $this->ChaveAutenticacao = $chaveAutenticacao;
        }
        return $this;
    }
    /**
     * Get Homologacao value
     * @return bool|null
     */
    public function getHomologacao()
    {
        return $this->Homologacao;
    }
    /**
     * Set Homologacao value
     * @param bool $homologacao
     * @return \StructType\CancelamentoNotaFiscalRequest
     */
    public function setHomologacao($homologacao = null)
    {
        // validation for constraint: boolean
        if (!is_null($homologacao) && !is_bool($homologacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($homologacao, true), gettype($homologacao)), __LINE__);
        }
        $this->Homologacao = $homologacao;
        return $this;
    }
    /**
     * Get NumeroNota value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroNota()
    {
        return isset($this->NumeroNota) ? $this->NumeroNota : null;
    }
    /**
     * Set NumeroNota value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroNota
     * @return \StructType\CancelamentoNotaFiscalRequest
     */
    public function setNumeroNota($numeroNota = null)
    {
        // validation for constraint: string
        if (!is_null($numeroNota) && !is_string($numeroNota)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroNota, true), gettype($numeroNota)), __LINE__);
        }
        if (is_null($numeroNota) || (is_array($numeroNota) && empty($numeroNota))) {
            unset($this->NumeroNota);
        } else {
            $this->NumeroNota = $numeroNota;
        }
        return $this;
    }
}
