<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consultar ServiceType
 * @subpackage Services
 */
class Consultar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConsultarLote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarLote $parameters
     * @return \StructType\ConsultarLoteResponse|bool
     */
    public function ConsultarLote(\StructType\ConsultarLote $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarLote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Consultar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Consultar $parameters
     * @return \StructType\ConsultarResponse|bool
     */
    public function Consultar(\StructType\Consultar $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Consultar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ConsultarLoteResponse|\StructType\ConsultarResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
