<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for notifications StructType
 * @subpackage Structs
 */
class Notifications extends AbstractStructBase
{
    /**
     * The OrganizationId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $OrganizationId;
    /**
     * The ActionId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $ActionId;
    /**
     * The SessionId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SessionId;
    /**
     * The EnterpriseUrl
     * @var string
     */
    public $EnterpriseUrl;
    /**
     * The PartnerUrl
     * @var string
     */
    public $PartnerUrl;
    /**
     * The Notification
     * Meta information extracted from the WSDL
     * - maxOccurs: 100
     * @var \StructType\CaseNotification[]
     */
    public $Notification;
    /**
     * Constructor method for notifications
     * @uses Notifications::setOrganizationId()
     * @uses Notifications::setActionId()
     * @uses Notifications::setSessionId()
     * @uses Notifications::setEnterpriseUrl()
     * @uses Notifications::setPartnerUrl()
     * @uses Notifications::setNotification()
     * @param string $organizationId
     * @param string $actionId
     * @param string $sessionId
     * @param string $enterpriseUrl
     * @param string $partnerUrl
     * @param \StructType\CaseNotification[] $notification
     */
    public function __construct($organizationId = null, $actionId = null, $sessionId = null, $enterpriseUrl = null, $partnerUrl = null, array $notification = array())
    {
        $this
            ->setOrganizationId($organizationId)
            ->setActionId($actionId)
            ->setSessionId($sessionId)
            ->setEnterpriseUrl($enterpriseUrl)
            ->setPartnerUrl($partnerUrl)
            ->setNotification($notification);
    }
    /**
     * Get OrganizationId value
     * @return string|null
     */
    public function getOrganizationId()
    {
        return $this->OrganizationId;
    }
    /**
     * Set OrganizationId value
     * @param string $organizationId
     * @return \StructType\Notifications
     */
    public function setOrganizationId($organizationId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationId) && !is_string($organizationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationId, true), gettype($organizationId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($organizationId) && mb_strlen($organizationId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($organizationId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($organizationId) && !preg_match('/[a-zA-Z0-9]{18}/', $organizationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($organizationId, true)), __LINE__);
        }
        $this->OrganizationId = $organizationId;
        return $this;
    }
    /**
     * Get ActionId value
     * @return string|null
     */
    public function getActionId()
    {
        return $this->ActionId;
    }
    /**
     * Set ActionId value
     * @param string $actionId
     * @return \StructType\Notifications
     */
    public function setActionId($actionId = null)
    {
        // validation for constraint: string
        if (!is_null($actionId) && !is_string($actionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionId, true), gettype($actionId)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($actionId) && mb_strlen($actionId) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($actionId)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($actionId) && !preg_match('/[a-zA-Z0-9]{18}/', $actionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($actionId, true)), __LINE__);
        }
        $this->ActionId = $actionId;
        return $this;
    }
    /**
     * Get SessionId value
     * @return string|null
     */
    public function getSessionId()
    {
        return $this->SessionId;
    }
    /**
     * Set SessionId value
     * @param string $sessionId
     * @return \StructType\Notifications
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionId, true), gettype($sessionId)), __LINE__);
        }
        $this->SessionId = $sessionId;
        return $this;
    }
    /**
     * Get EnterpriseUrl value
     * @return string|null
     */
    public function getEnterpriseUrl()
    {
        return $this->EnterpriseUrl;
    }
    /**
     * Set EnterpriseUrl value
     * @param string $enterpriseUrl
     * @return \StructType\Notifications
     */
    public function setEnterpriseUrl($enterpriseUrl = null)
    {
        // validation for constraint: string
        if (!is_null($enterpriseUrl) && !is_string($enterpriseUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enterpriseUrl, true), gettype($enterpriseUrl)), __LINE__);
        }
        $this->EnterpriseUrl = $enterpriseUrl;
        return $this;
    }
    /**
     * Get PartnerUrl value
     * @return string|null
     */
    public function getPartnerUrl()
    {
        return $this->PartnerUrl;
    }
    /**
     * Set PartnerUrl value
     * @param string $partnerUrl
     * @return \StructType\Notifications
     */
    public function setPartnerUrl($partnerUrl = null)
    {
        // validation for constraint: string
        if (!is_null($partnerUrl) && !is_string($partnerUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partnerUrl, true), gettype($partnerUrl)), __LINE__);
        }
        $this->PartnerUrl = $partnerUrl;
        return $this;
    }
    /**
     * Get Notification value
     * @return \StructType\CaseNotification[]|null
     */
    public function getNotification()
    {
        return $this->Notification;
    }
    /**
     * This method is responsible for validating the values passed to the setNotification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotificationForArrayConstraintsFromSetNotification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $notificationsNotificationItem) {
            // validation for constraint: itemType
            if (!$notificationsNotificationItem instanceof \StructType\CaseNotification) {
                $invalidValues[] = is_object($notificationsNotificationItem) ? get_class($notificationsNotificationItem) : sprintf('%s(%s)', gettype($notificationsNotificationItem), var_export($notificationsNotificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Notification property can only contain items of type \StructType\CaseNotification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Notification value
     * @throws \InvalidArgumentException
     * @param \StructType\CaseNotification[] $notification
     * @return \StructType\Notifications
     */
    public function setNotification(array $notification = array())
    {
        // validation for constraint: array
        if ('' !== ($notificationArrayErrorMessage = self::validateNotificationForArrayConstraintsFromSetNotification($notification))) {
            throw new \InvalidArgumentException($notificationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(100)
        if (is_array($notification) && count($notification) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 100', count($notification)), __LINE__);
        }
        $this->Notification = $notification;
        return $this;
    }
    /**
     * Add item to Notification value
     * @throws \InvalidArgumentException
     * @param \StructType\CaseNotification $item
     * @return \StructType\Notifications
     */
    public function addToNotification(\StructType\CaseNotification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CaseNotification) {
            throw new \InvalidArgumentException(sprintf('The Notification property can only contain items of type \StructType\CaseNotification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(100)
        if (is_array($this->Notification) && count($this->Notification) >= 100) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 100', count($this->Notification)), __LINE__);
        }
        $this->Notification[] = $item;
        return $this;
    }
}
