<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CaseNotification StructType
 * @subpackage Structs
 */
class CaseNotification extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 18
     * - pattern: [a-zA-Z0-9]{18}
     * @var string
     */
    public $Id;
    /**
     * The sObject
     * @var \StructType\_Case
     */
    public $sObject;
    /**
     * Constructor method for CaseNotification
     * @uses CaseNotification::setId()
     * @uses CaseNotification::setSObject()
     * @param string $id
     * @param \StructType\_Case $sObject
     */
    public function __construct($id = null, \StructType\_Case $sObject = null)
    {
        $this
            ->setId($id)
            ->setSObject($sObject);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\CaseNotification
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: length(18)
        if (!is_null($id) && mb_strlen($id) !== 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 18', mb_strlen($id)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{18})
        if (!is_null($id) && !preg_match('/[a-zA-Z0-9]{18}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{18}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get sObject value
     * @return \StructType\_Case|null
     */
    public function getSObject()
    {
        return $this->sObject;
    }
    /**
     * Set sObject value
     * @param \StructType\_Case $sObject
     * @return \StructType\CaseNotification
     */
    public function setSObject(\StructType\_Case $sObject = null)
    {
        $this->sObject = $sObject;
        return $this;
    }
}
