<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Notifications ServiceType
 * @subpackage Services
 */
class Notifications extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named notifications
     * Meta information extracted from the WSDL
     * - documentation: Process a number of notifications.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Notifications $request
     * @return \StructType\NotificationsResponse|bool
     */
    public function notifications(\StructType\Notifications $request)
    {
        try {
            $this->setResult($this->getSoapClient()->notifications($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\NotificationsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
