<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateIbtRequest StructType
 * @subpackage Structs
 */
class UpdateIbtRequest extends BaseRequest
{
    /**
     * The DocumentNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentNo;
    /**
     * The IbtDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfUpdateIbtDetailRequest
     */
    public $IbtDetails;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * Constructor method for UpdateIbtRequest
     * @uses UpdateIbtRequest::setDocumentNo()
     * @uses UpdateIbtRequest::setIbtDetails()
     * @uses UpdateIbtRequest::setMemo()
     * @param string $documentNo
     * @param \ArrayType\ArrayOfUpdateIbtDetailRequest $ibtDetails
     * @param string $memo
     */
    public function __construct($documentNo = null, \ArrayType\ArrayOfUpdateIbtDetailRequest $ibtDetails = null, $memo = null)
    {
        $this
            ->setDocumentNo($documentNo)
            ->setIbtDetails($ibtDetails)
            ->setMemo($memo);
    }
    /**
     * Get DocumentNo value
     * @return string|null
     */
    public function getDocumentNo()
    {
        return $this->DocumentNo;
    }
    /**
     * Set DocumentNo value
     * @param string $documentNo
     * @return \StructType\UpdateIbtRequest
     */
    public function setDocumentNo($documentNo = null)
    {
        // validation for constraint: string
        if (!is_null($documentNo) && !is_string($documentNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentNo, true), gettype($documentNo)), __LINE__);
        }
        $this->DocumentNo = $documentNo;
        return $this;
    }
    /**
     * Get IbtDetails value
     * @return \ArrayType\ArrayOfUpdateIbtDetailRequest|null
     */
    public function getIbtDetails()
    {
        return $this->IbtDetails;
    }
    /**
     * Set IbtDetails value
     * @param \ArrayType\ArrayOfUpdateIbtDetailRequest $ibtDetails
     * @return \StructType\UpdateIbtRequest
     */
    public function setIbtDetails(\ArrayType\ArrayOfUpdateIbtDetailRequest $ibtDetails = null)
    {
        $this->IbtDetails = $ibtDetails;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\UpdateIbtRequest
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
}
