<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateIbtDetailRequest StructType
 * @subpackage Structs
 */
class UpdateIbtDetailRequest extends BaseRequest
{
    /**
     * The ActualQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ActualQuantity;
    /**
     * The Ean
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ean;
    /**
     * Constructor method for UpdateIbtDetailRequest
     * @uses UpdateIbtDetailRequest::setActualQuantity()
     * @uses UpdateIbtDetailRequest::setEan()
     * @param float $actualQuantity
     * @param string $ean
     */
    public function __construct($actualQuantity = null, $ean = null)
    {
        $this
            ->setActualQuantity($actualQuantity)
            ->setEan($ean);
    }
    /**
     * Get ActualQuantity value
     * @return float
     */
    public function getActualQuantity()
    {
        return $this->ActualQuantity;
    }
    /**
     * Set ActualQuantity value
     * @param float $actualQuantity
     * @return \StructType\UpdateIbtDetailRequest
     */
    public function setActualQuantity($actualQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($actualQuantity) && !(is_float($actualQuantity) || is_numeric($actualQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($actualQuantity, true), gettype($actualQuantity)), __LINE__);
        }
        $this->ActualQuantity = $actualQuantity;
        return $this;
    }
    /**
     * Get Ean value
     * @return string|null
     */
    public function getEan()
    {
        return $this->Ean;
    }
    /**
     * Set Ean value
     * @param string $ean
     * @return \StructType\UpdateIbtDetailRequest
     */
    public function setEan($ean = null)
    {
        // validation for constraint: string
        if (!is_null($ean) && !is_string($ean)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ean, true), gettype($ean)), __LINE__);
        }
        $this->Ean = $ean;
        return $this;
    }
}
