<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaskMessage StructType
 * @subpackage Structs
 */
class TaskMessage extends AbstractStructBase
{
    /**
     * The TaskMessageLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TaskMessageLevel;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ErrorCode;
    /**
     * The EventTimestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EventTimestamp;
    /**
     * The EventKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventKey;
    /**
     * The RelatedComponent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RelatedComponent;
    /**
     * The RelatedBehaviour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RelatedBehaviour;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ExceptionMessages
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $ExceptionMessages;
    /**
     * Constructor method for TaskMessage
     * @uses TaskMessage::setTaskMessageLevel()
     * @uses TaskMessage::setErrorCode()
     * @uses TaskMessage::setEventTimestamp()
     * @uses TaskMessage::setEventKey()
     * @uses TaskMessage::setRelatedComponent()
     * @uses TaskMessage::setRelatedBehaviour()
     * @uses TaskMessage::setDescription()
     * @uses TaskMessage::setExceptionMessages()
     * @param string $taskMessageLevel
     * @param string $errorCode
     * @param string $eventTimestamp
     * @param string $eventKey
     * @param string $relatedComponent
     * @param string $relatedBehaviour
     * @param string $description
     * @param \ArrayType\ArrayOfString $exceptionMessages
     */
    public function __construct($taskMessageLevel = null, $errorCode = null, $eventTimestamp = null, $eventKey = null, $relatedComponent = null, $relatedBehaviour = null, $description = null, \ArrayType\ArrayOfString $exceptionMessages = null)
    {
        $this
            ->setTaskMessageLevel($taskMessageLevel)
            ->setErrorCode($errorCode)
            ->setEventTimestamp($eventTimestamp)
            ->setEventKey($eventKey)
            ->setRelatedComponent($relatedComponent)
            ->setRelatedBehaviour($relatedBehaviour)
            ->setDescription($description)
            ->setExceptionMessages($exceptionMessages);
    }
    /**
     * Get TaskMessageLevel value
     * @return string
     */
    public function getTaskMessageLevel()
    {
        return $this->TaskMessageLevel;
    }
    /**
     * Set TaskMessageLevel value
     * @uses \EnumType\MessageLevel::valueIsValid()
     * @uses \EnumType\MessageLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taskMessageLevel
     * @return \StructType\TaskMessage
     */
    public function setTaskMessageLevel($taskMessageLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MessageLevel::valueIsValid($taskMessageLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MessageLevel', is_array($taskMessageLevel) ? implode(', ', $taskMessageLevel) : var_export($taskMessageLevel, true), implode(', ', \EnumType\MessageLevel::getValidValues())), __LINE__);
        }
        $this->TaskMessageLevel = $taskMessageLevel;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return string
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @uses \EnumType\MessageErrorCode::valueIsValid()
     * @uses \EnumType\MessageErrorCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorCode
     * @return \StructType\TaskMessage
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MessageErrorCode::valueIsValid($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MessageErrorCode', is_array($errorCode) ? implode(', ', $errorCode) : var_export($errorCode, true), implode(', ', \EnumType\MessageErrorCode::getValidValues())), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get EventTimestamp value
     * @return string
     */
    public function getEventTimestamp()
    {
        return $this->EventTimestamp;
    }
    /**
     * Set EventTimestamp value
     * @param string $eventTimestamp
     * @return \StructType\TaskMessage
     */
    public function setEventTimestamp($eventTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($eventTimestamp) && !is_string($eventTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTimestamp, true), gettype($eventTimestamp)), __LINE__);
        }
        $this->EventTimestamp = $eventTimestamp;
        return $this;
    }
    /**
     * Get EventKey value
     * @return string|null
     */
    public function getEventKey()
    {
        return $this->EventKey;
    }
    /**
     * Set EventKey value
     * @param string $eventKey
     * @return \StructType\TaskMessage
     */
    public function setEventKey($eventKey = null)
    {
        // validation for constraint: string
        if (!is_null($eventKey) && !is_string($eventKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventKey, true), gettype($eventKey)), __LINE__);
        }
        $this->EventKey = $eventKey;
        return $this;
    }
    /**
     * Get RelatedComponent value
     * @return string|null
     */
    public function getRelatedComponent()
    {
        return $this->RelatedComponent;
    }
    /**
     * Set RelatedComponent value
     * @param string $relatedComponent
     * @return \StructType\TaskMessage
     */
    public function setRelatedComponent($relatedComponent = null)
    {
        // validation for constraint: string
        if (!is_null($relatedComponent) && !is_string($relatedComponent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedComponent, true), gettype($relatedComponent)), __LINE__);
        }
        $this->RelatedComponent = $relatedComponent;
        return $this;
    }
    /**
     * Get RelatedBehaviour value
     * @return string|null
     */
    public function getRelatedBehaviour()
    {
        return $this->RelatedBehaviour;
    }
    /**
     * Set RelatedBehaviour value
     * @param string $relatedBehaviour
     * @return \StructType\TaskMessage
     */
    public function setRelatedBehaviour($relatedBehaviour = null)
    {
        // validation for constraint: string
        if (!is_null($relatedBehaviour) && !is_string($relatedBehaviour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedBehaviour, true), gettype($relatedBehaviour)), __LINE__);
        }
        $this->RelatedBehaviour = $relatedBehaviour;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\TaskMessage
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ExceptionMessages value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getExceptionMessages()
    {
        return $this->ExceptionMessages;
    }
    /**
     * Set ExceptionMessages value
     * @param \ArrayType\ArrayOfString $exceptionMessages
     * @return \StructType\TaskMessage
     */
    public function setExceptionMessages(\ArrayType\ArrayOfString $exceptionMessages = null)
    {
        $this->ExceptionMessages = $exceptionMessages;
        return $this;
    }
}
