<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Person StructType
 * @subpackage Structs
 */
class Person extends BaseContract_FullIDSet
{
    /**
     * The DateOfBirth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateOfBirth;
    /**
     * The Gender
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Gender;
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EntityType;
    /**
     * The LanguageISO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LanguageISO;
    /**
     * The SalutationKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalutationKey;
    /**
     * The FirstnameOrOrgname1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstnameOrOrgname1;
    /**
     * The MiddlenameOrOrgname2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MiddlenameOrOrgname2;
    /**
     * The LastnameOrOrgname3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastnameOrOrgname3;
    /**
     * The NamesuffixOrOrgname4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NamesuffixOrOrgname4;
    /**
     * The TitleOrOrgname5
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TitleOrOrgname5;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Position;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The AddressBook
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressBook
     */
    public $AddressBook;
    /**
     * The CommunicationData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCommChannel
     */
    public $CommunicationData;
    /**
     * The PostalAddresses
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAddress
     */
    public $PostalAddresses;
    /**
     * The BankAccounts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfBankAccount
     */
    public $BankAccounts;
    /**
     * The CustomerCards
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCustomerCard
     */
    public $CustomerCards;
    /**
     * Constructor method for Person
     * @uses Person::setDateOfBirth()
     * @uses Person::setGender()
     * @uses Person::setEntityType()
     * @uses Person::setLanguageISO()
     * @uses Person::setSalutationKey()
     * @uses Person::setFirstnameOrOrgname1()
     * @uses Person::setMiddlenameOrOrgname2()
     * @uses Person::setLastnameOrOrgname3()
     * @uses Person::setNamesuffixOrOrgname4()
     * @uses Person::setTitleOrOrgname5()
     * @uses Person::setPosition()
     * @uses Person::setComment()
     * @uses Person::setAddressBook()
     * @uses Person::setCommunicationData()
     * @uses Person::setPostalAddresses()
     * @uses Person::setBankAccounts()
     * @uses Person::setCustomerCards()
     * @param string $dateOfBirth
     * @param string $gender
     * @param string $entityType
     * @param string $languageISO
     * @param string $salutationKey
     * @param string $firstnameOrOrgname1
     * @param string $middlenameOrOrgname2
     * @param string $lastnameOrOrgname3
     * @param string $namesuffixOrOrgname4
     * @param string $titleOrOrgname5
     * @param string $position
     * @param string $comment
     * @param \StructType\AddressBook $addressBook
     * @param \ArrayType\ArrayOfCommChannel $communicationData
     * @param \ArrayType\ArrayOfAddress $postalAddresses
     * @param \ArrayType\ArrayOfBankAccount $bankAccounts
     * @param \ArrayType\ArrayOfCustomerCard $customerCards
     */
    public function __construct($dateOfBirth = null, $gender = null, $entityType = null, $languageISO = null, $salutationKey = null, $firstnameOrOrgname1 = null, $middlenameOrOrgname2 = null, $lastnameOrOrgname3 = null, $namesuffixOrOrgname4 = null, $titleOrOrgname5 = null, $position = null, $comment = null, \StructType\AddressBook $addressBook = null, \ArrayType\ArrayOfCommChannel $communicationData = null, \ArrayType\ArrayOfAddress $postalAddresses = null, \ArrayType\ArrayOfBankAccount $bankAccounts = null, \ArrayType\ArrayOfCustomerCard $customerCards = null)
    {
        $this
            ->setDateOfBirth($dateOfBirth)
            ->setGender($gender)
            ->setEntityType($entityType)
            ->setLanguageISO($languageISO)
            ->setSalutationKey($salutationKey)
            ->setFirstnameOrOrgname1($firstnameOrOrgname1)
            ->setMiddlenameOrOrgname2($middlenameOrOrgname2)
            ->setLastnameOrOrgname3($lastnameOrOrgname3)
            ->setNamesuffixOrOrgname4($namesuffixOrOrgname4)
            ->setTitleOrOrgname5($titleOrOrgname5)
            ->setPosition($position)
            ->setComment($comment)
            ->setAddressBook($addressBook)
            ->setCommunicationData($communicationData)
            ->setPostalAddresses($postalAddresses)
            ->setBankAccounts($bankAccounts)
            ->setCustomerCards($customerCards);
    }
    /**
     * Get DateOfBirth value
     * @return string
     */
    public function getDateOfBirth()
    {
        return $this->DateOfBirth;
    }
    /**
     * Set DateOfBirth value
     * @param string $dateOfBirth
     * @return \StructType\Person
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfBirth) && !is_string($dateOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfBirth, true), gettype($dateOfBirth)), __LINE__);
        }
        $this->DateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Get Gender value
     * @return string
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @uses \EnumType\ContactGender::valueIsValid()
     * @uses \EnumType\ContactGender::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \StructType\Person
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContactGender::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ContactGender', is_array($gender) ? implode(', ', $gender) : var_export($gender, true), implode(', ', \EnumType\ContactGender::getValidValues())), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get EntityType value
     * @return string
     */
    public function getEntityType()
    {
        return $this->EntityType;
    }
    /**
     * Set EntityType value
     * @uses \EnumType\EntityType::valueIsValid()
     * @uses \EnumType\EntityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $entityType
     * @return \StructType\Person
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EntityType::valueIsValid($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EntityType', is_array($entityType) ? implode(', ', $entityType) : var_export($entityType, true), implode(', ', \EnumType\EntityType::getValidValues())), __LINE__);
        }
        $this->EntityType = $entityType;
        return $this;
    }
    /**
     * Get LanguageISO value
     * @return string|null
     */
    public function getLanguageISO()
    {
        return $this->LanguageISO;
    }
    /**
     * Set LanguageISO value
     * @param string $languageISO
     * @return \StructType\Person
     */
    public function setLanguageISO($languageISO = null)
    {
        // validation for constraint: string
        if (!is_null($languageISO) && !is_string($languageISO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageISO, true), gettype($languageISO)), __LINE__);
        }
        $this->LanguageISO = $languageISO;
        return $this;
    }
    /**
     * Get SalutationKey value
     * @return string|null
     */
    public function getSalutationKey()
    {
        return $this->SalutationKey;
    }
    /**
     * Set SalutationKey value
     * @param string $salutationKey
     * @return \StructType\Person
     */
    public function setSalutationKey($salutationKey = null)
    {
        // validation for constraint: string
        if (!is_null($salutationKey) && !is_string($salutationKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salutationKey, true), gettype($salutationKey)), __LINE__);
        }
        $this->SalutationKey = $salutationKey;
        return $this;
    }
    /**
     * Get FirstnameOrOrgname1 value
     * @return string|null
     */
    public function getFirstnameOrOrgname1()
    {
        return $this->FirstnameOrOrgname1;
    }
    /**
     * Set FirstnameOrOrgname1 value
     * @param string $firstnameOrOrgname1
     * @return \StructType\Person
     */
    public function setFirstnameOrOrgname1($firstnameOrOrgname1 = null)
    {
        // validation for constraint: string
        if (!is_null($firstnameOrOrgname1) && !is_string($firstnameOrOrgname1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstnameOrOrgname1, true), gettype($firstnameOrOrgname1)), __LINE__);
        }
        $this->FirstnameOrOrgname1 = $firstnameOrOrgname1;
        return $this;
    }
    /**
     * Get MiddlenameOrOrgname2 value
     * @return string|null
     */
    public function getMiddlenameOrOrgname2()
    {
        return $this->MiddlenameOrOrgname2;
    }
    /**
     * Set MiddlenameOrOrgname2 value
     * @param string $middlenameOrOrgname2
     * @return \StructType\Person
     */
    public function setMiddlenameOrOrgname2($middlenameOrOrgname2 = null)
    {
        // validation for constraint: string
        if (!is_null($middlenameOrOrgname2) && !is_string($middlenameOrOrgname2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middlenameOrOrgname2, true), gettype($middlenameOrOrgname2)), __LINE__);
        }
        $this->MiddlenameOrOrgname2 = $middlenameOrOrgname2;
        return $this;
    }
    /**
     * Get LastnameOrOrgname3 value
     * @return string|null
     */
    public function getLastnameOrOrgname3()
    {
        return $this->LastnameOrOrgname3;
    }
    /**
     * Set LastnameOrOrgname3 value
     * @param string $lastnameOrOrgname3
     * @return \StructType\Person
     */
    public function setLastnameOrOrgname3($lastnameOrOrgname3 = null)
    {
        // validation for constraint: string
        if (!is_null($lastnameOrOrgname3) && !is_string($lastnameOrOrgname3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastnameOrOrgname3, true), gettype($lastnameOrOrgname3)), __LINE__);
        }
        $this->LastnameOrOrgname3 = $lastnameOrOrgname3;
        return $this;
    }
    /**
     * Get NamesuffixOrOrgname4 value
     * @return string|null
     */
    public function getNamesuffixOrOrgname4()
    {
        return $this->NamesuffixOrOrgname4;
    }
    /**
     * Set NamesuffixOrOrgname4 value
     * @param string $namesuffixOrOrgname4
     * @return \StructType\Person
     */
    public function setNamesuffixOrOrgname4($namesuffixOrOrgname4 = null)
    {
        // validation for constraint: string
        if (!is_null($namesuffixOrOrgname4) && !is_string($namesuffixOrOrgname4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($namesuffixOrOrgname4, true), gettype($namesuffixOrOrgname4)), __LINE__);
        }
        $this->NamesuffixOrOrgname4 = $namesuffixOrOrgname4;
        return $this;
    }
    /**
     * Get TitleOrOrgname5 value
     * @return string|null
     */
    public function getTitleOrOrgname5()
    {
        return $this->TitleOrOrgname5;
    }
    /**
     * Set TitleOrOrgname5 value
     * @param string $titleOrOrgname5
     * @return \StructType\Person
     */
    public function setTitleOrOrgname5($titleOrOrgname5 = null)
    {
        // validation for constraint: string
        if (!is_null($titleOrOrgname5) && !is_string($titleOrOrgname5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titleOrOrgname5, true), gettype($titleOrOrgname5)), __LINE__);
        }
        $this->TitleOrOrgname5 = $titleOrOrgname5;
        return $this;
    }
    /**
     * Get Position value
     * @return string|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param string $position
     * @return \StructType\Person
     */
    public function setPosition($position = null)
    {
        // validation for constraint: string
        if (!is_null($position) && !is_string($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($position, true), gettype($position)), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Person
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get AddressBook value
     * @return \StructType\AddressBook|null
     */
    public function getAddressBook()
    {
        return $this->AddressBook;
    }
    /**
     * Set AddressBook value
     * @param \StructType\AddressBook $addressBook
     * @return \StructType\Person
     */
    public function setAddressBook(\StructType\AddressBook $addressBook = null)
    {
        $this->AddressBook = $addressBook;
        return $this;
    }
    /**
     * Get CommunicationData value
     * @return \ArrayType\ArrayOfCommChannel|null
     */
    public function getCommunicationData()
    {
        return $this->CommunicationData;
    }
    /**
     * Set CommunicationData value
     * @param \ArrayType\ArrayOfCommChannel $communicationData
     * @return \StructType\Person
     */
    public function setCommunicationData(\ArrayType\ArrayOfCommChannel $communicationData = null)
    {
        $this->CommunicationData = $communicationData;
        return $this;
    }
    /**
     * Get PostalAddresses value
     * @return \ArrayType\ArrayOfAddress|null
     */
    public function getPostalAddresses()
    {
        return $this->PostalAddresses;
    }
    /**
     * Set PostalAddresses value
     * @param \ArrayType\ArrayOfAddress $postalAddresses
     * @return \StructType\Person
     */
    public function setPostalAddresses(\ArrayType\ArrayOfAddress $postalAddresses = null)
    {
        $this->PostalAddresses = $postalAddresses;
        return $this;
    }
    /**
     * Get BankAccounts value
     * @return \ArrayType\ArrayOfBankAccount|null
     */
    public function getBankAccounts()
    {
        return $this->BankAccounts;
    }
    /**
     * Set BankAccounts value
     * @param \ArrayType\ArrayOfBankAccount $bankAccounts
     * @return \StructType\Person
     */
    public function setBankAccounts(\ArrayType\ArrayOfBankAccount $bankAccounts = null)
    {
        $this->BankAccounts = $bankAccounts;
        return $this;
    }
    /**
     * Get CustomerCards value
     * @return \ArrayType\ArrayOfCustomerCard|null
     */
    public function getCustomerCards()
    {
        return $this->CustomerCards;
    }
    /**
     * Set CustomerCards value
     * @param \ArrayType\ArrayOfCustomerCard $customerCards
     * @return \StructType\Person
     */
    public function setCustomerCards(\ArrayType\ArrayOfCustomerCard $customerCards = null)
    {
        $this->CustomerCards = $customerCards;
        return $this;
    }
}
