<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderStockPosition StructType
 * @subpackage Structs
 */
class OrderStockPosition extends AbstractStructBase
{
    /**
     * The LastMove
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastMove;
    /**
     * The OrderedQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OrderedQuantity;
    /**
     * The ReservedQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ReservedQuantity;
    /**
     * The QuantityWithoutDeliveryNotes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $QuantityWithoutDeliveryNotes;
    /**
     * The DeliveryStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeliveryStatus;
    /**
     * The EAN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EAN;
    /**
     * Constructor method for OrderStockPosition
     * @uses OrderStockPosition::setLastMove()
     * @uses OrderStockPosition::setOrderedQuantity()
     * @uses OrderStockPosition::setReservedQuantity()
     * @uses OrderStockPosition::setQuantityWithoutDeliveryNotes()
     * @uses OrderStockPosition::setDeliveryStatus()
     * @uses OrderStockPosition::setEAN()
     * @param string $lastMove
     * @param float $orderedQuantity
     * @param float $reservedQuantity
     * @param float $quantityWithoutDeliveryNotes
     * @param string $deliveryStatus
     * @param string $eAN
     */
    public function __construct($lastMove = null, $orderedQuantity = null, $reservedQuantity = null, $quantityWithoutDeliveryNotes = null, $deliveryStatus = null, $eAN = null)
    {
        $this
            ->setLastMove($lastMove)
            ->setOrderedQuantity($orderedQuantity)
            ->setReservedQuantity($reservedQuantity)
            ->setQuantityWithoutDeliveryNotes($quantityWithoutDeliveryNotes)
            ->setDeliveryStatus($deliveryStatus)
            ->setEAN($eAN);
    }
    /**
     * Get LastMove value
     * @return string
     */
    public function getLastMove()
    {
        return $this->LastMove;
    }
    /**
     * Set LastMove value
     * @param string $lastMove
     * @return \StructType\OrderStockPosition
     */
    public function setLastMove($lastMove = null)
    {
        // validation for constraint: string
        if (!is_null($lastMove) && !is_string($lastMove)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastMove, true), gettype($lastMove)), __LINE__);
        }
        $this->LastMove = $lastMove;
        return $this;
    }
    /**
     * Get OrderedQuantity value
     * @return float
     */
    public function getOrderedQuantity()
    {
        return $this->OrderedQuantity;
    }
    /**
     * Set OrderedQuantity value
     * @param float $orderedQuantity
     * @return \StructType\OrderStockPosition
     */
    public function setOrderedQuantity($orderedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($orderedQuantity) && !(is_float($orderedQuantity) || is_numeric($orderedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderedQuantity, true), gettype($orderedQuantity)), __LINE__);
        }
        $this->OrderedQuantity = $orderedQuantity;
        return $this;
    }
    /**
     * Get ReservedQuantity value
     * @return float
     */
    public function getReservedQuantity()
    {
        return $this->ReservedQuantity;
    }
    /**
     * Set ReservedQuantity value
     * @param float $reservedQuantity
     * @return \StructType\OrderStockPosition
     */
    public function setReservedQuantity($reservedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($reservedQuantity) && !(is_float($reservedQuantity) || is_numeric($reservedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reservedQuantity, true), gettype($reservedQuantity)), __LINE__);
        }
        $this->ReservedQuantity = $reservedQuantity;
        return $this;
    }
    /**
     * Get QuantityWithoutDeliveryNotes value
     * @return float
     */
    public function getQuantityWithoutDeliveryNotes()
    {
        return $this->QuantityWithoutDeliveryNotes;
    }
    /**
     * Set QuantityWithoutDeliveryNotes value
     * @param float $quantityWithoutDeliveryNotes
     * @return \StructType\OrderStockPosition
     */
    public function setQuantityWithoutDeliveryNotes($quantityWithoutDeliveryNotes = null)
    {
        // validation for constraint: float
        if (!is_null($quantityWithoutDeliveryNotes) && !(is_float($quantityWithoutDeliveryNotes) || is_numeric($quantityWithoutDeliveryNotes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityWithoutDeliveryNotes, true), gettype($quantityWithoutDeliveryNotes)), __LINE__);
        }
        $this->QuantityWithoutDeliveryNotes = $quantityWithoutDeliveryNotes;
        return $this;
    }
    /**
     * Get DeliveryStatus value
     * @return string
     */
    public function getDeliveryStatus()
    {
        return $this->DeliveryStatus;
    }
    /**
     * Set DeliveryStatus value
     * @uses \EnumType\DeliveryStatus::valueIsValid()
     * @uses \EnumType\DeliveryStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryStatus
     * @return \StructType\OrderStockPosition
     */
    public function setDeliveryStatus($deliveryStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryStatus::valueIsValid($deliveryStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DeliveryStatus', is_array($deliveryStatus) ? implode(', ', $deliveryStatus) : var_export($deliveryStatus, true), implode(', ', \EnumType\DeliveryStatus::getValidValues())), __LINE__);
        }
        $this->DeliveryStatus = $deliveryStatus;
        return $this;
    }
    /**
     * Get EAN value
     * @return string|null
     */
    public function getEAN()
    {
        return $this->EAN;
    }
    /**
     * Set EAN value
     * @param string $eAN
     * @return \StructType\OrderStockPosition
     */
    public function setEAN($eAN = null)
    {
        // validation for constraint: string
        if (!is_null($eAN) && !is_string($eAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eAN, true), gettype($eAN)), __LINE__);
        }
        $this->EAN = $eAN;
        return $this;
    }
}
