<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManufacturerColour StructType
 * @subpackage Structs
 */
class ManufacturerColour extends BaseContract_FullIDSet
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Manufacturer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Manufacturer
     */
    public $Manufacturer;
    /**
     * The SystemColour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SystemColour
     */
    public $SystemColour;
    /**
     * Constructor method for ManufacturerColour
     * @uses ManufacturerColour::setDescription()
     * @uses ManufacturerColour::setManufacturer()
     * @uses ManufacturerColour::setSystemColour()
     * @param string $description
     * @param \StructType\Manufacturer $manufacturer
     * @param \StructType\SystemColour $systemColour
     */
    public function __construct($description = null, \StructType\Manufacturer $manufacturer = null, \StructType\SystemColour $systemColour = null)
    {
        $this
            ->setDescription($description)
            ->setManufacturer($manufacturer)
            ->setSystemColour($systemColour);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\ManufacturerColour
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Manufacturer value
     * @return \StructType\Manufacturer|null
     */
    public function getManufacturer()
    {
        return $this->Manufacturer;
    }
    /**
     * Set Manufacturer value
     * @param \StructType\Manufacturer $manufacturer
     * @return \StructType\ManufacturerColour
     */
    public function setManufacturer(\StructType\Manufacturer $manufacturer = null)
    {
        $this->Manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get SystemColour value
     * @return \StructType\SystemColour|null
     */
    public function getSystemColour()
    {
        return $this->SystemColour;
    }
    /**
     * Set SystemColour value
     * @param \StructType\SystemColour $systemColour
     * @return \StructType\ManufacturerColour
     */
    public function setSystemColour(\StructType\SystemColour $systemColour = null)
    {
        $this->SystemColour = $systemColour;
        return $this;
    }
}
