<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IterationConstraints StructType
 * @subpackage Structs
 */
class IterationConstraints extends AbstractStructBase
{
    /**
     * The BlockSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BlockSize;
    /**
     * The BlockIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BlockIndex;
    /**
     * The IterationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IterationId;
    /**
     * Constructor method for IterationConstraints
     * @uses IterationConstraints::setBlockSize()
     * @uses IterationConstraints::setBlockIndex()
     * @uses IterationConstraints::setIterationId()
     * @param int $blockSize
     * @param int $blockIndex
     * @param string $iterationId
     */
    public function __construct($blockSize = null, $blockIndex = null, $iterationId = null)
    {
        $this
            ->setBlockSize($blockSize)
            ->setBlockIndex($blockIndex)
            ->setIterationId($iterationId);
    }
    /**
     * Get BlockSize value
     * @return int
     */
    public function getBlockSize()
    {
        return $this->BlockSize;
    }
    /**
     * Set BlockSize value
     * @param int $blockSize
     * @return \StructType\IterationConstraints
     */
    public function setBlockSize($blockSize = null)
    {
        // validation for constraint: int
        if (!is_null($blockSize) && !(is_int($blockSize) || ctype_digit($blockSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($blockSize, true), gettype($blockSize)), __LINE__);
        }
        $this->BlockSize = $blockSize;
        return $this;
    }
    /**
     * Get BlockIndex value
     * @return int
     */
    public function getBlockIndex()
    {
        return $this->BlockIndex;
    }
    /**
     * Set BlockIndex value
     * @param int $blockIndex
     * @return \StructType\IterationConstraints
     */
    public function setBlockIndex($blockIndex = null)
    {
        // validation for constraint: int
        if (!is_null($blockIndex) && !(is_int($blockIndex) || ctype_digit($blockIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($blockIndex, true), gettype($blockIndex)), __LINE__);
        }
        $this->BlockIndex = $blockIndex;
        return $this;
    }
    /**
     * Get IterationId value
     * @return string|null
     */
    public function getIterationId()
    {
        return $this->IterationId;
    }
    /**
     * Set IterationId value
     * @param string $iterationId
     * @return \StructType\IterationConstraints
     */
    public function setIterationId($iterationId = null)
    {
        // validation for constraint: string
        if (!is_null($iterationId) && !is_string($iterationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iterationId, true), gettype($iterationId)), __LINE__);
        }
        $this->IterationId = $iterationId;
        return $this;
    }
}
