<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice StructType
 * @subpackage Structs
 */
class Invoice extends BaseContract_FullIDSet
{
    /**
     * The LastChange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastChange;
    /**
     * The InvoiceTimestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InvoiceTimestamp;
    /**
     * The DeliveryNoteId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryNoteId;
    /**
     * The ShopId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerId;
    /**
     * The ShopCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopCustomerId;
    /**
     * The InvoicePositions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInvoicePosition
     */
    public $InvoicePositions;
    /**
     * Constructor method for Invoice
     * @uses Invoice::setLastChange()
     * @uses Invoice::setInvoiceTimestamp()
     * @uses Invoice::setDeliveryNoteId()
     * @uses Invoice::setShopId()
     * @uses Invoice::setCustomerId()
     * @uses Invoice::setShopCustomerId()
     * @uses Invoice::setInvoicePositions()
     * @param string $lastChange
     * @param string $invoiceTimestamp
     * @param string $deliveryNoteId
     * @param string $shopId
     * @param string $customerId
     * @param string $shopCustomerId
     * @param \ArrayType\ArrayOfInvoicePosition $invoicePositions
     */
    public function __construct($lastChange = null, $invoiceTimestamp = null, $deliveryNoteId = null, $shopId = null, $customerId = null, $shopCustomerId = null, \ArrayType\ArrayOfInvoicePosition $invoicePositions = null)
    {
        $this
            ->setLastChange($lastChange)
            ->setInvoiceTimestamp($invoiceTimestamp)
            ->setDeliveryNoteId($deliveryNoteId)
            ->setShopId($shopId)
            ->setCustomerId($customerId)
            ->setShopCustomerId($shopCustomerId)
            ->setInvoicePositions($invoicePositions);
    }
    /**
     * Get LastChange value
     * @return string
     */
    public function getLastChange()
    {
        return $this->LastChange;
    }
    /**
     * Set LastChange value
     * @param string $lastChange
     * @return \StructType\Invoice
     */
    public function setLastChange($lastChange = null)
    {
        // validation for constraint: string
        if (!is_null($lastChange) && !is_string($lastChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastChange, true), gettype($lastChange)), __LINE__);
        }
        $this->LastChange = $lastChange;
        return $this;
    }
    /**
     * Get InvoiceTimestamp value
     * @return string
     */
    public function getInvoiceTimestamp()
    {
        return $this->InvoiceTimestamp;
    }
    /**
     * Set InvoiceTimestamp value
     * @param string $invoiceTimestamp
     * @return \StructType\Invoice
     */
    public function setInvoiceTimestamp($invoiceTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceTimestamp) && !is_string($invoiceTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceTimestamp, true), gettype($invoiceTimestamp)), __LINE__);
        }
        $this->InvoiceTimestamp = $invoiceTimestamp;
        return $this;
    }
    /**
     * Get DeliveryNoteId value
     * @return string|null
     */
    public function getDeliveryNoteId()
    {
        return $this->DeliveryNoteId;
    }
    /**
     * Set DeliveryNoteId value
     * @param string $deliveryNoteId
     * @return \StructType\Invoice
     */
    public function setDeliveryNoteId($deliveryNoteId = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryNoteId) && !is_string($deliveryNoteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryNoteId, true), gettype($deliveryNoteId)), __LINE__);
        }
        $this->DeliveryNoteId = $deliveryNoteId;
        return $this;
    }
    /**
     * Get ShopId value
     * @return string|null
     */
    public function getShopId()
    {
        return $this->ShopId;
    }
    /**
     * Set ShopId value
     * @param string $shopId
     * @return \StructType\Invoice
     */
    public function setShopId($shopId = null)
    {
        // validation for constraint: string
        if (!is_null($shopId) && !is_string($shopId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopId, true), gettype($shopId)), __LINE__);
        }
        $this->ShopId = $shopId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param string $customerId
     * @return \StructType\Invoice
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get ShopCustomerId value
     * @return string|null
     */
    public function getShopCustomerId()
    {
        return $this->ShopCustomerId;
    }
    /**
     * Set ShopCustomerId value
     * @param string $shopCustomerId
     * @return \StructType\Invoice
     */
    public function setShopCustomerId($shopCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($shopCustomerId) && !is_string($shopCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopCustomerId, true), gettype($shopCustomerId)), __LINE__);
        }
        $this->ShopCustomerId = $shopCustomerId;
        return $this;
    }
    /**
     * Get InvoicePositions value
     * @return \ArrayType\ArrayOfInvoicePosition|null
     */
    public function getInvoicePositions()
    {
        return $this->InvoicePositions;
    }
    /**
     * Set InvoicePositions value
     * @param \ArrayType\ArrayOfInvoicePosition $invoicePositions
     * @return \StructType\Invoice
     */
    public function setInvoicePositions(\ArrayType\ArrayOfInvoicePosition $invoicePositions = null)
    {
        $this->InvoicePositions = $invoicePositions;
        return $this;
    }
}
