<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterBranchTransferDetail StructType
 * @subpackage Structs
 */
class InterBranchTransferDetail extends AbstractStructBase
{
    /**
     * The Oid
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $Oid;
    /**
     * The DateReceived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateReceived;
    /**
     * The DateSent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateSent;
    /**
     * The PositionNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PositionNo;
    /**
     * The PosPpSending
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PosPpSending;
    /**
     * The PosPpReceiving
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PosPpReceiving;
    /**
     * The PosSpSending
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PosSpSending;
    /**
     * The PosSpReceiving
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PosSpReceiving;
    /**
     * The PpReceiving
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PpReceiving;
    /**
     * The PpSending
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PpSending;
    /**
     * The SpReceiving
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SpReceiving;
    /**
     * The SpSending
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SpSending;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Quantity;
    /**
     * The QtyReceived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $QtyReceived;
    /**
     * The QtySent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $QtySent;
    /**
     * The BranchNoSending
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BranchNoSending;
    /**
     * The BranchNoReceiving
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BranchNoReceiving;
    /**
     * The ArticleDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArticleDesc;
    /**
     * The ArticleNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArticleNo;
    /**
     * The ArticleOid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArticleOid;
    /**
     * The Color
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Color;
    /**
     * The Size
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Size;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The SupplierColor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SupplierColor;
    /**
     * The SupplierDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SupplierDesc;
    /**
     * The UnitOfMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitOfMeasure;
    /**
     * The EanNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EanNo;
    /**
     * The EanOid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EanOid;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * Constructor method for InterBranchTransferDetail
     * @uses InterBranchTransferDetail::setOid()
     * @uses InterBranchTransferDetail::setDateReceived()
     * @uses InterBranchTransferDetail::setDateSent()
     * @uses InterBranchTransferDetail::setPositionNo()
     * @uses InterBranchTransferDetail::setPosPpSending()
     * @uses InterBranchTransferDetail::setPosPpReceiving()
     * @uses InterBranchTransferDetail::setPosSpSending()
     * @uses InterBranchTransferDetail::setPosSpReceiving()
     * @uses InterBranchTransferDetail::setPpReceiving()
     * @uses InterBranchTransferDetail::setPpSending()
     * @uses InterBranchTransferDetail::setSpReceiving()
     * @uses InterBranchTransferDetail::setSpSending()
     * @uses InterBranchTransferDetail::setQuantity()
     * @uses InterBranchTransferDetail::setQtyReceived()
     * @uses InterBranchTransferDetail::setQtySent()
     * @uses InterBranchTransferDetail::setBranchNoSending()
     * @uses InterBranchTransferDetail::setBranchNoReceiving()
     * @uses InterBranchTransferDetail::setArticleDesc()
     * @uses InterBranchTransferDetail::setArticleNo()
     * @uses InterBranchTransferDetail::setArticleOid()
     * @uses InterBranchTransferDetail::setColor()
     * @uses InterBranchTransferDetail::setSize()
     * @uses InterBranchTransferDetail::setState()
     * @uses InterBranchTransferDetail::setSupplierColor()
     * @uses InterBranchTransferDetail::setSupplierDesc()
     * @uses InterBranchTransferDetail::setUnitOfMeasure()
     * @uses InterBranchTransferDetail::setEanNo()
     * @uses InterBranchTransferDetail::setEanOid()
     * @uses InterBranchTransferDetail::setMemo()
     * @param string $oid
     * @param string $dateReceived
     * @param string $dateSent
     * @param int $positionNo
     * @param float $posPpSending
     * @param float $posPpReceiving
     * @param float $posSpSending
     * @param float $posSpReceiving
     * @param float $ppReceiving
     * @param float $ppSending
     * @param float $spReceiving
     * @param float $spSending
     * @param float $quantity
     * @param float $qtyReceived
     * @param float $qtySent
     * @param int $branchNoSending
     * @param int $branchNoReceiving
     * @param string $articleDesc
     * @param string $articleNo
     * @param string $articleOid
     * @param string $color
     * @param string $size
     * @param string $state
     * @param string $supplierColor
     * @param string $supplierDesc
     * @param string $unitOfMeasure
     * @param string $eanNo
     * @param string $eanOid
     * @param string $memo
     */
    public function __construct($oid = null, $dateReceived = null, $dateSent = null, $positionNo = null, $posPpSending = null, $posPpReceiving = null, $posSpSending = null, $posSpReceiving = null, $ppReceiving = null, $ppSending = null, $spReceiving = null, $spSending = null, $quantity = null, $qtyReceived = null, $qtySent = null, $branchNoSending = null, $branchNoReceiving = null, $articleDesc = null, $articleNo = null, $articleOid = null, $color = null, $size = null, $state = null, $supplierColor = null, $supplierDesc = null, $unitOfMeasure = null, $eanNo = null, $eanOid = null, $memo = null)
    {
        $this
            ->setOid($oid)
            ->setDateReceived($dateReceived)
            ->setDateSent($dateSent)
            ->setPositionNo($positionNo)
            ->setPosPpSending($posPpSending)
            ->setPosPpReceiving($posPpReceiving)
            ->setPosSpSending($posSpSending)
            ->setPosSpReceiving($posSpReceiving)
            ->setPpReceiving($ppReceiving)
            ->setPpSending($ppSending)
            ->setSpReceiving($spReceiving)
            ->setSpSending($spSending)
            ->setQuantity($quantity)
            ->setQtyReceived($qtyReceived)
            ->setQtySent($qtySent)
            ->setBranchNoSending($branchNoSending)
            ->setBranchNoReceiving($branchNoReceiving)
            ->setArticleDesc($articleDesc)
            ->setArticleNo($articleNo)
            ->setArticleOid($articleOid)
            ->setColor($color)
            ->setSize($size)
            ->setState($state)
            ->setSupplierColor($supplierColor)
            ->setSupplierDesc($supplierDesc)
            ->setUnitOfMeasure($unitOfMeasure)
            ->setEanNo($eanNo)
            ->setEanOid($eanOid)
            ->setMemo($memo);
    }
    /**
     * Get Oid value
     * @return string
     */
    public function getOid()
    {
        return $this->Oid;
    }
    /**
     * Set Oid value
     * @param string $oid
     * @return \StructType\InterBranchTransferDetail
     */
    public function setOid($oid = null)
    {
        // validation for constraint: string
        if (!is_null($oid) && !is_string($oid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oid, true), gettype($oid)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($oid) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $oid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($oid, true)), __LINE__);
        }
        $this->Oid = $oid;
        return $this;
    }
    /**
     * Get DateReceived value
     * @return string
     */
    public function getDateReceived()
    {
        return $this->DateReceived;
    }
    /**
     * Set DateReceived value
     * @param string $dateReceived
     * @return \StructType\InterBranchTransferDetail
     */
    public function setDateReceived($dateReceived = null)
    {
        // validation for constraint: string
        if (!is_null($dateReceived) && !is_string($dateReceived)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateReceived, true), gettype($dateReceived)), __LINE__);
        }
        $this->DateReceived = $dateReceived;
        return $this;
    }
    /**
     * Get DateSent value
     * @return string
     */
    public function getDateSent()
    {
        return $this->DateSent;
    }
    /**
     * Set DateSent value
     * @param string $dateSent
     * @return \StructType\InterBranchTransferDetail
     */
    public function setDateSent($dateSent = null)
    {
        // validation for constraint: string
        if (!is_null($dateSent) && !is_string($dateSent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateSent, true), gettype($dateSent)), __LINE__);
        }
        $this->DateSent = $dateSent;
        return $this;
    }
    /**
     * Get PositionNo value
     * @return int
     */
    public function getPositionNo()
    {
        return $this->PositionNo;
    }
    /**
     * Set PositionNo value
     * @param int $positionNo
     * @return \StructType\InterBranchTransferDetail
     */
    public function setPositionNo($positionNo = null)
    {
        // validation for constraint: int
        if (!is_null($positionNo) && !(is_int($positionNo) || ctype_digit($positionNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($positionNo, true), gettype($positionNo)), __LINE__);
        }
        $this->PositionNo = $positionNo;
        return $this;
    }
    /**
     * Get PosPpSending value
     * @return float
     */
    public function getPosPpSending()
    {
        return $this->PosPpSending;
    }
    /**
     * Set PosPpSending value
     * @param float $posPpSending
     * @return \StructType\InterBranchTransferDetail
     */
    public function setPosPpSending($posPpSending = null)
    {
        // validation for constraint: float
        if (!is_null($posPpSending) && !(is_float($posPpSending) || is_numeric($posPpSending))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($posPpSending, true), gettype($posPpSending)), __LINE__);
        }
        $this->PosPpSending = $posPpSending;
        return $this;
    }
    /**
     * Get PosPpReceiving value
     * @return float
     */
    public function getPosPpReceiving()
    {
        return $this->PosPpReceiving;
    }
    /**
     * Set PosPpReceiving value
     * @param float $posPpReceiving
     * @return \StructType\InterBranchTransferDetail
     */
    public function setPosPpReceiving($posPpReceiving = null)
    {
        // validation for constraint: float
        if (!is_null($posPpReceiving) && !(is_float($posPpReceiving) || is_numeric($posPpReceiving))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($posPpReceiving, true), gettype($posPpReceiving)), __LINE__);
        }
        $this->PosPpReceiving = $posPpReceiving;
        return $this;
    }
    /**
     * Get PosSpSending value
     * @return float
     */
    public function getPosSpSending()
    {
        return $this->PosSpSending;
    }
    /**
     * Set PosSpSending value
     * @param float $posSpSending
     * @return \StructType\InterBranchTransferDetail
     */
    public function setPosSpSending($posSpSending = null)
    {
        // validation for constraint: float
        if (!is_null($posSpSending) && !(is_float($posSpSending) || is_numeric($posSpSending))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($posSpSending, true), gettype($posSpSending)), __LINE__);
        }
        $this->PosSpSending = $posSpSending;
        return $this;
    }
    /**
     * Get PosSpReceiving value
     * @return float
     */
    public function getPosSpReceiving()
    {
        return $this->PosSpReceiving;
    }
    /**
     * Set PosSpReceiving value
     * @param float $posSpReceiving
     * @return \StructType\InterBranchTransferDetail
     */
    public function setPosSpReceiving($posSpReceiving = null)
    {
        // validation for constraint: float
        if (!is_null($posSpReceiving) && !(is_float($posSpReceiving) || is_numeric($posSpReceiving))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($posSpReceiving, true), gettype($posSpReceiving)), __LINE__);
        }
        $this->PosSpReceiving = $posSpReceiving;
        return $this;
    }
    /**
     * Get PpReceiving value
     * @return float
     */
    public function getPpReceiving()
    {
        return $this->PpReceiving;
    }
    /**
     * Set PpReceiving value
     * @param float $ppReceiving
     * @return \StructType\InterBranchTransferDetail
     */
    public function setPpReceiving($ppReceiving = null)
    {
        // validation for constraint: float
        if (!is_null($ppReceiving) && !(is_float($ppReceiving) || is_numeric($ppReceiving))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ppReceiving, true), gettype($ppReceiving)), __LINE__);
        }
        $this->PpReceiving = $ppReceiving;
        return $this;
    }
    /**
     * Get PpSending value
     * @return float
     */
    public function getPpSending()
    {
        return $this->PpSending;
    }
    /**
     * Set PpSending value
     * @param float $ppSending
     * @return \StructType\InterBranchTransferDetail
     */
    public function setPpSending($ppSending = null)
    {
        // validation for constraint: float
        if (!is_null($ppSending) && !(is_float($ppSending) || is_numeric($ppSending))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ppSending, true), gettype($ppSending)), __LINE__);
        }
        $this->PpSending = $ppSending;
        return $this;
    }
    /**
     * Get SpReceiving value
     * @return float
     */
    public function getSpReceiving()
    {
        return $this->SpReceiving;
    }
    /**
     * Set SpReceiving value
     * @param float $spReceiving
     * @return \StructType\InterBranchTransferDetail
     */
    public function setSpReceiving($spReceiving = null)
    {
        // validation for constraint: float
        if (!is_null($spReceiving) && !(is_float($spReceiving) || is_numeric($spReceiving))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($spReceiving, true), gettype($spReceiving)), __LINE__);
        }
        $this->SpReceiving = $spReceiving;
        return $this;
    }
    /**
     * Get SpSending value
     * @return float
     */
    public function getSpSending()
    {
        return $this->SpSending;
    }
    /**
     * Set SpSending value
     * @param float $spSending
     * @return \StructType\InterBranchTransferDetail
     */
    public function setSpSending($spSending = null)
    {
        // validation for constraint: float
        if (!is_null($spSending) && !(is_float($spSending) || is_numeric($spSending))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($spSending, true), gettype($spSending)), __LINE__);
        }
        $this->SpSending = $spSending;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\InterBranchTransferDetail
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get QtyReceived value
     * @return float
     */
    public function getQtyReceived()
    {
        return $this->QtyReceived;
    }
    /**
     * Set QtyReceived value
     * @param float $qtyReceived
     * @return \StructType\InterBranchTransferDetail
     */
    public function setQtyReceived($qtyReceived = null)
    {
        // validation for constraint: float
        if (!is_null($qtyReceived) && !(is_float($qtyReceived) || is_numeric($qtyReceived))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qtyReceived, true), gettype($qtyReceived)), __LINE__);
        }
        $this->QtyReceived = $qtyReceived;
        return $this;
    }
    /**
     * Get QtySent value
     * @return float
     */
    public function getQtySent()
    {
        return $this->QtySent;
    }
    /**
     * Set QtySent value
     * @param float $qtySent
     * @return \StructType\InterBranchTransferDetail
     */
    public function setQtySent($qtySent = null)
    {
        // validation for constraint: float
        if (!is_null($qtySent) && !(is_float($qtySent) || is_numeric($qtySent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qtySent, true), gettype($qtySent)), __LINE__);
        }
        $this->QtySent = $qtySent;
        return $this;
    }
    /**
     * Get BranchNoSending value
     * @return int
     */
    public function getBranchNoSending()
    {
        return $this->BranchNoSending;
    }
    /**
     * Set BranchNoSending value
     * @param int $branchNoSending
     * @return \StructType\InterBranchTransferDetail
     */
    public function setBranchNoSending($branchNoSending = null)
    {
        // validation for constraint: int
        if (!is_null($branchNoSending) && !(is_int($branchNoSending) || ctype_digit($branchNoSending))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchNoSending, true), gettype($branchNoSending)), __LINE__);
        }
        $this->BranchNoSending = $branchNoSending;
        return $this;
    }
    /**
     * Get BranchNoReceiving value
     * @return int
     */
    public function getBranchNoReceiving()
    {
        return $this->BranchNoReceiving;
    }
    /**
     * Set BranchNoReceiving value
     * @param int $branchNoReceiving
     * @return \StructType\InterBranchTransferDetail
     */
    public function setBranchNoReceiving($branchNoReceiving = null)
    {
        // validation for constraint: int
        if (!is_null($branchNoReceiving) && !(is_int($branchNoReceiving) || ctype_digit($branchNoReceiving))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchNoReceiving, true), gettype($branchNoReceiving)), __LINE__);
        }
        $this->BranchNoReceiving = $branchNoReceiving;
        return $this;
    }
    /**
     * Get ArticleDesc value
     * @return string|null
     */
    public function getArticleDesc()
    {
        return $this->ArticleDesc;
    }
    /**
     * Set ArticleDesc value
     * @param string $articleDesc
     * @return \StructType\InterBranchTransferDetail
     */
    public function setArticleDesc($articleDesc = null)
    {
        // validation for constraint: string
        if (!is_null($articleDesc) && !is_string($articleDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleDesc, true), gettype($articleDesc)), __LINE__);
        }
        $this->ArticleDesc = $articleDesc;
        return $this;
    }
    /**
     * Get ArticleNo value
     * @return string|null
     */
    public function getArticleNo()
    {
        return $this->ArticleNo;
    }
    /**
     * Set ArticleNo value
     * @param string $articleNo
     * @return \StructType\InterBranchTransferDetail
     */
    public function setArticleNo($articleNo = null)
    {
        // validation for constraint: string
        if (!is_null($articleNo) && !is_string($articleNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleNo, true), gettype($articleNo)), __LINE__);
        }
        $this->ArticleNo = $articleNo;
        return $this;
    }
    /**
     * Get ArticleOid value
     * @return string|null
     */
    public function getArticleOid()
    {
        return $this->ArticleOid;
    }
    /**
     * Set ArticleOid value
     * @param string $articleOid
     * @return \StructType\InterBranchTransferDetail
     */
    public function setArticleOid($articleOid = null)
    {
        // validation for constraint: string
        if (!is_null($articleOid) && !is_string($articleOid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($articleOid, true), gettype($articleOid)), __LINE__);
        }
        $this->ArticleOid = $articleOid;
        return $this;
    }
    /**
     * Get Color value
     * @return string|null
     */
    public function getColor()
    {
        return $this->Color;
    }
    /**
     * Set Color value
     * @param string $color
     * @return \StructType\InterBranchTransferDetail
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        $this->Color = $color;
        return $this;
    }
    /**
     * Get Size value
     * @return string|null
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @param string $size
     * @return \StructType\InterBranchTransferDetail
     */
    public function setSize($size = null)
    {
        // validation for constraint: string
        if (!is_null($size) && !is_string($size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        $this->Size = $size;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \StructType\InterBranchTransferDetail
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get SupplierColor value
     * @return string|null
     */
    public function getSupplierColor()
    {
        return $this->SupplierColor;
    }
    /**
     * Set SupplierColor value
     * @param string $supplierColor
     * @return \StructType\InterBranchTransferDetail
     */
    public function setSupplierColor($supplierColor = null)
    {
        // validation for constraint: string
        if (!is_null($supplierColor) && !is_string($supplierColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierColor, true), gettype($supplierColor)), __LINE__);
        }
        $this->SupplierColor = $supplierColor;
        return $this;
    }
    /**
     * Get SupplierDesc value
     * @return string|null
     */
    public function getSupplierDesc()
    {
        return $this->SupplierDesc;
    }
    /**
     * Set SupplierDesc value
     * @param string $supplierDesc
     * @return \StructType\InterBranchTransferDetail
     */
    public function setSupplierDesc($supplierDesc = null)
    {
        // validation for constraint: string
        if (!is_null($supplierDesc) && !is_string($supplierDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierDesc, true), gettype($supplierDesc)), __LINE__);
        }
        $this->SupplierDesc = $supplierDesc;
        return $this;
    }
    /**
     * Get UnitOfMeasure value
     * @return string|null
     */
    public function getUnitOfMeasure()
    {
        return $this->UnitOfMeasure;
    }
    /**
     * Set UnitOfMeasure value
     * @param string $unitOfMeasure
     * @return \StructType\InterBranchTransferDetail
     */
    public function setUnitOfMeasure($unitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasure) && !is_string($unitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasure, true), gettype($unitOfMeasure)), __LINE__);
        }
        $this->UnitOfMeasure = $unitOfMeasure;
        return $this;
    }
    /**
     * Get EanNo value
     * @return string|null
     */
    public function getEanNo()
    {
        return $this->EanNo;
    }
    /**
     * Set EanNo value
     * @param string $eanNo
     * @return \StructType\InterBranchTransferDetail
     */
    public function setEanNo($eanNo = null)
    {
        // validation for constraint: string
        if (!is_null($eanNo) && !is_string($eanNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eanNo, true), gettype($eanNo)), __LINE__);
        }
        $this->EanNo = $eanNo;
        return $this;
    }
    /**
     * Get EanOid value
     * @return string|null
     */
    public function getEanOid()
    {
        return $this->EanOid;
    }
    /**
     * Set EanOid value
     * @param string $eanOid
     * @return \StructType\InterBranchTransferDetail
     */
    public function setEanOid($eanOid = null)
    {
        // validation for constraint: string
        if (!is_null($eanOid) && !is_string($eanOid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eanOid, true), gettype($eanOid)), __LINE__);
        }
        $this->EanOid = $eanOid;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\InterBranchTransferDetail
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
}
