<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsInAdviceDetail StructType
 * @subpackage Structs
 */
class GoodsInAdviceDetail extends AbstractStructBase
{
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Position;
    /**
     * The CheckedQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CheckedQuantity;
    /**
     * The ExpectedQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ExpectedQuantity;
    /**
     * The EAN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EAN;
    /**
     * Constructor method for GoodsInAdviceDetail
     * @uses GoodsInAdviceDetail::setPosition()
     * @uses GoodsInAdviceDetail::setCheckedQuantity()
     * @uses GoodsInAdviceDetail::setExpectedQuantity()
     * @uses GoodsInAdviceDetail::setEAN()
     * @param int $position
     * @param float $checkedQuantity
     * @param float $expectedQuantity
     * @param string $eAN
     */
    public function __construct($position = null, $checkedQuantity = null, $expectedQuantity = null, $eAN = null)
    {
        $this
            ->setPosition($position)
            ->setCheckedQuantity($checkedQuantity)
            ->setExpectedQuantity($expectedQuantity)
            ->setEAN($eAN);
    }
    /**
     * Get Position value
     * @return int
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param int $position
     * @return \StructType\GoodsInAdviceDetail
     */
    public function setPosition($position = null)
    {
        // validation for constraint: int
        if (!is_null($position) && !(is_int($position) || ctype_digit($position))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($position, true), gettype($position)), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Get CheckedQuantity value
     * @return float
     */
    public function getCheckedQuantity()
    {
        return $this->CheckedQuantity;
    }
    /**
     * Set CheckedQuantity value
     * @param float $checkedQuantity
     * @return \StructType\GoodsInAdviceDetail
     */
    public function setCheckedQuantity($checkedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($checkedQuantity) && !(is_float($checkedQuantity) || is_numeric($checkedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($checkedQuantity, true), gettype($checkedQuantity)), __LINE__);
        }
        $this->CheckedQuantity = $checkedQuantity;
        return $this;
    }
    /**
     * Get ExpectedQuantity value
     * @return float
     */
    public function getExpectedQuantity()
    {
        return $this->ExpectedQuantity;
    }
    /**
     * Set ExpectedQuantity value
     * @param float $expectedQuantity
     * @return \StructType\GoodsInAdviceDetail
     */
    public function setExpectedQuantity($expectedQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($expectedQuantity) && !(is_float($expectedQuantity) || is_numeric($expectedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($expectedQuantity, true), gettype($expectedQuantity)), __LINE__);
        }
        $this->ExpectedQuantity = $expectedQuantity;
        return $this;
    }
    /**
     * Get EAN value
     * @return string|null
     */
    public function getEAN()
    {
        return $this->EAN;
    }
    /**
     * Set EAN value
     * @param string $eAN
     * @return \StructType\GoodsInAdviceDetail
     */
    public function setEAN($eAN = null)
    {
        // validation for constraint: string
        if (!is_null($eAN) && !is_string($eAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eAN, true), gettype($eAN)), __LINE__);
        }
        $this->EAN = $eAN;
        return $this;
    }
}
