<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckDeletedObjectResponse StructType
 * @subpackage Structs
 */
class CheckDeletedObjectResponse extends BaseResponse
{
    /**
     * The IsDeleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsDeleted;
    /**
     * The CheckDeletedObjectResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CheckDeletedObjectResponse
     */
    public $CheckDeletedObjectResult;
    /**
     * Constructor method for CheckDeletedObjectResponse
     * @uses CheckDeletedObjectResponse::setIsDeleted()
     * @uses CheckDeletedObjectResponse::setCheckDeletedObjectResult()
     * @param bool $isDeleted
     * @param \StructType\CheckDeletedObjectResponse $checkDeletedObjectResult
     */
    public function __construct($isDeleted = null, \StructType\CheckDeletedObjectResponse $checkDeletedObjectResult = null)
    {
        $this
            ->setIsDeleted($isDeleted)
            ->setCheckDeletedObjectResult($checkDeletedObjectResult);
    }
    /**
     * Get IsDeleted value
     * @return bool
     */
    public function getIsDeleted()
    {
        return $this->IsDeleted;
    }
    /**
     * Set IsDeleted value
     * @param bool $isDeleted
     * @return \StructType\CheckDeletedObjectResponse
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeleted, true), gettype($isDeleted)), __LINE__);
        }
        $this->IsDeleted = $isDeleted;
        return $this;
    }
    /**
     * Get CheckDeletedObjectResult value
     * @return \StructType\CheckDeletedObjectResponse|null
     */
    public function getCheckDeletedObjectResult()
    {
        return $this->CheckDeletedObjectResult;
    }
    /**
     * Set CheckDeletedObjectResult value
     * @param \StructType\CheckDeletedObjectResponse $checkDeletedObjectResult
     * @return \StructType\CheckDeletedObjectResponse
     */
    public function setCheckDeletedObjectResult(\StructType\CheckDeletedObjectResponse $checkDeletedObjectResult = null)
    {
        $this->CheckDeletedObjectResult = $checkDeletedObjectResult;
        return $this;
    }
}
