<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Brand StructType
 * @subpackage Structs
 */
class Brand extends BaseContract_FullIDSet
{
    /**
     * The StoreBrand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $StoreBrand;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for Brand
     * @uses Brand::setStoreBrand()
     * @uses Brand::setDescription()
     * @param bool $storeBrand
     * @param string $description
     */
    public function __construct($storeBrand = null, $description = null)
    {
        $this
            ->setStoreBrand($storeBrand)
            ->setDescription($description);
    }
    /**
     * Get StoreBrand value
     * @return bool
     */
    public function getStoreBrand()
    {
        return $this->StoreBrand;
    }
    /**
     * Set StoreBrand value
     * @param bool $storeBrand
     * @return \StructType\Brand
     */
    public function setStoreBrand($storeBrand = null)
    {
        // validation for constraint: boolean
        if (!is_null($storeBrand) && !is_bool($storeBrand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($storeBrand, true), gettype($storeBrand)), __LINE__);
        }
        $this->StoreBrand = $storeBrand;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Brand
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
